#!/usr/bin/ruby -w

require "optparse"
require "HRM.rb"
require "Sports_data.rb"

ProgramConfig = Hash.new
opts = OptionParser.new
opts.on("-d MANDATORY"){|val| ProgramConfig[:d] = val } 
opts.parse!(ARGV)

if ARGV.length != 3 
  puts "Error: missing operand"
  puts "gluo [-d delay] <input HRM file> <input Sports Data> <output HRM file>"
  exit
end

hrm = HRM.load(ARGV[0])
sports_data = Sports_data.load(ARGV[1])
hrm.add_speed(sports_data, ProgramConfig[:d].to_i)
hrm.save(ARGV[2])
