/**
  *
  *  Copyright 2006 GPRDC1
  *
  *  Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
  *  file except in compliance with the License. You may obtain a copy of the License at
  *
  *         http://www.apache.org/licenses/LICENSE-2.0
  *
  *  Unless required by applicable law or agreed to in writing, software distributed under the
  *  License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
  *  either express or implied. See the License for the specific language governing permissions
  *  and limitations under the License.
  **/

//GMapLib ver 0.1.02
var CATEGORY_MAX=50;	//カテゴリ最大数

//////////////////Map用//////////need prototype.js 1.4/////////////

//namespace
if(window.GPgmapLib == undefined ){
	GPgmapLib = {};
}

//GoogleMap全体クラス
GPgmapLib.GPGmap = Class.create();  
GPgmapLib.GPGmap.prototype = {
	//コンストラクタ
	initialize: function(container,lng,lat,options) {
		document.body.onunload=GUnload;	//API V2Add
//		this.gmap = new GMap($(container));
		this.gmap = new GMap2($(container));
		this.setOptions(options);
//		this.point = new GPoint(lng,lat);
		this.point = new GLatLng(lat,lng);
		this.zoom=this.options.defaultzoomLevel;
		if( this.options.zoomCtrl == 1 ){ this.gmap.addControl( new GLargeMapControl() );  }		//大きいコントローラ（尺度にメモリが付いて）

		if( this.options.zoomCtrl == 2 ){ this.gmap.addControl( new GSmallMapControl() );  }		//小さいコントローラ（移動用矢印と+と-のみ）

		if( this.options.zoomCtrl == 3 ){ this.gmap.addControl( new GSmallZoomControl() ); }		//さらに小さいコントローラ（+と-のみ）

		if( this.options.showViewCtrl  ){ this.gmap.addControl( new GMapTypeControl()  );  }		//マップとサテライトの切り替えのコントローラ
		if( this.options.showScale){ this.gmap.addControl( new GScaleControl() );     }		//尺度の表示
		this.extentions = new Array();
		this.config=new Array();
		this.loadHash();
	},

	setOptions: function(options) {
	this.options = {
			zoomCtrl : 0,				//コントローラの表示: 1=大(デフォルト）、2=小、3=最小、それ以外＝無し
			showViewCtrl : false,		//マップとサテライトの切り替えのコントローラの有無
			showScale : true,			//尺度表示の有無
			defaultzoomLevel : 1,				//拡大レベル
			maxZoomLevel : 9,
			minZoomLevel : 0
		};
		this.options=Object.extend.apply(this.options, [this.options, options || {}]);
		if(this.options.maxZoomLevel==0)this.options.maxZoomLevel=1;
		if(this.options.maxZoomLevel<this.options.minZoomLevel)this.options.maxZoomLevel = this.options.minZoomLevel+1;
		if(this.options.maxZoomLevel<this.options.defaultzoomLevel)this.options.defaultzoomLevel=this.options.maxZoomLevel;
		if(this.options.minZoomLevel>this.options.defaultzoomLevel)this.options.defaultzoomLevel=this.options.minZoomLevel;
	},
	
	loadHash:function(){
		var hash;
		try{
			//if(navigator.userAgent.match( /Firefox/ )) {
			//	hash=this.convertUTF8ToUnicode(decodeURI(window.location.search.substring(1)));
			//}else{
				hash=decodeURI(window.location.search.substring(1));
			//}
		}catch(e){
			hash="";
		}
		
		if(hash!==""){
			var pairs = hash.split("&");
			for (var i=0; i < pairs.length; i++) {
				var apair = pairs[i].split("=");
				if (apair[0]) { this.config[apair[0]] = apair[1];}
			}
		}
		this.update(this.config);
	},
	convertUTF8ToUnicode:function(u)
	{
		var s = "";
		var t = 0;
		var b1, b2, b3;
		while(t < u.length)
			{
			b1 = u.charCodeAt(t++);
			if(b1 < 0x80)
				s += String.fromCharCode(b1);
			else if(b1 < 0xE0)
				{
				b2 = u.charCodeAt(t++);
				s += String.fromCharCode(((b1 & 0x1F) << 6) | (b2 & 0x3F));
				}
			else
				{
				b2 = u.charCodeAt(t++);
				b3 = u.charCodeAt(t++);
				s += String.fromCharCode(((b1 & 0xF) << 12) | ((b2 & 0x3F) << 6) | (b3 & 0x3F));
				}
		}
		return(s);
	},
	
	show:function(){
		//Mapを表示
		this.gmap.setMapType(this.maptype);
	},
	
	addExtention:function(obj){
		this.extentions.push(obj);
	},
	
	getHashString:function(){
//		var curcent = this.gmap.getCenterLatLng();
		var curcent = this.gmap.getCenter();
		var mtype=this.gmap.getCurrentMapType();
//		if(mtype==G_MAP_TYPE){
		if(mtype==G_NORMAL_MAP){
			mtype='m';
//		}else if(mtype==G_SATELLITE_TYPE){
		}else if(mtype==G_SATELLITE_MAP){
			mtype='s';
		}else{
			mtype='h';
		}
//		var retstr="lat="+curcent.y+"&lng="+curcent.x+"&zoom="+this.gmap.getZoomLevel();
		var retstr="lat="+curcent.y+"&lng="+curcent.x+"&zoom="+(17-this.gmap.getZoom());
		if(mtype != 'm'){
			retstr+='&maptype='+mtype;
		}
		return retstr;
	},
	
	update:function(hash){
		if(hash.lng && hash.lat){
			if((isNaN(parseFloat(hash.lng)) ==false) && (isNaN(parseFloat(hash.lat))==false)){
//				this.point=new GPoint(parseFloat(hash.lng), parseFloat(hash.lat));
				this.point=new GLatLng(parseFloat(hash.lat),parseFloat(hash.lng));
			}
		}
//		this.gmap.centerAtLatLng(this.point);
		if(hash.zoom){
			if(isNaN(parseInt(hash.zoom))==false){
				this.zoom=parseInt(hash.zoom);
				if(hash.zoom>this.options.maxZoomLevel)this.zoom=parseInt(this.options.maxZoomLevel);
				if(hash.zoom<this.options.minZoomLevel)this.zoom=parseInt(this.options.minZoomLevel);
			}
		}
//		this.gmap.zoomTo(this.zoom);
		this.gmap.setCenter(this.point,this.zoom);
		if(hash.maptype){
			if(hash.maptype=='h'){
				//this.gmap.setMapType(G_HYBRID_TYPE);
				this.gmap.setMapType(G_HYBRID_MAP);
			}else if(hash.maptype=='s'){
//				this.gmap.setMapType(G_SATELLITE_TYPE);
				this.gmap.setMapType(G_SATELLITE_MAP);
			}else{
//				this.gmap.setMapType(G_MAP_TYPE);
				this.gmap.setMapType(G_NORMAL_MAP);
			}
		}
	}
};

//GoogleMap操作クラス
GPgmapLib.mapCtrlObj= Class.create();  
GPgmapLib.mapCtrlObj.prototype={
	//コンストラクタ
	initialize: function(mapobj){
		mapobj.ctrl = this;
		this.gpmap = mapobj;
		this.isFollowHash =false; 
	},
	//上に移動
	panNorth:function(){
//		this.gpmap.gmap.pan(0,Math.floor(this.gpmap.gmap.viewSize.height*0.5));
		this.gpmap.gmap.panDirection(0,1);
	},
	//右に移動
	panEast:function(){
//		this.gpmap.gmap.pan(-Math.floor(this.gpmap.gmap.viewSize.width*0.5),0);
		this.gpmap.gmap.panDirection(-1,0);
	},
	//下に移動
	panSouth:function(){
//		this.gpmap.gmap.pan(0,-Math.floor(this.gpmap.gmap.viewSize.height*0.5));
		this.gpmap.gmap.panDirection(0,-1);
	},
	//左に移動
	panWest:function(){
//		this.gpmap.gmap.pan(Math.floor(this.gpmap.gmap.viewSize.width*0.5),0);
		this.gpmap.gmap.panDirection(1,0);
	},	
	//左上に移動
	panNorthWest:function(){
//		this.gpmap.gmap.pan(Math.floor(this.gpmap.gmap.viewSize.width*0.5),Math.floor(this.gpmap.gmap.viewSize.height*0.5));
		this.gpmap.gmap.panDirection(1,1);
	},
	//右上に移動
	panNorthEast:function(){
//		this.gpmap.gmap.pan(-Math.floor(this.gpmap.gmap.viewSize.width*0.5),Math.floor(this.gpmap.gmap.viewSize.height*0.5));
		this.gpmap.gmap.panDirection(-1,1);
	},
	//左下に移動
	panSouthWest:function(){
//		this.gpmap.gmap.pan(Math.floor(this.gpmap.gmap.viewSize.width*0.5),-Math.floor(this.gpmap.gmap.viewSize.height*0.5));
		this.gpmap.gmap.panDirection(1,-1);
	},
	//右下に移動
	panSouthEast:function(){
//		this.gpmap.gmap.pan(-Math.floor(this.gpmap.gmap.viewSize.width*0.5),-Math.floor(this.gpmap.gmap.viewSize.height*0.5));
		this.gpmap.gmap.panDirection(-1,-1);
	},
	
	//元に戻る
	panLastResult:function(){
		this.gpmap.gmap.closeInfoWindow();
		if(this.gpmap.gmap.lastPageCenter){
			if(this.gpmap.gmap.lastPageZoom!=this.gpmap.gmap.zoomLevel){
//				this.gpmap.gmap.centerAndZoom(this.gpmap.gmap.lastPageCenter,this.gpmap.gmap.lastPageZoom);
				this.gpmap.gmap.setCcenter(this.gpmap.gmap.lastPageCenter,this.gpmap.gmap.lastPageZoom);
			}
			else{
//				this.gpmap.gmap.recenterOrPanToLatLng(this.gpmap.gmap.lastPageCenter);
				this.gpmap.gmap.panTo(this.gpmap.gmap.lastPageCenter);
			}
		}
		else if(this.gpmap.gmap.lastLatLng){
//			this.gpmap.gmap.recenterOrPanToLatLng(this.gpmap.gmap.lastLatLng);
			this.gpmap.gmap.panTo(this.gpmap.gmap.lastLatLng);
		}
	},
	
	//初期位置に戻る
	panReset:function(){
		this.gpmap.gmap.closeInfoWindow();
//		this.gpmap.gmap.centerAtLatLng(this.gpmap.point);
		this.gpmap.gmap.setCenter(this.gpmap.point);
	},
	
	//表示切替（地図）
	setViewToMap:function(){
//		this.gpmap.gmap.setMapType(G_MAP_TYPE);
		this.gpmap.gmap.setMapType(G_NORMAL_MAP);
	},
	
	//表示切替（サテライト）
	setViewToSatellite:function(){
//		this.gpmap.gmap.setMapType(G_SATELLITE_TYPE);
		this.gpmap.gmap.setMapType(G_SATELLITE_MAP);
	},
	
	//表示切替（デュアル）-日本では利用不可：指定してもサテライト表示になる-
	setViewToHybrid:function(){
		//this.gpmap.gmap.setMapType(G_HYBRID_TYPE);
		this.gpmap.gmap.setMapType(G_HYBRID_MAP);
	},
	
	//サイズ変更
	setZoom:function(zoomLevel){//alert(this.gpmap.options.minZoomLevel+","+zoomLevel+","+(17-zoomLevel))
		//ToDo:設定ファイルから上下限をチェック
		if(this.gpmap.options.maxZoomLevel<zoomLevel){zoomLevel=this.gpmap.options.maxZoomLevel;}
		if(this.gpmap.options.minZoomLevel>zoomLevel){zoomLevel=this.gpmap.options.minZoomLevel;}
//		this.gpmap.gmap.zoomTo(zoomLevel);
		this.gpmap.gmap.setZoom(17-zoomLevel);
	},

	//サイズ取得
	getZoom:function(){
//		return this.gpmap.gmap.getZoomLevel();
		return this.gpmap.gmap.getZoom();
	},
	getMapTyle:function(){
		return this.gpmap.gmap.getCurrentMapType();
	}
};

//MiniMapクラス
GPgmapLib.MiniMap= Class.create();  
GPgmapLib.MiniMap.prototype={
	//コンストラクタ
	initialize: function(mapobj,container,options){
		mapobj.minimap=this;
		this.gpmap = mapobj;
//		this.map = new  GMap($(container));
		this.map = new  GMap2($(container));
		this.isFollowHash =false; 
		this.setOptions(options);
//		this.map.centerAndZoom(mapobj.gmap.getCenterLatLng(),this.options.zoomlevel);
		this.map.setCenter(mapobj.gmap.getCenter(),17-this.options.zoomlevel);
//		bounds = mapobj.gmap.getBoundsLatLng();
		bounds = mapobj.gmap.getBounds();
		var points = [];
//		points.push(new GPoint(bounds.minX,bounds.maxY));
//		points.push(new GPoint(bounds.maxX,bounds.maxY));
//		points.push(new GPoint(bounds.maxX,bounds.minY));
//		points.push(new GPoint(bounds.minX,bounds.minY));
//		points.push(new GPoint(bounds.minX,bounds.maxY));
		points.push(bounds.getSouthWest());
		points.push(new GLatLng(bounds.getNorthEast().lat(),bounds.getSouthWest().lng()));
		points.push(bounds.getNorthEast());
		points.push(new GLatLng(bounds.getSouthWest().lat(),bounds.getNorthEast().lng()));
		points.push(bounds.getSouthWest());
		pln = new GPolyline(points,'#ff0000',3,1);
		this.map.addOverlay(pln);
		GEvent.addListener(mapobj.gmap,"zoom",this.onGmapZoom.bindAsEventListener(this));
		GEvent.addListener(mapobj.gmap,"move",this.onGmapMove.bindAsEventListener(this));
		GEvent.addListener(this.map,"move",this.onMinimapMove.bindAsEventListener(this));
		GEvent.addListener(this.map,"movestart",this.onMinimapMoveStart.bindAsEventListener(this));

	},
	setOptions: function(options) {
		this.options = {
			zoomlevel:3,
			maxlevel:11
		};
		this.options=Object.extend.apply(this.options, [this.options, options || {}]);
		if(this.options.maxlevel < this.gpmap.options.maxZoomLevel)this.options.maxlevel = this.gpmap.options.maxZoomLevel;
		if(this.options.zoomlevel <this.gpmap.options.defaultzoomLevel)this.options.zoomlevel =this.gpmap.options.defaultzoomLevel;
	},
	
	onGmapZoom:function(){
//		if(this.gpmap.gmap.getZoomLevel()>this.map.getZoomLevel()){
		if(this.gpmap.gmap.getZoom()>this.map.getZoom()){
//			this.map.zoomTo(this.gpmap.gmap.getZoomLevel());
			this.map.setZoom(this.gpmap.gmap.getZoom());
		}
	},

	onGmapMove:function(){
		if(this.map.movedByOther===true){return;}
		if(this.gpmap.gmap.movedByOther===true){return;}

		this.map.movedByOther=true;
//		this.map.centerAndZoom(this.gpmap.gmap.getCenterLatLng(),this.map.getZoomLevel());
		this.map.setCenter(this.gpmap.gmap.getCenter(),this.map.getZoom());
		this.redrawMapRect();
		this.map.movedByOther=false;
	},

	onMinimapMove:function(){
		if(this.map.movedByOther===true){return;}
		if(this.gpmap.gmap.movedByOther===true){return;}
		this.gpmap.gmap.movedByOther=true;
	
		var i=this.gpmap.categoryManager.itemlist.activeMarkerIndex;
		if(i>=0){
			this.gpmap.gmap.closeInfoWindow();
//			this.gpmap.gmap.centerAtLatLng(this.map.getCenterLatLng(),this.gpmap.gmap.getZoomLevel());
			this.gpmap.gmap.setCenter(this.map.getCenter(),this.gpmap.gmap.getZoom());
//			this.gpmap.categoryManager.itemlist.showInfo(this.gpmap.categoryManager.itemlist.markers[i]);   
		}else{
//			this.gpmap.gmap.centerAtLatLng(this.map.getCenterLatLng(),this.gpmap.gmap.getZoomLevel());
			this.gpmap.gmap.setCenter(this.map.getCenter(),this.gpmap.gmap.getZoom());
		}

//		this.gpmap.gmap.centerAtLatLng(this.map.getCenterLatLng(),this.gpmap.gmap.getZoomLevel());
		this.gpmap.gmap.setCenter(this.map.getCenter(),this.gpmap.gmap.getZoom());
		this.redrawMapRect();
		this.gpmap.gmap.movedByOther=false;
	},

	onMinimapMoveStart:function(){
		var i=this.gpmap.categoryManager.itemlist.activeMarkerIndex;
		if(i>=0){
			this.gpmap.gmap.closeInfoWindow();
		}
	},

	redrawMapRect:function(){
		this.map.clearOverlays();
//		bounds = this.gpmap.gmap.getBoundsLatLng();
		bounds = this.gpmap.gmap.getBounds();
		var points = [];
/*		points.push(new GPoint(bounds.minX,bounds.maxY));
		points.push(new GPoint(bounds.maxX,bounds.maxY));
		points.push(new GPoint(bounds.maxX,bounds.minY));
		points.push(new GPoint(bounds.minX,bounds.minY));
		points.push(new GPoint(bounds.minX,bounds.maxY));
*/
		points.push(bounds.getSouthWest());
		points.push(new GLatLng(bounds.getNorthEast().lat(),bounds.getSouthWest().lng()));
		points.push(bounds.getNorthEast());
		points.push(new GLatLng(bounds.getSouthWest().lat(),bounds.getNorthEast().lng()));
		points.push(bounds.getSouthWest());

		pln = new GPolyline(points,'#ff0000',3,1);
		this.map.addOverlay(pln);
	},

	zoomUp:function(){
//		if(this.map.getZoomLevel() > this.gpmap.gmap.getZoomLevel()){
		if(this.map.getZoom() < this.gpmap.gmap.getZoom()){
//			this.map.zoomTo(this.map.getZoomLevel()-1);
			this.map.setZoom(this.map.getZoom()+1);
		}
		this.redrawMapRect();
	},

	zoomDown:function(){
//		if(this.map.getZoomLevel() >= this.options.maxlevel)return;
		if(this.map.getZoom() <= 17-this.options.maxlevel)return;
//		this.map.zoomTo(this.map.getZoomLevel()+1);
		this.map.setZoom(this.map.getZoom()-1);
		this.redrawMapRect();
	}
};

////アイテムカテゴリ管理クラス
CATEGORYMANAGER_FILEBROKEN="選択できるカテゴリが登録されていません。";
GPgmapLib.categoryManager = Class.create();
GPgmapLib.categoryManager.prototype={
	//コンストラクタ
	initialize: function(mapobj,xmldir,xmlfilename,changedcallback,options){			//options...    OnInited,  onError
		mapobj.categoryManager = this;
		this.gpmap = mapobj;
		//マーカーリストオブジェクト作成
		this.categoryList = new Array();
		this.isFollowHash =true;
		this.itemlist = new GPgmapLib.marksList(mapobj);
		mapobj.addExtention(this.itemlist);
		this.setOptions(options);
		this.xmldir = xmldir;
		this.activeIndex=-1;	
		this.changedcallback=changedcallback;
		this.Datetime = new Date().getDate();

		//カテゴリリスト取得
		new Ajax.Request( xmldir+xmlfilename+'?time='+Datetime, {method: 'get', onComplete: this.setCategory.bindAsEventListener(this)} ); 
	},
	setOptions: function(options) {
		this.options = {
			itemnodesName:'Sisetu',
			maxCategoryNum:30
		};
		this.options=Object.extend.apply(this.options, [this.options, options || {}]);
	},
	setCategory:function(originalRequest){
		var ctgryxml=originalRequest.responseXML;
		if(ctgryxml!=null){
			Categorys=ctgryxml.getElementsByTagName("Category");
			var roopCount=Categorys.length;
			if(roopCount > 0){
				if(roopCount>this.options.maxCategoryNum){roopCount=this.options.maxCategoryNum;}
				for(var i=0;i<roopCount;i++){
					try{
						var n = Categorys[i].getElementsByTagName("Name")[0].firstChild.nodeValue;
						var f = Categorys[i].getElementsByTagName("FileName")[0].firstChild.nodeValue;
						this.categoryList.push({name:n,file:f});
					}catch(e){}
				}
				this.update(this.gpmap.config);
				
			}else{
				(this.options['onError' ]|| Prototype.emptyFunction)(CATEGORYMANAGER_FILEBROKEN);
			}
				
		}else{
			if(this.categoryList.length==0){
				(this.options['onError' ]|| Prototype.emptyFunction)(CATEGORYMANAGER_FILEBROKEN);
			}
		}
		 (this.options['OnInited' ]|| Prototype.emptyFunction)(this.categoryList);
	},

	change:function(index,ischeckHash){
		var xmlurl="";
		this.activeIndex=index;
		if(index>-1){
			xmlurl=this.xmldir+this.categoryList[index].file+'?time='+this.Datetime;
			if(this.gpmap.urlReadWriter){
				this.gpmap.urlReadWriter.updateHash();
			}
		}
		this.itemlist.load(xmlurl,this.options.itemnodesName,this.changedcallback,ischeckHash);
	},
	
	getHashString:function(){
		if(this.activeIndex>-1){
			return "ctgr="+this.categoryList[this.activeIndex].name;
		}else{
			return "";
		}
	},
	update:function(hash){
		if(hash.ctgr){
			for(var i=0;i<this.categoryList.length;i++){
				if(this.categoryList[i].name==hash.ctgr){
					this.activeIndex=i;
					break;
				}
			}
		}
	}
};

MARKSLIST_FILEBROKEN="選択できる施設が登録されていません。";
GPgmapLib.marksList= Class.create();  
GPgmapLib.marksList.prototype={
	//コンストラクタ
	initialize: function(mapobj,options){			//options...    OnInited,  onError
		this.gpmap = mapobj;
		this.isFollowHash =true;
		this.markers=new Array();
		this.setOptions(options);
		this.baseicon = new GIcon();
		this.baseicon.shadow = this.options.iconFloder+this.options.iconShadowFile;
		this.baseicon.iconSize = this.options.iconSize;
		this.baseicon.shadowSize = this.options.iconShadowSize;
		this.baseicon.iconAnchor = this.options.iconAnchor;
		this.baseicon.infoWindowAnchor = this.options.infoWindowAnchor;
		this.activeMarkerIndex=-1;
		this.isShowAllMarker=false;
		this.clearEvent = null;	
		GEvent.addListener(mapobj.gmap,'infowindowclose',this.oncloseInfo.bindAsEventListener(this));
		GEvent.addListener(mapobj.gmap, 'click', this.showInfo.bindAsEventListener(this));
	},
	
	setOptions: function(options) {
		this.options = 
		{
			iconFloder:'./Gmaps/images/map_icon/',
			iconSize:new GSize(32,24),
			iconFilePrefix:'map_icon_',
			iconFilelastfix:'.gif',
			iconDefaultFile:'map_icon.png',
			iconShadowFile:'map_icon_shadow.png',
			iconShadowSize:new GSize(56,24),
			iconAnchor:new GPoint(5, 23) ,
			infoWindowAnchor:new GPoint(10, 3),
			numberdIconMax:99,
			xslFolder:'./Gmaps/',
			maxitemsnum:50
		};
		this.options=Object.extend.apply(this.options, [this.options, options || {}]);
	},

	load:function(xmlurl,itemnodesName,callback,ischeckhash){
		this.callback=callback;
		this.nodesName=itemnodesName;
		if(!ischeckhash)this.clearAllMarker();
		this.items=null;
		for(var i=0;i<this.markers.length;i++){
			if(this.markers[i].eventId)GEvent.removeListener(this.markers[i].eventId); 
		}
		this.markers.clear();
		this.markers.length=0;
		this.ischeckhash=ischeckhash;
		if(xmlurl!==""){
			new Ajax.Request(xmlurl,{method:'get',onComplete:this.onloadResponse.bind(this)});
		}
	},
	onloadResponse:function(req){
		if(req.responseXML==null){
			this.markers.clear();
			this.markers.length=0;
		}else{
			this.items=req.responseXML.getElementsByTagName(this.nodesName);
			var roopcount=this.items.length;
			if(roopcount >this.options.maxitemsnum) roopcount=this.options.maxitemsnum;
			var errorCount=0;
			for(var i=0;i<roopcount;i++){
				if(!(this.setIcon(i,i-errorCount))){
					errorCount++;
				}
			}
			if(this.ischeckhash)this.update(this.gpmap.config);
		}
		(this.callback|| Prototype.emptyFunction)(this.markers);
	},
	setIcon:function(index,Id){
		try{
			if((isNaN(parseFloat(this.items[index].getElementsByTagName("Longitude")[0].firstChild.nodeValue)))){
				return;
			}
			if((isNaN(parseFloat(this.items[index].getElementsByTagName("Latitude")[0].firstChild.nodeValue)))){
				return;
			}
			var icon = new GIcon(this.baseicon);
			if(index<this.options.numberdIconMax){
				icon.image = this.options.iconFloder+this.options.iconFilePrefix+(Id+1)+this.options.iconFilelastfix;
			}else{
				icon.image = this.options.iconFloder+this.options.iconDefaultFile;
			}
			var x=this.items[index].getElementsByTagName("Longitude")[0].firstChild.nodeValue;
			var y=this.items[index].getElementsByTagName("Latitude")[0].firstChild.nodeValue;
//			var marker = new GxMarker(new GPoint(x,y),icon);
			var marker = new GxMarker(new GLatLng(y,x),icon);
			marker.Id=Id;		
			marker.setTooltip(this.items[index].getElementsByTagName("Name")[0].firstChild.nodeValue);
			marker.Name=this.items[index].getElementsByTagName("Name")[0].firstChild.nodeValue;
			marker.UserData=this.items[index];
			if(this.items[index].getAttributeNode('xslfile').nodeValue =="") return;
			marker.UserData2=this.options.xslFolder+this.items[index].getAttributeNode('xslfile').nodeValue;
			marker.parent=this;
			marker.eventId = GEvent.addListener(marker,'infowindowopen',this.onopenInfo);
			this.markers.push(marker);
			return true;
		}catch(e){return false;}		
	},
	clearAllMarker:function(){
		if(this.activeMarkerIndex > -1){
//			this.clearEvent = GEvent.addListener(this.markers[this.activeMarkerIndex],'infowindowclose',this.clearAllMarker.bindAsEventListener(this));
			this.gpmap.gmap.closeInfoWindow();

//			return;
		}
		if(this.clearEvent!= null){
			GEvent.removeListener(this.clearEvent); 
			this.clearEvent = null;
		}

		//全てのアイコンを消す
		for(var i=0;i<this.markers.length;i++){
			this.gpmap.gmap.removeOverlay(this.markers[i]);
		}	
		this.isShowAllMarker=false;
		if(this.gpmap.urlReadWriter){
			this.gpmap.urlReadWriter.updateHash();
		}
	},
	onopenInfo:function(){
		this.parent.activeMarkerIndex = this.Id;
		if(this.parent.gpmap.urlReadWriter){
				this.parent.gpmap.urlReadWriter.updateHash();
		}
	},
	oncloseInfo:function(){
		this.activeMarkerIndex =-1;
		if(this.gpmap.urlReadWriter){
			this.gpmap.urlReadWriter.updateHash();
		}
	},
	showInfo:function(marker,isForce){
		if(marker){
			var index = marker.Id;
			if(index == undefined || index == null)return;
			if(!isForce){
				if(index == this.activeMarkerIndex)return;
			}
//			marker.openInfoWindowXslt(marker.UserData,marker.UserData2);
			if(marker.UserData2=='')return;

//			if(navigator.userAgent.indexOf("KHTML" , 0) > -1){
				//KHTMLエンジンの場合
				marker.openInfoWindowHtml(GPgmapLibCreateInfowindowHTML(marker.UserData))
/*			}else{
			//KHTMLエンジン
				//XSLT変換 
				//XSLファイル取得
				var xslDoc = Sarissa.getDomDocument();
				xslDoc.async = false;
				xslDoc.load(marker.UserData2);
				//XSL変換
				var processor = new XSLTProcessor();
				processor.importStylesheet(xslDoc);
				var xmlDoc = Sarissa.getDomDocument();
				xmlDoc = (new DOMParser()).parseFromString(Sarissa.serialize(marker.UserData), "text/xml");
				var htmldoc = processor.transformToDocument(xmlDoc);

				//変換したHTMLを表示
				marker.openInfoWindowHtml(Sarissa.serialize(htmldoc));
			}
*/		}
	},
	setIconAndShowInfo:function(index){
		this.gpmap.gmap.addOverlay(this.markers[index]);
		this.showInfo(this.markers[index],true);
	},
	setAllMarker:function(){
		this.clearAllMarker();
		for(var i=0;i<this.markers.length;i++){
			this.gpmap.gmap.addOverlay(this.markers[i]);
		}
		this.isShowAllMarker=true;
		if(this.gpmap.urlReadWriter){
			this.gpmap.urlReadWriter.updateHash();
		}
	},
	getHashString:function(){
		var retstr ="";
		if(this.activeMarkerIndex>-1){
			retstr = 'item='+this.markers[this.activeMarkerIndex].Name;
		}
		if(this.isShowAllMarker){
			if(retstr!="")retstr+="&";
			retstr += "showall=1";
		}
		return retstr;
	},
	update:function(hash){
		if(hash.item){
			for(var i=0;i<this.markers.length;i++){
				if(this.markers[i].Name==hash.item){
					this.activeMarkerIndex=i;
					break;
				}
			}				
		}else{
			if(hash.showall){
				if(hash.showall =='1') this.isShowAllMarker=true;
			}
		}
	}
};

////URL管理クラス
GPgmapLib.urlReadWriter = Class.create();
GPgmapLib.urlReadWriter.prototype={
	initialize: function(mapobj,options){			//options  is {OnUrlChange: anyfunc} 
		mapobj.urlReadWriter= this;
		this.gpmap = mapobj;
		this.isFollowHash=false;
		this.config=new Array();
		this.hash='';
		if(options){this.setOptions(options);}
		GEvent.addListener(mapobj.gmap,"moveend",this.updateHash.bindAsEventListener(this));
		GEvent.addListener(mapobj.gmap, 'maptypechanged',this.updateHash.bindAsEventListener(this));
		this.updateHash();
	},
	
	setOptions: function(options) {
		this.options = {
			dummy:null
		};
		this.options=Object.extend.apply(this.options, [this.options, options || {}]);
	},
	
	setStatus: function(status) {
		this.config = {
		};
		this.config=Object.extend.apply(this.config, [this.config, status || {}]);
	},
	
	updateHash:function(){
		var hashstr=this.gpmap.getHashString();
		var str="";
		for(var i=0;i<this.gpmap.extentions.length;i++){
			if(	this.gpmap.extentions[i].isFollowHash ==true){
				str=this.gpmap.extentions[i].getHashString();
				if(str!=''){
					hashstr += "&"+str;
				}
			}
		}	
		this.hash=encodeURI(hashstr);
		var strURL = window.location.protocol+"//"+window.location.hostname+window.location.pathname;
		(this.options['OnUrlChange' ]|| Prototype.emptyFunction)(strURL+"?"+this.hash);
    } 
};
