#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "gmet/gmet_vector.h"
#include "gmet/gmet_common.h"

GmetVector *
gmetNewVector( int size )
{
  GmetVector *ret = ( GmetVector * ) malloc( sizeof( GmetVector ) );

  if ( ret )
  {
    ret->size = size;
    ret->sp = 0;
    ret->stack = NULL;
    if ( size )
    {
      ret->stack = ( void ** ) malloc( size * sizeof( void * ) );
      if ( ret->stack )
        memset( ret->stack, 0, size * sizeof( void * ) );
    }
  }

  GMET_CHKPTR( ret );
  return ret;
}

void
gmetDeleteVector( GmetVector * v )
{
  if ( !v )
    return;
  if ( v->stack )
    free( v->stack );
  free( v );
}

int
gmetVectorPush( GmetVector * v, void *item )
{
  GMET_CHKPTR( v );

  if ( v->stack == NULL )
  {
    v->stack = ( void ** ) malloc( 2 * sizeof( void * ) );
    if ( !v->stack )
      return 1;
    v->size = 2;
  }
  if ( v->sp == v->size )
  {
    void **tmp = ( void ** ) malloc( 2 * ( v->size ) * sizeof( void * ) );
    if ( !tmp )
      return 1;
    memcpy( tmp, v->stack, v->size * sizeof( void * ) );
    free( v->stack );
    v->stack = tmp;
    v->size *= 2;
  }
  v->stack[v->sp++] = item;
  return 0;
}

void *
gmetVectorPop( GmetVector * v )
{
  if ( v->sp > 0 )
  {
    return v->stack[--( v->sp )];
  }
  return NULL;
}

void *
gmetVectorGet( GmetVector * v, int i )
{
  if ( !v )
  {
    fprintf( stderr, "gmetVectorGet: vector unspecified\n" );
    return NULL;
  }

  if ( i < 0 )
    i = v->sp + i;

  if ( i >= 0 && v->sp > i )
    return v->stack[i];

  return NULL;
}
