#ifndef __GMET_GMET_H__
#define __GMET_GMET_H__

#include "gmet/gmet_common.h"
#include "gmet/gmet_vector.h"
#include "gmet/gmet_stream.h"

#ifndef NULL
#  define NULL ((void*) 0)
#endif

enum
{
  gmetTypeBlock,
  gmetTypeInt,
  gmetTypeStr,
  gmetTypeFunc,
  gmetTypeIfElse
};

#define gmetDataType(x) ((x)->org->type)
#define gmetDataGetInt(x) ((x)->data.num)
#define gmetDataGetStr(x) ((x)->data.str)

typedef struct GmetData
{
  struct GmetData *parent;
  struct GmetStatement *org;
  union
  {
    int num;
    char *str;
    struct GmetVector *list;
  } data;
} GmetData;

typedef GmetData *( *GmetCBReadData ) ( struct GmetStatement * this,
                                        struct GmetData * parent,
                                        struct GmetStream * stream,
                                        int *ret );

typedef struct GmetStatement
{
  struct GmetBlock *parent;
  int type;
  char *loop;
  char *size;
  char *name;
  GmetCBReadData readData;
} GmetStatement;

typedef struct GmetBlock
{
  struct GmetStatement st;
  struct GmetVector *list;
} GmetBlock, GmetRoot;

typedef struct GmetIfElse
{
  struct GmetBlock blk;
  int sizeElse;
  char *condition;
  struct GmetVector *listElse;
} GmetIfElse;

extern GmetStatement *gmetNewStatement( char *name, struct GmetBlock *parent,
                                        int type, char *loop, char *size );

extern void gmetDeleteStatement( struct GmetStatement *st );

extern GmetBlock *gmetNewBlock( char *name, struct GmetBlock *parent,
                                char *loop, int size );

extern void gmetDeleteBlock( struct GmetBlock *blk );

extern int gmetBlockAdd( struct GmetBlock *blk, struct GmetStatement *st );

extern GmetRoot *gmetNewRoot( void );

#define gmetDeleteRoot(x) gmetDeleteBlock((GmetBlock*) (x))

extern GmetIfElse *gmetNewIfElse( struct GmetBlock *parent, int sizeIf,
                                  int sizeElse, char *condition );

extern void gmetDeleteIfElse( struct GmetIfElse *ie );

extern int gmetIfElseAddIf( struct GmetIfElse *ie, struct GmetStatement *st );

extern int
gmetIfElseAddElse( struct GmetIfElse *ie, struct GmetStatement *st );

extern GmetStatement *gmetNewFunc_reserve( struct GmetBlock *parent,
                                           char *arg );

extern GmetStatement *gmetNewFunc_align( struct GmetBlock *parent,
                                         char *arg );

extern GmetData *gmetNewData( struct GmetData *parent,
                              struct GmetStatement *org,
                              struct GmetStream *stream );

extern void gmetDeleteData( struct GmetData *data );

typedef struct GmetArray
{
  char *name;
  int size;
  int idx;
} GmetArray;

extern GmetData *gmetArrayGet( struct GmetData *parent, GmetArray * ar );

/*
  ref [in]: vector of GmetArray
  return -1 Error
         >0 represent ref data
*/
extern int gmetRefGet( struct GmetData *parent, GmetVector * ref );

extern int gmetExpGet( struct GmetData *parent, char *exp );

#endif
