#ifndef __GMET_STREAM_H__
#define __GMET_STREAM_H__

#include <stdio.h>
#include "gmet/gmet_common.h"

#define GmetStreamBuffSize 128

typedef struct GmetStream
{
  FILE *file;
  size_t wp;
  int rp;
  int count;
  char buff[GmetStreamBuffSize];
} GmetStream;

extern GmetStream *gmetNewStream( FILE * fp );

extern void gmetDeleteStream( struct GmetStream *stream );

extern int gmetStreamBit( struct GmetStream *stream, char *ret );

extern int gmetStreamByte( struct GmetStream *stream, char *ret );

extern int gmetStreamBytes( struct GmetStream *stream, char *ret, int size );

extern int gmetStreamIntN( struct GmetStream *stream, int *ret, int size );

extern int gmetStreamInt32( struct GmetStream *stream, int *ret );

extern unsigned int
gmetStreamUInt( struct GmetStream *stream, unsigned int *ret );

extern int
gmetStreamBitCopy( struct GmetStream *stream, char *ret, int size );

extern int gmetStreamAlign( struct GmetStream *stream, int align );

extern int gmetStreamReserve( struct GmetStream *stream, int size );

#endif
