/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ds.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PooledConnectionImpl
implements PooledConnection {
    private List listeners = new LinkedList();
    private Connection con;
    private ConnectionHandler last;
    private final boolean autoCommit;
    private final boolean isXA;
    private static String[] fatalClasses = new String[]{"08", "53", "57P01", "57P02", "57P03", "58", "60", "99", "F0", "XX"};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public PooledConnectionImpl(Connection con, boolean autoCommit, boolean isXA) {
        this.con = con;
        this.autoCommit = autoCommit;
        this.isXA = isXA;
    }

    public PooledConnectionImpl(Connection con, boolean autoCommit) {
        this(con, autoCommit, false);
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.add(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.remove(connectionEventListener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SQLException {
        if (this.last != null) {
            this.last.close();
            if (!this.con.getAutoCommit()) {
                try {
                    this.con.rollback();
                }
                catch (SQLException sQLException) {}
            }
        }
        try {
            this.con.close();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.con = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.con = null;
            return;
        }
    }

    public Connection getConnection() throws SQLException {
        ConnectionHandler handler;
        if (this.con == null) {
            PSQLException sqlException = new PSQLException(GT.tr("This PooledConnection has already been closed."), PSQLState.CONNECTION_DOES_NOT_EXIST);
            this.fireConnectionFatalError(sqlException);
            throw sqlException;
        }
        try {
            if (this.last != null) {
                this.last.close();
                if (!this.con.getAutoCommit()) {
                    try {
                        this.con.rollback();
                    }
                    catch (SQLException sQLException) {}
                }
                this.con.clearWarnings();
            }
            this.con.setAutoCommit(this.autoCommit);
        }
        catch (SQLException sqlException) {
            this.fireConnectionFatalError(sqlException);
            throw (SQLException)sqlException.fillInStackTrace();
        }
        this.last = handler = new ConnectionHandler(this.con);
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.sql.Connection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.postgresql.PGConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Connection proxyCon = (Connection)Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)handler);
        this.last.setProxy(proxyCon);
        return proxyCon;
    }

    void fireConnectionClosed() {
        ConnectionEvent evt = null;
        ConnectionEventListener[] local = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        int i = 0;
        while (i < local.length) {
            ConnectionEventListener listener = local[i];
            if (evt == null) {
                evt = new ConnectionEvent(this);
            }
            listener.connectionClosed(evt);
            ++i;
        }
    }

    void fireConnectionFatalError(SQLException e) {
        ConnectionEvent evt = null;
        ConnectionEventListener[] local = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        int i = 0;
        while (i < local.length) {
            ConnectionEventListener listener = local[i];
            if (evt == null) {
                evt = new ConnectionEvent(this, e);
            }
            listener.connectionErrorOccurred(evt);
            ++i;
        }
    }

    private static boolean isFatalState(String state) {
        if (state == null) {
            return true;
        }
        if (state.length() < 2) {
            return true;
        }
        int i = 0;
        while (i < fatalClasses.length) {
            if (state.startsWith(fatalClasses[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void fireConnectionError(SQLException e) {
        if (!PooledConnectionImpl.isFatalState(e.getSQLState())) {
            return;
        }
        this.fireConnectionFatalError(e);
    }

    private class ConnectionHandler
    implements InvocationHandler {
        private Connection con;
        private Connection proxy;
        private boolean automatic = false;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;

        public ConnectionHandler(Connection con) {
            this.con = con;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                if (method.getName().equals("toString")) {
                    return "Pooled connection wrapping physical connection " + this.con;
                }
                if (method.getName().equals("hashCode")) {
                    return new Integer(this.con.hashCode());
                }
                if (method.getName().equals("equals")) {
                    if (args[0] == null) {
                        return Boolean.FALSE;
                    }
                    try {
                        return Proxy.isProxyClass(args[0].getClass()) && ((ConnectionHandler)Proxy.getInvocationHandler((Object)args[0])).con == this.con ? Boolean.TRUE : Boolean.FALSE;
                    }
                    catch (ClassCastException classCastException) {
                        return Boolean.FALSE;
                    }
                }
                try {
                    return method.invoke((Object)this.con, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            if (method.getName().equals("isClosed")) {
                return this.con == null ? Boolean.TRUE : Boolean.FALSE;
            }
            if (this.con == null && !method.getName().equals("close")) {
                throw new PSQLException(this.automatic ? GT.tr("Connection has been closed automatically because a new connection was opened for the same PooledConnection or the PooledConnection has been closed.") : GT.tr("Connection has been closed."), PSQLState.CONNECTION_DOES_NOT_EXIST);
            }
            if (method.getName().equals("close")) {
                if (this.con == null) {
                    return null;
                }
                SQLException ex = null;
                if (!PooledConnectionImpl.this.isXA && !this.con.getAutoCommit()) {
                    try {
                        this.con.rollback();
                    }
                    catch (SQLException e) {
                        ex = e;
                    }
                }
                this.con.clearWarnings();
                this.con = null;
                proxy = null;
                PooledConnectionImpl.this.last = null;
                PooledConnectionImpl.this.fireConnectionClosed();
                if (ex != null) {
                    throw ex;
                }
                return null;
            }
            try {
                if (method.getName().equals("createStatement")) {
                    Statement st = (Statement)method.invoke((Object)this.con, args);
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    Class[] classArray = new Class[2];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.sql.Statement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("org.postgresql.PGStatement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[1] = clazz2;
                    return Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)new StatementHandler(this, st));
                }
                if (method.getName().equals("prepareCall")) {
                    Statement st = (Statement)method.invoke((Object)this.con, args);
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    Class[] classArray = new Class[2];
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("java.sql.CallableStatement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    Class<?> clazz3 = class$1;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$1 = Class.forName("org.postgresql.PGStatement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[1] = clazz3;
                    return Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)new StatementHandler(this, st));
                }
                if (method.getName().equals("prepareStatement")) {
                    Statement st = (Statement)method.invoke((Object)this.con, args);
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    Class[] classArray = new Class[2];
                    Class<?> clazz = class$3;
                    if (clazz == null) {
                        try {
                            clazz = class$3 = Class.forName("java.sql.PreparedStatement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    Class<?> clazz4 = class$1;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$1 = Class.forName("org.postgresql.PGStatement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[1] = clazz4;
                    return Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)new StatementHandler(this, st));
                }
                return method.invoke((Object)this.con, args);
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getTargetException();
                if (te instanceof SQLException) {
                    PooledConnectionImpl.this.fireConnectionError((SQLException)te);
                }
                throw te;
            }
        }

        Connection getProxy() {
            return this.proxy;
        }

        void setProxy(Connection proxy) {
            this.proxy = proxy;
        }

        public void close() {
            if (this.con != null) {
                this.automatic = true;
            }
            this.con = null;
            this.proxy = null;
        }

        public boolean isClosed() {
            return this.con == null;
        }
    }

    private class StatementHandler
    implements InvocationHandler {
        private ConnectionHandler con;
        private Statement st;

        public StatementHandler(ConnectionHandler con, Statement st) {
            this.con = con;
            this.st = st;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                if (method.getName().equals("toString")) {
                    return "Pooled statement wrapping physical statement " + this.st;
                }
                if (method.getName().equals("hashCode")) {
                    return new Integer(this.st.hashCode());
                }
                if (!method.getName().equals("equals")) return method.invoke((Object)this.st, args);
                if (args[0] == null) {
                    return Boolean.FALSE;
                }
                try {
                    Boolean bl;
                    if (Proxy.isProxyClass(args[0].getClass()) && ((StatementHandler)Proxy.getInvocationHandler((Object)args[0])).st == this.st) {
                        bl = Boolean.TRUE;
                        return bl;
                    }
                    bl = Boolean.FALSE;
                    return bl;
                }
                catch (ClassCastException classCastException) {
                    return Boolean.FALSE;
                }
            }
            if (method.getName().equals("close")) {
                if (this.st == null) return null;
                if (this.con.isClosed()) {
                    return null;
                }
                try {
                    this.st.close();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.con = null;
                    this.st = null;
                    throw throwable;
                }
                {
                    Object var4_7 = null;
                    this.con = null;
                    this.st = null;
                    return null;
                }
            }
            if (this.st == null) throw new PSQLException(GT.tr("Statement has been closed."), PSQLState.OBJECT_NOT_IN_STATE);
            if (this.con.isClosed()) {
                throw new PSQLException(GT.tr("Statement has been closed."), PSQLState.OBJECT_NOT_IN_STATE);
            }
            if (method.getName().equals("getConnection")) {
                return this.con.getProxy();
            }
            try {
                return method.invoke((Object)this.st, args);
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getTargetException();
                if (!(te instanceof SQLException)) throw te;
                PooledConnectionImpl.this.fireConnectionError((SQLException)te);
                throw te;
            }
        }
    }
}

