/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateFunc;
import jp.sourceforge.gnp.prorate.ProrateRuleNumber;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

class ProrateFuncDiscount
extends ProrateFunc {
    ProrateFuncDiscount(List in_args) {
        super(in_args);
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) throws Exception {
        ProrateRuleObject pobj;
        block7: {
            double percent;
            block6: {
                ProrateSector sector;
                if (!this.checkArgnum(1, "Discount", runtime)) {
                    return null;
                }
                this.args.set(0, ((ProrateRuleObject)this.args.get(0)).copy(runtime));
                pobj = ((ProrateRuleObject)this.args.get(0)).eval(runtime);
                if (pobj == null) {
                    this.setErrorObject();
                    return null;
                }
                percent = 0.0;
                if (!pobj.isNumber()) {
                    this.error(2, "Discount:1", runtime);
                    return null;
                }
                percent = ((ProrateRuleNumber)pobj).getValue();
                if (!runtime.isSPA) break block6;
                runtime.sector.setSpaDiscountRate(runtime.sector.getSpaDiscountRate() * percent / 100.0);
                runtime.sector.setSpaNuc(runtime.sector.getSpaNuc() * percent / 100.0);
                if ((runtime.sector.getProrationType() & 0x200) == 0) break block7;
                for (int i = runtime.sectorIndex + 1; i < runtime.fcomp.getSectors().length && ((sector = runtime.fcomp.getSectors()[i]).getProrationType() & 0x200) != 0; ++i) {
                    runtime.sector.setSpaDiscountRate(sector.getSpaDiscountRate() * percent / 100.0);
                    runtime.sector.setSpaNuc(sector.getSpaNuc() * percent / 100.0);
                }
                break block7;
            }
            runtime.sector.setApdpDiscountRate(runtime.sector.getApdpDiscountRate() * percent / 100.0);
            runtime.sector.setApdpNuc(runtime.sector.getApdpNuc() * percent / 100.0);
            if ((runtime.sector.getProrationType() & 0x800) != 0) {
                ProrateSector sector;
                for (int i = runtime.sectorIndex + 1; i < runtime.fcomp.getSectors().length && ((sector = runtime.fcomp.getSectors()[i]).getProrationType() & 0x800) != 0; ++i) {
                    runtime.sector.setApdpDiscountRate(sector.getApdpDiscountRate() * percent / 100.0);
                    runtime.sector.setApdpNuc(sector.getApdpNuc() * percent / 100.0);
                }
            }
        }
        return pobj;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateFuncDiscount pobj = new ProrateFuncDiscount(new Vector(this.args));
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print("Discount(");
        super.dump();
    }

    @Override
    public String operatorString() {
        return "Discount";
    }
}

