/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateDatabase;
import jp.sourceforge.gnp.prorate.ProrateFunc;
import jp.sourceforge.gnp.prorate.ProrateRuleAmount;
import jp.sourceforge.gnp.prorate.ProrateRuleEnd;
import jp.sourceforge.gnp.prorate.ProrateRuleMultival;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuleString;
import jp.sourceforge.gnp.prorate.ProrateRuntime;

class ProrateFuncPfm
extends ProrateFunc {
    ProrateFuncPfm(List in_args) {
        super(in_args);
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) throws Exception {
        if (!this.checkArgnum(1, "Pfm", runtime)) {
            return null;
        }
        this.args.set(0, ((ProrateRuleObject)this.args.get(0)).copy(runtime));
        ProrateRuleObject code = ((ProrateRuleObject)this.args.get(0)).eval(runtime);
        if (code == null) {
            this.setErrorObject();
            return null;
        }
        ProrateRuleObject ret = this.getPfm("Pfm", runtime, code);
        if (ret != null) {
            this.setEvaluatedObject(ret);
            ret = ret.eval(runtime);
            if (runtime.isSPA) {
                runtime.sector.setProrationType(runtime.sector.getProrationType() & 0xF1000D00 & 0xFFFDFFFF | 0x10000);
            } else if ((runtime.sector.getProrationType() & 0x1000000) != 0) {
                runtime.sector.setProrationType(runtime.sector.getProrationType() | 0x100);
            } else {
                runtime.sector.setProrationType(runtime.sector.getProrationType() & 0xFFFDFFFF | 0x10000);
            }
        } else {
            ret = new ProrateRuleEnd();
            this.setEvaluatedObject(ret);
            ret = ret.eval(runtime);
        }
        return ret;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateFuncPfm pobj = new ProrateFuncPfm(new Vector(this.args));
        pobj.isCopied = true;
        return pobj;
    }

    ProrateRuleAmount getPfm(String caller, ProrateRuntime runtime, ProrateRuleObject pobj) throws Exception {
        ProrateDatabase db = runtime.getAuditImpl().database;
        if (pobj.isMultival()) {
            List codes = ((ProrateRuleMultival)pobj).getValues();
            codes.set(0, ((ProrateRuleObject)codes.get(0)).copy(runtime));
            pobj = ((ProrateRuleObject)codes.get(0)).eval(runtime);
            if (pobj == null) {
                this.setErrorObject();
                return null;
            }
        }
        if (!pobj.isString()) {
            this.error(2, caller + ":1", runtime);
            return null;
        }
        String code = ((ProrateRuleString)pobj).getValue().substring(0, 1);
        String code2 = (String)codeConversionMap.get(code);
        for (int i = 0; i < code2.length(); ++i) {
            ProrateDatabase.Amount amount = db.getBaseAmount(runtime.sector.getDepCode(), runtime.sector.getDestCode(), runtime.sector.getCarrier(), code2.substring(i, i + 1), runtime.audit.getIssueDate());
            if (amount != null) {
                return new ProrateRuleAmount(amount.currency, amount.value);
            }
            if (db.getResult() <= 1) continue;
            StringBuffer depDest = new StringBuffer(runtime.sector.getDepCode());
            depDest.append("-");
            depDest.append(runtime.sector.getDestCode());
            StringBuffer carrierClass = new StringBuffer(runtime.sector.getCarrier());
            carrierClass.append(",");
            carrierClass.append(code2.charAt(i));
            this.DBError(runtime, "getBaseAmount", depDest.toString(), carrierClass.toString());
            return null;
        }
        this.error(6, caller + ":1:" + runtime.sector.getDepCode() + "-" + runtime.sector.getDestCode() + "(" + runtime.sector.getCarrier() + ")" + code, runtime);
        return null;
    }

    @Override
    public void dump() {
        System.out.print("Pfm(");
        super.dump();
    }

    @Override
    public String operatorString() {
        return "Pfm";
    }
}

