/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateFunc;
import jp.sourceforge.gnp.prorate.ProrateRuleBool;
import jp.sourceforge.gnp.prorate.ProrateRuleMultival;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuleString;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

class ProrateFuncViaArea
extends ProrateFunc {
    ProrateFuncViaArea(List in_args) {
        super(in_args);
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) throws Exception {
        if (!this.checkArgnum(1, "Via_area", runtime)) {
            return null;
        }
        this.args.set(0, ((ProrateRuleObject)this.args.get(0)).copy(runtime));
        ProrateRuleObject pobj = ((ProrateRuleObject)this.args.get(0)).eval(runtime);
        if (pobj == null) {
            this.setErrorObject();
            return null;
        }
        if (pobj.isMultival()) {
            List values = ((ProrateRuleMultival)pobj).getValues();
            for (int i = 0; i < values.size(); ++i) {
                ProrateRuleObject pobj2 = ((ProrateRuleObject)values.get(i)).copy(runtime);
                values.set(i, pobj2.copy(runtime));
                ProrateRuleObject subobj = ((ProrateRuleObject)values.get(i)).eval(runtime);
                if (subobj == null) {
                    this.setErrorObject();
                    return null;
                }
                if (!subobj.isString()) {
                    this.error(2, "Via_area:1", runtime);
                    return null;
                }
                if (!this.viaArea(subobj, runtime)) continue;
                this.setEvaluatedObject(new ProrateRuleBool(true));
                return this.evaluatedObject;
            }
            this.setEvaluatedObject(new ProrateRuleBool(false));
            return this.evaluatedObject;
        }
        if (!pobj.isString()) {
            this.error(2, "Via_area:1", runtime);
            return null;
        }
        ProrateRuleBool ret = new ProrateRuleBool(this.viaArea(pobj, runtime));
        this.setEvaluatedObject(ret);
        return ret;
    }

    boolean viaArea(ProrateRuleObject pobj, ProrateRuntime runtime) {
        String area = ((ProrateRuleString)pobj).getValue();
        ProrateSector sector = runtime.fcomp.getSectors()[0];
        if (this.multiEq(this.getAreaName(runtime, sector.getDestCode()), area)) {
            return true;
        }
        for (int i = 1; i < runtime.fcomp.getSectors().length; ++i) {
            sector = runtime.fcomp.getSectors()[i];
            String depArea = this.getAreaName(runtime, sector.getDepCode());
            String destArea = this.getAreaName(runtime, sector.getDestCode());
            if (!this.multiEq(depArea, area) && (!this.multiEq(destArea, area) || i >= runtime.fcomp.getSectors().length - 1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateFuncViaArea pobj = new ProrateFuncViaArea(new Vector(this.args));
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print("Via_area(");
        super.dump();
    }

    @Override
    public String operatorString() {
        return "Via_area_p";
    }
}

