/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import jp.sourceforge.gnp.prorate.ProrateDatabase;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

class ProrateRuleAmount
extends ProrateRuleObject {
    protected String currency;
    protected double value;

    ProrateRuleAmount(String in_currency, double in_value) {
        this.currency = in_currency;
        this.value = in_value;
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) {
        ProrateDatabase db;
        double day5Rate;
        this.evaluatedObject = this;
        if (runtime.hops > 2) {
            if (!this.setMultiPath(runtime.hops - 1, runtime)) {
                this.error(5, "AMOUNT", runtime);
            }
            return this;
        }
        double d = day5Rate = runtime.isSPA ? runtime.sector.getSpaDay5Rate() : runtime.sector.getApdpDay5Rate();
        if (day5Rate <= 0.0 && (day5Rate = (db = runtime.getAuditImpl().database).getMeanRate(this.currency, runtime.audit.getInvoiceMonth())) <= 0.0 && (day5Rate = db.get5dayRate(this.currency, runtime.audit.getInvoiceMonth())) < 0.0) {
            if (runtime.audit.getDay5Rate() <= 0.0) {
                if (db.getResult() > 1) {
                    this.DBError(runtime, "get5dayRate", this.currency, runtime.audit.getInvoiceMonth());
                    return this;
                }
                int errorNo = runtime.isSPA ? 69 : 70;
                String errorMessage = this.currency;
                this.error(errorNo, errorMessage + ":" + runtime.audit.getInvoiceMonth(), runtime);
                return this;
            }
            day5Rate = runtime.audit.getDay5Rate();
        }
        if (runtime.isSPA) {
            runtime.sector.setSpaBaseAmtType(this.currency);
            runtime.sector.setSpaBaseAmt(this.value);
            runtime.sector.setSpaNuc(runtime.sector.getSpaDiscountRate() * this.value / day5Rate);
            runtime.sector.setProrationType(runtime.sector.getProrationType() & 0xF1000D00 | 0x1000000 | 0x20000);
        } else {
            runtime.sector.setApdpBaseAmtType(this.currency);
            runtime.sector.setApdpBaseAmt(this.value);
            runtime.sector.setApdpNuc(runtime.sector.getApdpDiscountRate() * this.value / day5Rate);
            if ((runtime.sector.getProrationType() & 0x1000000) != 0) {
                runtime.sector.setProrationType(runtime.sector.getProrationType() | 0x100);
            } else {
                runtime.sector.setProrationType(0x2020100);
            }
        }
        return this;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateRuleAmount pobj = new ProrateRuleAmount(this.currency, this.value);
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    boolean isAmount() {
        return true;
    }

    boolean setMultiPath(int hops, ProrateRuntime runtime) {
        ProrateDatabase db;
        double day5Rate;
        if (runtime.sectorIndex + hops > runtime.fcomp.getSectors().length) {
            return false;
        }
        double totalProrateFactor = runtime.sector.getProrateFactor();
        for (int i = runtime.sectorIndex + 1; i < runtime.sectorIndex + hops; ++i) {
            ProrateSector sector = runtime.fcomp.getSectors()[i];
            if (!(runtime.sector.getCarrier().equals(sector.getCarrier()) && runtime.sector.getFareBasis().equals(sector.getFareBasis()) && runtime.sector.getClassOfService().equals(sector.getClassOfService()))) {
                return false;
            }
            totalProrateFactor += runtime.fcomp.getSectors()[i].getProrateFactor();
        }
        double d = day5Rate = runtime.isSPA ? runtime.sector.getSpaDay5Rate() : runtime.sector.getApdpDay5Rate();
        if (day5Rate <= 0.0 && (day5Rate = (db = runtime.getAuditImpl().database).getMeanRate(this.currency, runtime.audit.getInvoiceMonth())) <= 0.0 && (day5Rate = db.get5dayRate(this.currency, runtime.audit.getInvoiceMonth())) < 0.0) {
            if (runtime.audit.getDay5Rate() <= 0.0) {
                if (db.getResult() > 1) {
                    this.DBError(runtime, "get5dayRate", this.currency, runtime.audit.getInvoiceMonth());
                    return false;
                }
                int errorNo = runtime.isSPA ? 69 : 70;
                String errorMessage = this.currency;
                this.error(errorNo, errorMessage + ":" + runtime.audit.getInvoiceMonth(), runtime);
                return false;
            }
            day5Rate = runtime.audit.getDay5Rate();
        }
        for (int j = runtime.sectorIndex; j < runtime.sectorIndex + hops; ++j) {
            ProrateSector sector = runtime.fcomp.getSectors()[j];
            if (runtime.isSPA) {
                sector.setSpaBaseAmtType(this.currency);
                sector.setSpaBaseAmt(this.value);
                sector.setSpaDiscountRate(runtime.sector.getSpaDiscountRate());
                sector.setSpaNuc(sector.getSpaDiscountRate() * this.value * sector.getProrateFactor() / totalProrateFactor / day5Rate);
                sector.setProrationType(sector.getProrationType() & 0xF1000D00 | 0x1000000 | 0x20000 | 0x200);
                continue;
            }
            sector.setApdpBaseAmtType(this.currency);
            sector.setApdpBaseAmt(this.value);
            sector.setApdpDiscountRate(runtime.sector.getApdpDiscountRate());
            sector.setApdpNuc(sector.getApdpDiscountRate() * this.value * sector.getProrateFactor() / totalProrateFactor / day5Rate);
            if ((sector.getProrationType() & 0x1000000) != 0) {
                sector.setProrationType(sector.getProrationType() | 0x100);
                continue;
            }
            sector.setProrationType(0x2020900);
        }
        return true;
    }

    String getCurrency() {
        return this.currency;
    }

    double getValue() {
        return this.value;
    }

    @Override
    public void dump() {
        System.out.print("AMOUNT(" + this.currency + " " + this.value + ")");
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer("AMOUNT(");
        strbuf.append(this.currency);
        strbuf.append(" ");
        strbuf.append(this.value);
        strbuf.append(")");
        return strbuf.toString();
    }

    @Override
    String traceStr() {
        return this.toString();
    }
}

