/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuleString;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

class ProrateRuleNumber
extends ProrateRuleObject {
    protected double value;

    ProrateRuleNumber(double number) {
        this.value = number;
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) {
        this.evaluatedObject = this;
        return this;
    }

    @Override
    boolean isNumber() {
        return true;
    }

    double getValue() {
        return this.value;
    }

    void setValue(double number) {
        this.value = number;
    }

    @Override
    boolean equal(ProrateRuleObject other) {
        if (other.isMultival() || other.isInterval()) {
            return other.equal(this);
        }
        if (other.isNumber()) {
            return this.value == ((ProrateRuleNumber)other).getValue();
        }
        if (other.isString()) {
            String cdrStr = ((ProrateRuleString)other).getValue();
            int cdrNum = Integer.parseInt(cdrStr);
            return this.value == (double)cdrNum;
        }
        return false;
    }

    @Override
    boolean gtEq(ProrateRuleObject other) {
        if (other.isMultival() || other.isInterval()) {
            return other.ltEq(this);
        }
        if (other.isNumber()) {
            return this.value >= ((ProrateRuleNumber)other).getValue();
        }
        return false;
    }

    @Override
    boolean ltEq(ProrateRuleObject other) {
        if (other.isMultival() || other.isInterval()) {
            return other.gtEq(this);
        }
        if (other.isNumber()) {
            return this.value <= ((ProrateRuleNumber)other).getValue();
        }
        return false;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateRuleNumber pobj = new ProrateRuleNumber(this.value);
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print(" " + this.value + " ");
    }

    @Override
    void dumpValue() {
    }

    @Override
    boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
        return true;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    String traceStr() {
        return this.toString();
    }
}

