/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate.ejb;

import javax.ejb.Stateless;
import jp.sourceforge.gnp.prorate.ProrateImpl;
import jp.sourceforge.gnp.prorate.ProrateRuleObjectFactory;
import jp.sourceforge.gnp.prorate.ProrateTaxImpl;
import jp.sourceforge.gnp.prorate.ProrateTraceString;
import jp.sourceforge.gnp.prorate.database.ProrateRdb;
import jp.sourceforge.gnp.prorate.ejb.interfaces.ProrateEjb;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateException;
import jp.sourceforge.gnp.prorate.fcalc.ProrateFCalcImpl;
import jp.sourceforge.gnp.rulebase.xml.XmlRulebaseLru;

@Stateless
public class ProrateEjbBean
implements ProrateEjb {
    ProrateImpl prorate = null;

    public ProrateEjbBean() throws Exception {
        XmlRulebaseLru rulebase = null;
        try {
            rulebase = new XmlRulebaseLru();
            XmlRulebaseLru.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProrateException("error in rulebase initialize", e);
        }
        ProrateRuleObjectFactory factory = new ProrateRuleObjectFactory();
        rulebase.setElementFactory(factory);
        this.prorate = new ProrateImpl();
        this.prorate.setRulebase(rulebase);
        this.prorate.setFcalc(new ProrateFCalcImpl());
        this.prorate.setTax(new ProrateTaxImpl());
        ProrateTraceString trace = new ProrateTraceString();
        this.prorate.setTrace(trace);
        this.prorate.setDatabase(new ProrateRdb());
        if (!this.prorate.getDatabase().openDatabase()) {
            throw new ProrateException("database open error:" + this.prorate.getDatabase().getErrMessage(), null);
        }
    }

    @Override
    public ProrateAudit prorate(ProrateAudit audit) throws ProrateException {
        this.prorate.getTrace().setData(audit);
        ProrateAudit auditRet = null;
        try {
            auditRet = this.prorate.prorate(audit);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProrateException("error in prorate", e);
        }
        this.prorate.getTrace().close();
        ProrateTraceString traceString = (ProrateTraceString)this.prorate.getTrace();
        String[] stringsArray = new String[traceString.getStrings().size()];
        for (int i = 0; i < traceString.getStrings().size(); ++i) {
            stringsArray[i] = (String)traceString.getStrings().get(i);
        }
        auditRet.setTraceStrings(stringsArray);
        return auditRet;
    }
}

