/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate.fcalc;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateAuditImpl;
import jp.sourceforge.gnp.prorate.ProrateFcalc;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.prorate.fcalc.Yylex;

public class ProrateFCalcImpl
implements ProrateFcalc,
Serializable {
    private static final long serialVersionUID = 1L;
    static final int ResultAllTkSector = 0;
    static final int ResultSectorCheckFail = 1;
    static final int ResultPlusCheckFail = 2;
    static final int ResultSecurityCharge = 3;
    static final int ResultClassDiff = 4;
    static final int ResultDifficultDiff = 5;
    static final int ResultNoTotalCurrency = 6;
    static final int ResultLess = 7;
    static final int ResultSurface = 8;
    static final int ResultSurfaceOnEnd = 9;
    static final int ResultParseError = 10;
    static final int ResultParseErrorO = 11;
    static final int ResultParseErrorB = 12;
    static final int ResultValueZero = 13;
    static final int ResultLowestCombi = 14;
    static final int ResultFcompNoEnd = 15;
    static final int ResultTotalSumFail = 16;
    static final int ResultPlusNormal = 17;
    static final int ResultPlusSector = 18;
    static final int ResultPlusHalfRt = 19;
    static final int ResultPlusYSect = 20;
    static final int ResultPlusLowCombi = 21;
    static final int ResultOverMaxTax = 22;
    static final int ResultFTax = 23;
    static final int ResultSideTrip = 24;
    static final int ResultRoeBeforeEnd = 25;
    static final int MAX_FC_RESULT = 26;
    static final int MAX_TAX = 32;
    static final int MAX_DIFFS = 32;
    static final int MAX_FC = 60;
    static final int MAX_FC_COMP = 60;
    ProrateAudit audit = null;
    ProrateAuditImpl auditImpl;
    Yylex yylex;
    int lex = -1;
    int[] oldlex = new int[3];
    int[] oldpos = new int[3];
    static final double ZERO_VALUE = 0.0;
    int def_point = -1;
    int side_start = 0;
    boolean free_flag = false;
    double stop_over_sum = 0.0;
    double stop_over_tmp = 0.0;
    int place_no = 0;
    boolean place_no_fix = false;
    _fare_cal[] fc = new _fare_cal[60];
    int mileage = 0;
    int[] fc_id = new int[60];
    double roe_rate = 0.0;
    double total = 0.0;
    String total_type = "";
    double add_stop_over_chrg = 0.0;
    double less = 0.0;
    int tax_no;
    _tax_value[] tx = new _tax_value[32];
    int FC_RESULT = 0;
    boolean fc_error = false;
    boolean plus = false;
    int it_cnt = 0;
    boolean it_flg = false;
    _diff_table[] dftbl = new _diff_table[32];
    int diff_index = 0;
    boolean[] diffApplicable = new boolean[32];
    boolean hpn_roe_end = false;
    static int[] stop_lex = new int[]{280, 281, 282, 283, 331, 346, 290, 291, 292, 293, 294, 295, 296, 297, 330, -1};

    @Override
    public boolean analyze(ProrateAuditImpl auditImpl, ProrateAudit audit) {
        this.setAuditImpl(auditImpl);
        this.audit = audit;
        this.fc_error = false;
        boolean status = true;
        boolean analyzeStatus = true;
        String[] fareCal = new String[]{audit.getFareCalculation()};
        audit.setFareDirtyFlag(1);
        int[] fareCalPtr = new int[]{0};
        if (!this.preProcess(fareCal)) {
            StringBuffer errorString = new StringBuffer("error in analyzing fare calculation [");
            errorString.append(this.makeFcResultStr(this.FC_RESULT));
            errorString.append("]");
            errorString.append(fareCal[0]);
            this.getAuditImpl().error(37, errorString.toString());
            this.terminate();
            return false;
        }
        analyzeStatus = this.doAnalyze(fareCal[0], fareCalPtr);
        status = analyzeStatus;
        if (!status) {
            this.debugFareCalInfo(fareCal[0], fareCalPtr[0]);
            if (this.oldlex[0] >= 280 && this.oldlex[0] <= 283 || this.oldlex[0] == 331 || this.oldlex[0] == 346 || this.oldlex[0] >= 290 && this.oldlex[0] <= 297 || this.oldlex[0] == 330) {
                if (this.skipFareBasis(fareCalPtr[0] - this.oldpos[0], fareCalPtr, fareCal)) {
                    fareCalPtr[0] = 0;
                    status = analyzeStatus = this.doAnalyze(fareCal[0], fareCalPtr);
                }
            } else if ((this.oldlex[1] >= 280 && this.oldlex[1] <= 283 || this.oldlex[1] == 331 || this.oldlex[1] == 346 || this.oldlex[1] >= 290 && this.oldlex[1] <= 297 || this.oldlex[1] == 330) && this.oldlex[0] >= 270 && this.oldlex[0] <= 271) {
                if (this.skipFareBasis(fareCalPtr[0] - this.oldpos[0] - this.oldpos[1], fareCalPtr, fareCal)) {
                    fareCalPtr[0] = 0;
                    status = analyzeStatus = this.doAnalyze(fareCal[0], fareCalPtr);
                }
            } else if ((this.oldlex[2] >= 280 && this.oldlex[2] <= 283 || this.oldlex[2] == 331 || this.oldlex[2] == 346 || this.oldlex[2] >= 290 && this.oldlex[2] <= 297 || this.oldlex[2] == 330) && this.oldlex[1] >= 270 && this.oldlex[1] <= 271 && this.oldlex[0] >= 260 && this.oldlex[0] <= 266 && this.skipFareBasis(fareCalPtr[0] - this.oldpos[0] - this.oldpos[1] - this.oldpos[2], fareCalPtr, fareCal)) {
                fareCalPtr[0] = 0;
                status = analyzeStatus = this.doAnalyze(fareCal[0], fareCalPtr);
            }
            if (!status) {
                this.debugFareCalInfo(fareCal[0], fareCalPtr[0]);
            }
        }
        if (status) {
            status = this.setFareCalInfo();
        }
        this.debugFareCalInfo(fareCal[0], fareCalPtr[0]);
        if (!status) {
            if (this.skipFareBasis(0, fareCalPtr, fareCal, false)) {
                fareCalPtr[0] = 0;
                status = analyzeStatus = this.doAnalyze(fareCal[0], fareCalPtr);
            }
            if (status) {
                status = this.setFareCalInfo();
                this.debugFareCalInfo(fareCal[0], fareCalPtr[0]);
            }
        }
        if (!status || this.fc_error) {
            StringBuffer errorString = new StringBuffer("error in analyzing fare calculation [");
            errorString.append(this.makeFcResultStr(this.FC_RESULT));
            errorString.append("]");
            if (!analyzeStatus) {
                errorString.append(fareCal[0].substring(fareCalPtr[0] - this.yylex.yytext().length()));
            }
            this.getAuditImpl().error(37, errorString.toString());
        }
        fareCal = null;
        if (this.fc_error) {
            this.terminate();
            return false;
        }
        if (this.plus) {
            audit.setPlusFlg(true);
        }
        this.terminate();
        return status;
    }

    boolean doAnalyze(String fareCal, int[] fareCalPtr) {
        return this.doAnalyze(fareCal, fareCalPtr, null, null);
    }

    boolean doAnalyze(String fareCal, int[] fareCalPtr, int[] stop_lex, int[] stop_pos) {
        boolean status = false;
        int stopPos = -1;
        this.yylex = new Yylex(new StringReader(fareCal.substring(fareCalPtr[0])));
        this.initialize();
        this.lex = 0;
        while (!this.isFinish(fareCal, this.yylex.getPos())) {
            this.oldlex[2] = this.oldlex[1];
            this.oldlex[1] = this.oldlex[0];
            this.oldlex[0] = this.lex;
            try {
                this.lex = this.yylex.yylex();
                if (this.lex < 0) {
                    break;
                }
            }
            catch (IOException e) {
                return false;
            }
            fareCalPtr[0] = this.yylex.getPos();
            this.oldpos[2] = this.oldpos[1];
            this.oldpos[1] = this.oldpos[0];
            this.oldpos[0] = this.yylex.yytext().length();
            if (stop_lex != null) {
                int i = 0;
                while (stop_lex[i] >= 0) {
                    if (this.lex == stop_lex[i] && stop_pos != null && ++stopPos > stop_pos[0]) {
                        stop_pos[0] = stopPos;
                        return false;
                    }
                    ++i;
                }
            }
            if (status = this.getFareCalInfo()) continue;
        }
        if (!this.place_no_fix && !this.yylex.get_end) {
            this.place_no_fix = true;
            --this.place_no;
        }
        if (stop_pos != null) {
            stop_pos[0] = -1;
        }
        return status;
    }

    boolean setFareCalInfo() {
        if (this.place_no == 0 || this.free_flag) {
            this.FC_RESULT |= 1;
            return true;
        }
        if (!this.yylex.hpn_end) {
            this.FC_RESULT |= 0x8000;
        }
        if (this.total_type.equals("")) {
            this.FC_RESULT |= 0x40;
            return false;
        }
        if (this.audit.getSectors().length > 0) {
            if (!this.sectorCheck()) {
                this.FC_RESULT |= 2;
                return false;
            }
            if (this.plus && this.diff_index == 0 && !this.plusCheck()) {
                this.FC_RESULT |= 4;
                return false;
            }
        } else if (!this.sectorCreate()) {
            return false;
        }
        if (!this.totalSumCheck()) {
            this.FC_RESULT |= 0x10000;
            if (this.total != 0.0) {
                return false;
            }
        }
        if (this.roe_rate > 0.0) {
            this.audit.setRoeRate(this.roe_rate);
        }
        double roerate = 1.0;
        if (this.roe_rate > 0.0 && !this.total_type.equals("NUC")) {
            roerate = this.roe_rate;
        }
        this.audit.setTotalNuc(this.total / roerate);
        int si = 0;
        boolean isFareComponent = false;
        for (int i = 0; i < this.place_no; ++i) {
            if (this.fc[i].carrier.equals("XX") || this.fc[i].carrier.equals("//")) {
                if (this.fc[i].compo_end == 1) {
                    this.FC_RESULT |= 0x200;
                    if (si <= 0) {
                        return false;
                    }
                    ProrateSector beforeSector = this.audit.getSectors()[si - 1];
                    if (beforeSector.getFareComponent() > 0.0) {
                        return false;
                    }
                    beforeSector.setFareComponent(this.fc[i].fare_component < 0.0 ? -1.0 : this.fc[i].fare_component / roerate);
                }
                if (!this.audit.getSectors()[si].getCarrier().equals("XX") && !this.audit.getSectors()[si].getCarrier().equals("//")) continue;
                ++si;
                continue;
            }
            ProrateSector sector = this.audit.getSectors()[si];
            sector.setFareComponent(this.fc[i].fare_component < 0.0 ? -1.0 : this.fc[i].fare_component / roerate);
            if (sector.getFareComponent() >= 0.0) {
                isFareComponent = true;
            }
            sector.setSecureCharge(this.fc[i].security_chrg / roerate);
            sector.setSideTripPlus(this.fc[i].side_trip_plus < 0.0 ? -1.0 : this.fc[i].side_trip_plus / roerate);
            sector.setClassDiffIndex(this.fc[i].diff_index > 0 ? 68 : 0);
            sector.setExstPlus(this.fc[i].exst_plus / roerate);
            sector.setComponentIndex(this.fc[i].fare_compo_kbn);
            sector.setComponentKind(this.fc[i].fare_compo_kind);
            sector.setClassDiffPlus(this.fc[i].class_differ_plus);
            sector.setSideTripIndex(this.fc[i].side_trip_index);
            sector.setSecureIndex(this.fc[i].security_index);
            sector.setViaRouting(this.fc[i].via);
            ++si;
        }
        if (this.mileage == 1 && !isFareComponent) {
            this.audit.getSectors()[si - 1].setFareComponent(this.total);
        }
        this.audit.setLessAmt(this.less);
        this.audit.setStopOverCharge(this.add_stop_over_chrg);
        return true;
    }

    void initialize() {
        int i;
        this.yylex.get_end = false;
        this.yylex.hpn_end = false;
        this.hpn_roe_end = false;
        this.def_point = 0;
        this.side_start = 0;
        this.free_flag = true;
        this.stop_over_tmp = 0.0;
        this.stop_over_sum = 0.0;
        this.place_no = 0;
        this.place_no_fix = false;
        for (i = 0; i < 60; ++i) {
            this.fc[i] = new _fare_cal();
            this.fc[i].fare_component = -1.0;
            this.fc[i].side_trip_plus = -1.0;
        }
        this.mileage = 0;
        for (i = 0; i < 60; ++i) {
            this.fc_id[i] = 0;
        }
        this.roe_rate = 0.0;
        this.total = 0.0;
        this.total_type = "";
        this.add_stop_over_chrg = 0.0;
        this.less = 0.0;
        this.tax_no = 0;
        for (i = 0; i < 32; ++i) {
            this.tx[i] = new _tax_value();
        }
        this.FC_RESULT = 0;
        this.it_cnt = 0;
        this.it_flg = false;
        for (i = 0; i < 32; ++i) {
            this.dftbl[i] = new _diff_table();
            this.diffApplicable[i] = false;
        }
        this.diff_index = 0;
    }

    void terminate() {
        int i;
        for (i = 0; i < 60; ++i) {
            this.fc[i] = null;
        }
        for (i = 0; i < 32; ++i) {
            this.tx[i] = null;
        }
        for (i = 0; i < 32; ++i) {
            this.dftbl[i] = null;
        }
    }

    boolean isFinish(String fareCal, int fareCalPtr) {
        return fareCalPtr >= fareCal.length();
    }

    boolean getFareCalInfo() {
        String[] fromPlace = new String[1];
        String[] toPlace = new String[1];
        int[] fromId = null;
        int[] toId = null;
        int[] nextId = null;
        boolean isDiffApplied = false;
        double plus_total = 0.0;
        switch (this.lex) {
            case 257: {
                break;
            }
            case 258: {
                break;
            }
            case 260: {
                if (this.place_no == 0) {
                    this.fc[0].dep_code = this.yylex.yytext();
                } else {
                    this.fc[this.place_no - 1].dest_code = this.yylex.yytext();
                    this.fc[this.place_no].dep_code = this.yylex.yytext();
                    this.fc[this.place_no - 1].fare_compo_kbn = this.mileage;
                }
                ++this.place_no;
                break;
            }
            case 261: 
            case 262: {
                if (this.place_no == 0) {
                    this.fc[0].dep_code = this.right(this.yylex.yytext(), 3);
                    this.fc[0].stop_over = (char)88;
                } else {
                    this.fc[this.place_no].dep_code = this.fc[this.place_no - 1].dest_code = this.right(this.yylex.yytext(), 3);
                    this.fc[this.place_no].stop_over = (char)88;
                    this.fc[this.place_no - 1].fare_compo_kbn = this.mileage;
                }
                ++this.place_no;
                break;
            }
            case 264: 
            case 265: {
                if (this.place_no == 0) {
                    this.fc[0].dep_code = this.right(this.yylex.yytext(), 3);
                } else {
                    this.fc[this.place_no].dep_code = this.fc[this.place_no - 1].dest_code = this.right(this.yylex.yytext(), 3);
                    this.fc[this.place_no - 1].fare_compo_kbn = this.mileage;
                }
                ++this.place_no;
                break;
            }
            case 320: {
                break;
            }
            case 319: {
                if (this.place_no == 0) {
                    this.fc[0].dep_code = this.right(this.yylex.yytext(), 3);
                } else {
                    this.fc[this.place_no - 1].dest_code = this.right(this.yylex.yytext(), 3);
                    this.fc[this.place_no - 1].carrier = "XX";
                    this.fc[this.place_no].dep_code = this.fc[this.place_no - 1].dest_code;
                    this.fc[this.place_no - 1].fare_compo_kbn = this.mileage;
                }
                ++this.place_no;
                this.FC_RESULT |= 0x4000;
                break;
            }
            case 266: {
                if (this.place_no == 0) {
                    this.FC_RESULT |= 0x400;
                    return false;
                }
                this.fc[this.place_no - 1].dest_code = this.yylex.yytext().substring(1, 4);
                this.fc[this.place_no - 1].carrier = "XX";
                this.fc[this.place_no].dep_code = this.fc[this.place_no - 1].dest_code;
                this.fc[this.place_no - 1].fare_compo_kbn = this.mileage;
                ++this.place_no;
                this.FC_RESULT |= 0x100;
                break;
            }
            case 270: {
                if (this.place_no == 0) {
                    this.FC_RESULT |= 0x400;
                    return false;
                }
                this.fc[this.place_no - 1].carrier = this.yylex.yytext();
                break;
            }
            case 271: {
                if (this.place_no == 0) {
                    this.FC_RESULT |= 0x400;
                    return false;
                }
                this.fc[this.place_no - 1].carrier = this.yylex.yytext().substring(0, 2);
                this.fc[this.place_no - 1].via = this.right(this.yylex.yytext(), 4).substring(1, 3);
                break;
            }
            case 272: {
                if (this.place_no == 0) {
                    this.FC_RESULT |= 0x400;
                    return false;
                }
                this.fc[this.place_no - 1].carrier = "XX";
                this.FC_RESULT |= 0x100;
                break;
            }
            case 280: 
            case 281: 
            case 282: 
            case 283: {
                if (this.place_no < 2) {
                    this.FC_RESULT |= 0x400;
                    return false;
                }
                this.fc[this.place_no - 2].compo_end = 1;
                this.fc_id[this.mileage] = this.place_no - 2;
                double value = this.getNumber(this.yylex.yytext());
                if (value == 0.0) {
                    value = 0.0;
                    this.FC_RESULT |= 0x2000;
                } else {
                    this.free_flag = false;
                }
                if (this.side_start == 0) {
                    for (int i = this.def_point; i < this.place_no - 1; ++i) {
                        if (this.fc[i].fare_compo_kind != 0) continue;
                        this.fc[i].fare_compo_kind = 1;
                    }
                    this.def_point = this.place_no - 1;
                    ++this.mileage;
                    this.fc[this.place_no - 2].fare_component = value;
                    break;
                }
                for (int i = this.side_start; i < this.place_no - 1; ++i) {
                    this.fc[i].fare_compo_kind = 3;
                    this.fc[i].side_trip_index = 83;
                }
                this.fc[this.place_no - 2].side_trip_plus = value;
                break;
            }
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 330: {
                int i;
                double value = this.getNumber(this.yylex.yytext());
                fromId = new int[1];
                toId = new int[1];
                nextId = new int[]{-1};
                toId[0] = -1;
                fromId[0] = -1;
                while (this.analyzeFromTo(true, fromId, toId, nextId, fromPlace, toPlace)) {
                    if (this.lex == 330) {
                        for (i = fromId[0]; i <= toId[0]; ++i) {
                            this.fc[i].exst_plus = value;
                        }
                        continue;
                    }
                    boolean isAlreadyDiff = false;
                    for (i = fromId[0]; i <= toId[0]; ++i) {
                        if (this.fc[i].diff_index <= 0) continue;
                        isAlreadyDiff = true;
                    }
                    if (isAlreadyDiff || fromId[0] < 0 || toId[0] < 0) continue;
                    for (i = fromId[0]; i <= toId[0]; ++i) {
                        this.fc[i].diff_index = this.diff_index + 1;
                    }
                    this.fc[toId[0]].class_differ_plus = value;
                    isDiffApplied = true;
                }
                if (!isDiffApplied) {
                    for (i = 0; i < this.diff_index + 1; ++i) {
                        if ((!this.dftbl[i].from.equals(fromPlace[0]) || !this.dftbl[i].to.equals(toPlace[0])) && (!this.dftbl[i].from.equals(toPlace[0]) || !this.dftbl[i].to.equals(fromPlace[0])) || value != this.dftbl[i].value) continue;
                        if (this.dftbl[i].count >= 2) {
                            this.FC_RESULT |= 0x20;
                            this.fc_error = true;
                            return false;
                        }
                        this.dftbl[i].count = 2;
                        return true;
                    }
                    this.FC_RESULT |= 0x20;
                    this.fc_error = true;
                    return false;
                }
                if (this.lex == 330) {
                    this.FC_RESULT |= 0x20;
                    this.fc_error = true;
                    return false;
                }
                if (toPlace[0].compareTo(fromPlace[0]) > 0) {
                    this.dftbl[this.diff_index + 1].from = toPlace[0];
                    this.dftbl[this.diff_index + 1].to = fromPlace[0];
                    this.dftbl[this.diff_index + 1].value = value;
                    this.dftbl[this.diff_index + 1].count = 1;
                } else {
                    this.dftbl[this.diff_index + 1].from = fromPlace[0];
                    this.dftbl[this.diff_index + 1].to = toPlace[0];
                    this.dftbl[this.diff_index + 1].value = value;
                    this.dftbl[this.diff_index + 1].count = 1;
                }
                ++this.diff_index;
                this.FC_RESULT |= 0x10;
                break;
            }
            case 300: {
                double value = this.getNumber(this.yylex.yytext());
                if (Character.isLowerCase(this.yylex.yytext().charAt(0)) || Character.isUpperCase(this.yylex.yytext().charAt(0))) {
                    this.add_stop_over_chrg = value;
                } else {
                    if (this.place_no < 2) {
                        this.FC_RESULT |= 0x400;
                        return false;
                    }
                    this.fc[this.place_no - 2].stop_over_chrg = value;
                    this.stop_over_tmp += value;
                    this.add_stop_over_chrg = this.stop_over_tmp;
                }
                this.stop_over_sum += value;
                break;
            }
            case 301: {
                if (this.place_no < 2) {
                    this.FC_RESULT |= 0x400;
                    return false;
                }
                this.fc[this.place_no - 2].security_chrg = this.getNumber(this.yylex.yytext());
                this.fc[this.place_no - 2].security_index = 81;
                this.FC_RESULT |= 8;
                break;
            }
            case 310: {
                if (this.FC_RESULT == 0) {
                    this.FC_RESULT |= 0x20000;
                }
            }
            case 312: 
            case 315: {
                if (this.FC_RESULT == 0) {
                    this.FC_RESULT |= 0x40000;
                }
            }
            case 317: {
                if (this.FC_RESULT == 0) {
                    this.FC_RESULT |= 0x80000;
                }
            }
            case 322: 
            case 323: {
                if (this.FC_RESULT == 0) {
                    this.FC_RESULT |= 1 << (this.lex == 322 ? 20 : 21);
                }
                if (this.place_no < 2) {
                    this.FC_RESULT |= 0x400;
                    return false;
                }
                this.plus = true;
                plus_total = 0.0;
                double value = this.getNumber(this.yylex.yytext());
                for (int i = 0; i <= this.place_no - 2; ++i) {
                    if (this.fc[i].fare_component >= 0.0) {
                        plus_total += this.fc[i].fare_component;
                    }
                    this.fc[i].fare_component = -1.0;
                    if (this.fc[i].side_trip_plus >= 0.0) {
                        plus_total += this.fc[i].side_trip_plus;
                    }
                    this.fc[i].side_trip_plus = -1.0;
                    if (this.fc[i].side_trip_index == 83) {
                        this.fc[i].side_trip_index = 0;
                    }
                    this.fc[i].fare_compo_kbn = 0;
                    this.fc[i].fare_compo_kind = 1;
                    this.fc[i].compo_end = 0;
                }
                this.fc[this.place_no - 2].fare_component = plus_total + value;
                this.fc[this.place_no - 2].compo_end = 1;
                break;
            }
            case 318: {
                this.less = this.getNumber(this.yylex.yytext());
                this.FC_RESULT |= 0x80;
                this.fc_error = true;
                break;
            }
            case 321: {
                break;
            }
            case 324: {
                this.total = this.getNumber(this.yylex.yytext());
                this.total_type = this.yylex.yytext().substring(0, 3);
                break;
            }
            case 332: {
                break;
            }
            case 331: 
            case 346: {
                if (this.place_no < 2) {
                    this.FC_RESULT |= 0x400;
                }
                this.fc[this.place_no - 2].compo_end = 1;
                this.fc_id[this.mileage] = this.place_no - 2;
                double value = 100.0;
                if (value == 0.0) {
                    value = 0.0;
                    this.FC_RESULT |= 0x2000;
                } else {
                    this.free_flag = false;
                }
                if (this.side_start == 0) {
                    for (int i = this.def_point; i < this.place_no - 1; ++i) {
                        if (this.fc[i].fare_compo_kind != 0) continue;
                        this.fc[i].fare_compo_kind = 1;
                    }
                    this.def_point = this.place_no - 1;
                    ++this.mileage;
                    this.fc[this.place_no - 2].fare_component = value;
                } else {
                    for (int i = this.side_start; i < this.place_no - 1; ++i) {
                        this.fc[i].fare_compo_kind = 3;
                        this.fc[i].side_trip_index = 83;
                    }
                    this.fc[this.place_no - 2].side_trip_plus = value;
                }
                ++this.it_cnt;
                break;
            }
            case 347: {
                this.total = (double)this.it_cnt * 100.0;
                this.total_type = this.yylex.yytext().substring(0, 3);
                this.it_flg = true;
                break;
            }
            case 340: {
                if (this.hpn_roe_end) {
                    this.FC_RESULT |= 0x2000000;
                    this.fc_error = true;
                    System.err.println("hpn_roe_end = [" + this.hpn_roe_end + "], fc_error = [" + this.fc_error + "], return false");
                    return false;
                }
                if (this.place_no > 0) {
                    --this.place_no;
                } else {
                    this.mileage = 0;
                }
                if (this.it_cnt < 1 || this.it_flg) break;
                this.total_type = "NUC";
                this.total = (double)this.it_cnt * 100.0;
                break;
            }
            case 341: {
                this.hpn_roe_end = true;
                if (this.place_no > 0) {
                    --this.place_no;
                } else {
                    this.mileage = 0;
                }
                this.roe_rate = this.getNumber(this.yylex.yytext());
                if (this.it_cnt < 1 || this.it_flg) break;
                this.total_type = "NUC";
                this.total = (double)this.it_cnt * 100.0;
                break;
            }
            case 342: {
                this.roe_rate = this.getNumber(this.yylex.yytext());
                if (this.it_cnt < 1 || this.it_flg) break;
                this.total_type = "NUC";
                this.total = (double)this.it_cnt * 100.0;
                break;
            }
            case 343: {
                break;
            }
            case 344: {
                if (this.tax_no < 32) {
                    this.tx[this.tax_no].tax = this.getNumber(this.yylex.yytext());
                    this.tx[this.tax_no].tax_kind = this.right(this.yylex.yytext(), 2);
                }
                ++this.tax_no;
                if (this.tax_no > 32) {
                    this.FC_RESULT |= 0x400000;
                    this.fc_error = true;
                }
                this.FC_RESULT |= 0x800000;
                break;
            }
            case 345: {
                break;
            }
            case 40: 
            case 60: {
                this.side_start = this.place_no - 1;
                this.FC_RESULT |= 0x1000000;
                break;
            }
            case 41: 
            case 62: {
                this.side_start = 0;
                break;
            }
            case 0: {
                break;
            }
            default: {
                this.FC_RESULT = this.yylex.yytext().equals("C") ? (this.FC_RESULT |= 0) : (this.yylex.yytext().equals(" ") ? (this.FC_RESULT |= 0x1000) : (this.FC_RESULT |= 0x400));
                return false;
            }
        }
        return true;
    }

    double getNumber(String str) {
        int postIndex;
        int index = str.length() - 1;
        char c = str.charAt(index);
        while (index > 0 && !Character.isDigit(c) && c != '-' && c != '+') {
            c = str.charAt(--index);
        }
        int n = postIndex = Character.isDigit(c) ? index + 1 : index;
        while (index > 0 && (Character.isDigit(c) || c == '.')) {
            c = str.charAt(--index);
        }
        if (!Character.isDigit(c) && c != '-') {
            ++index;
        }
        return Double.parseDouble(str.substring(index, postIndex));
    }

    String right(String src, int len) {
        return src.length() > len ? src.substring(src.length() - len) : src;
    }

    boolean analyzeFromTo(boolean flag, int[] fromId, int[] toId, int[] nextId, String[] fromPlaceRet, String[] toPlaceRet) {
        int index = 1;
        while (!Character.isLowerCase(this.yylex.yytext().charAt(index)) && !Character.isUpperCase(this.yylex.yytext().charAt(index))) {
            ++index;
        }
        fromPlaceRet[0] = this.yylex.yytext().substring(index, index + 3);
        index += 3;
        while (!Character.isLowerCase(this.yylex.yytext().charAt(index)) && !Character.isUpperCase(this.yylex.yytext().charAt(index))) {
            ++index;
        }
        toPlaceRet[0] = this.yylex.yytext().substring(index, index + 3);
        int min = -1;
        int max = -1;
        if (flag) {
            if (nextId[0] >= 0) {
                min = nextId[0];
                if (min > this.place_no - 2) {
                    return false;
                }
            } else {
                min = 0;
            }
            if (min > this.place_no - 2) {
                min = this.place_no - 2;
            }
            while (min <= this.place_no - 2) {
                for (max = min; max <= this.place_no - 2 && this.fc[max].fare_component < 0.0 && this.fc[max].side_trip_plus < 0.0; ++max) {
                }
                if (max > this.place_no - 2) {
                    max = this.place_no - 2;
                }
                if (this.doAnalyzeFromTo(min, max, fromPlaceRet[0], toPlaceRet[0], fromId, toId)) {
                    nextId[0] = fromId[0] >= 0 && toId[0] >= 0 ? toId[0] + 1 : max + 1;
                    return true;
                }
                min = max + 1;
            }
        } else {
            nextId[0] = -1;
            toId[0] = -1;
            fromId[0] = -1;
            return this.doAnalyzeFromTo(0, this.place_no - 2, fromPlaceRet[0], toPlaceRet[0], fromId, toId);
        }
        return false;
    }

    boolean doAnalyzeFromTo(int min, int max, String fromPlace, String toPlace, int[] fromId, int[] toId) {
        int i;
        fromId[0] = -1;
        toId[0] = -1;
        for (i = min; i <= max && !this.fc[i].dep_code.equals("") && !this.fc[i].dep_code.equals(fromPlace); ++i) {
        }
        if (i <= max && !this.fc[i].dep_code.equals("")) {
            fromId[0] = i;
        }
        while (i <= max && !this.fc[i].dest_code.equals("") && !this.fc[i].dest_code.equals(toPlace)) {
            ++i;
        }
        if (i <= max && !this.fc[i].dest_code.equals("")) {
            toId[0] = i;
        }
        if (fromId[0] >= 0 && toId[0] >= 0) {
            return true;
        }
        for (i = min; i <= max && !this.fc[i].dep_code.equals("") && !this.fc[i].dep_code.equals(toPlace); ++i) {
        }
        if (i <= max && !this.fc[i].dep_code.equals("")) {
            fromId[0] = i;
        }
        while (i <= max && !this.fc[i].dest_code.equals("") && !this.fc[i].dest_code.equals(fromPlace)) {
            ++i;
        }
        if (i <= max && !this.fc[i].dest_code.equals("")) {
            toId[0] = i;
        }
        return fromId[0] >= 0 && toId[0] >= 0;
    }

    void resetFareComponent() {
        for (int i = 0; i <= this.place_no - 2; ++i) {
            this.fc[this.place_no - 2].fare_component = this.fc[this.place_no - 2].fare_component + (this.fc[i].fare_component > 0.0 ? this.fc[i].fare_component : 0.0);
            this.fc[i].fare_component = -1.0;
            this.fc[i].fare_compo_kbn = 1;
        }
        this.fc[this.place_no - 2].fare_compo_kbn = 1;
    }

    boolean totalSumCheck() {
        double fare_total = 0.0;
        for (int i = 0; i < this.place_no; ++i) {
            fare_total += this.fc[i].fare_component > 0.0 ? this.fc[i].fare_component : 0.0;
            fare_total += this.fc[i].class_differ_plus;
            fare_total += this.fc[i].security_chrg;
            fare_total += this.fc[i].side_trip_plus > 0.0 ? this.fc[i].side_trip_plus : 0.0;
            fare_total += this.fc[i].exst_plus;
        }
        return Math.abs((fare_total += this.add_stop_over_chrg) - this.total) < 0.01;
    }

    boolean sectorCheck() {
        int i;
        for (int i2 = 0; i2 <= this.diff_index; ++i2) {
            this.diffApplicable[i2] = false;
        }
        int compoBegin = 0;
        int compoBeginSector = 0;
        int j = 0;
        for (i = 0; i < this.place_no; ++i) {
            if (j >= this.audit.getSectors().length) {
                return false;
            }
            ProrateSector sector = this.audit.getSectors()[j];
            if ((this.fc[i].carrier.equals("XX") || this.fc[i].carrier.equals("//")) && !sector.getCarrier().equals("XX") && !sector.getCarrier().equals("//")) continue;
            if (!this.fc[i].carrier.equals("XX") && !this.fc[i].carrier.equals("//") && (sector.getCarrier().equals("XX") || sector.getCarrier().equals("//"))) {
                ++j;
                --i;
                continue;
            }
            if (!this.audit.isIgnoreFareCalcCarrier() && !sector.getCarrier().equals(this.fc[i].carrier) || !sector.getDepCode().equals(this.fc[i].dep_code) && !sector.getDepAirport().equals(this.fc[i].dep_code) || !sector.getDestCode().equals(this.fc[i].dest_code) && !sector.getDestAirport().equals(this.fc[i].dest_code)) {
                return false;
            }
            if (this.fc[i].fare_component >= 0.0 || this.fc[i].side_trip_plus >= 0.0) {
                if (!this.classDiffCheck(compoBegin, compoBeginSector, i, j)) {
                    this.FC_RESULT |= 0x20;
                    this.fc_error = true;
                    return false;
                }
                compoBegin = i + 1;
                compoBeginSector = j + 1;
            }
            ++j;
        }
        if (j != this.audit.getSectors().length) {
            return false;
        }
        for (i = 1; i <= this.diff_index; ++i) {
            if (this.diffApplicable[i]) continue;
            this.FC_RESULT |= 0x20;
            this.fc_error = true;
            return false;
        }
        return true;
    }

    boolean plusCheck() {
        int commonClass = 0;
        int j = 0;
        for (int i = 0; i < this.place_no; ++i) {
            if (j >= this.audit.getSectors().length) {
                return false;
            }
            ProrateSector sector = this.audit.getSectors()[j];
            if ((this.fc[i].carrier.equals("XX") || this.fc[i].carrier.equals("//")) && !sector.getCarrier().equals("XX") && !sector.getCarrier().equals("//")) continue;
            if (!this.fc[i].carrier.equals("XX") && !this.fc[i].carrier.equals("//") && (sector.getCarrier().equals("XX") || sector.getCarrier().equals("//"))) {
                ++j;
                --i;
                continue;
            }
            int cls = sector.getFareBasis().charAt(0);
            if (ProrateRuleObject.Y_classes.indexOf(cls) >= 0) {
                cls = 89;
            } else if (ProrateRuleObject.C_classes.indexOf(cls) >= 0) {
                cls = 67;
            } else if (ProrateRuleObject.F_classes.indexOf(cls) >= 0) {
                cls = 70;
            }
            if (commonClass == 0 && this.fc[i].diff_index == 0) {
                commonClass = cls;
            } else if (commonClass != cls && this.fc[i].diff_index == 0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    boolean sectorCreate() {
        int numSectors = 0;
        for (int i = 0; i < this.place_no; ++i) {
            if (this.fc[i].carrier.equals("XX") || this.fc[i].carrier.equals("//")) continue;
            ++numSectors;
        }
        Vector<ProrateSector> sectors = null;
        if (numSectors > 0) {
            sectors = new Vector<ProrateSector>();
        }
        for (int i = 0; i < this.place_no; ++i) {
            if (this.fc[i].carrier.equals("XX") || this.fc[i].carrier.equals("//")) continue;
            ProrateSector sector = new ProrateSector();
            sector.setCarrier(this.fc[i].carrier);
            sector.setDepCode(this.fc[i].dep_code);
            sector.setDestCode(this.fc[i].dest_code);
            sectors.add(sector);
        }
        if (sectors == null) {
            this.audit.setSectors(null);
            return true;
        }
        ProrateSector[] sectorsArray = new ProrateSector[sectors.size()];
        for (int j = 0; j < sectors.size(); ++j) {
            sectorsArray[j] = (ProrateSector)sectors.get(j);
        }
        this.audit.setSectors(sectorsArray);
        return true;
    }

    boolean classDiffCheck(int min, int minSector, int max, int maxSector) {
        int i;
        boolean[] found_indexes = new boolean[this.diff_index + 1];
        boolean[] apply_indexes = new boolean[this.diff_index + 1];
        for (int i2 = 0; i2 <= this.diff_index; ++i2) {
            found_indexes[i2] = false;
            apply_indexes[i2] = true;
        }
        boolean found_index = false;
        boolean found_value = false;
        for (int i3 = min; i3 <= max; ++i3) {
            if (this.fc[i3].diff_index > 0) {
                found_index = true;
                found_indexes[this.fc[i3].diff_index] = true;
            }
            if (!(this.fc[i3].class_differ_plus > 0.0)) continue;
            found_value = true;
        }
        if (!found_index && !found_value) {
            return true;
        }
        if (!found_index || !found_value) {
            return false;
        }
        char lowest = this.getLowestClass();
        if (lowest == 'F') {
            return false;
        }
        int j = minSector;
        for (i = min; i <= max && j <= maxSector; ++i) {
            ProrateSector sector = this.audit.getSectors()[j];
            if ((this.fc[i].carrier.equals("XX") || this.fc[i].carrier.equals("//")) && !sector.getCarrier().equals("XX") && !sector.getCarrier().equals("//")) continue;
            if (!this.fc[i].carrier.equals("XX") && !this.fc[i].carrier.equals("//") && (sector.getCarrier().equals("XX") || sector.getCarrier().equals("//"))) {
                ++j;
                --i;
                continue;
            }
            if (this.fc[i].diff_index > 0 && !this.isUpperClass(j, lowest)) {
                apply_indexes[this.fc[i].diff_index] = false;
            }
            ++j;
        }
        j = minSector;
        for (i = min; i <= max && j <= maxSector; ++i) {
            if (this.fc[i].diff_index <= 0 || apply_indexes[this.fc[i].diff_index]) continue;
            this.fc[i].diff_index = 0;
            this.fc[i].class_differ_plus = 0.0;
        }
        for (i = 0; i <= this.diff_index; ++i) {
            if (found_indexes[i] && apply_indexes[i] && this.diffApplicable[i]) {
                if (this.dftbl[i].count > 2) {
                    return false;
                }
                if (this.dftbl[i].count == 2) {
                    this.dftbl[i].count = 3;
                } else {
                    return false;
                }
            }
            if (!found_indexes[i] || !apply_indexes[i]) continue;
            this.diffApplicable[i] = true;
        }
        return true;
    }

    boolean skipFareBasis(int pos, int[] fareCalPtr, String[] fareCal) {
        return this.skipFareBasis(pos, fareCalPtr, fareCal, true);
    }

    boolean skipFareBasis(int pos, int[] fareCalPtr, String[] fareCal, boolean exactPos) {
        int[] stop_pos = new int[]{-1};
        if (exactPos) {
            if (!this.doSkipFareBasis(pos, fareCal)) {
                return false;
            }
            fareCalPtr[0] = 0;
            if (!this.doAnalyze(fareCal[0], fareCalPtr, stop_lex, stop_pos) && stop_pos[0] < 0) {
                return false;
            }
        }
        fareCalPtr[0] = 0;
        while (!this.doAnalyze(fareCal[0], fareCalPtr, stop_lex, stop_pos)) {
            if (stop_pos[0] < 0) {
                return false;
            }
            this.doSkipFareBasis(fareCalPtr[0], fareCal);
            fareCalPtr[0] = 0;
        }
        return true;
    }

    boolean doSkipFareBasis(int pos, String[] str) {
        while (pos < str[0].length() && (str[0].charAt(pos) == ' ' || str[0].charAt(pos) == '\t')) {
            ++pos;
        }
        Vector<String> basisStrList = new Vector<String>();
        for (int i = 0; i < this.audit.getSectors().length; ++i) {
            ProrateSector sector = this.audit.getSectors()[i];
            basisStrList.add(sector.getFareBasis());
            int index = -1;
            index = sector.getFareBasis().indexOf(32);
            if (index >= 0) {
                basisStrList.add(sector.getFareBasis().substring(0, index));
            }
            index = -1;
            index = sector.getFareBasis().indexOf(47);
            if (index >= 0) {
                basisStrList.add(sector.getFareBasis().substring(0, index));
            }
            index = -1;
            int index2 = -1;
            index = sector.getFareBasis().lastIndexOf(47);
            if (index >= 0) {
                index2 = sector.getFareBasis().lastIndexOf(32);
                if (index2 >= 0 && index2 > index) {
                    index = index2;
                }
                basisStrList.add(sector.getFareBasis().substring(index + 1));
            }
            basisStrList.add(sector.getFareBasisFullStr());
            index = -1;
            index = sector.getFareBasisFullStr().indexOf(32);
            if (index >= 0) {
                basisStrList.add(sector.getFareBasisFullStr().substring(0, index));
            }
            index = -1;
            index = sector.getFareBasisFullStr().indexOf(47);
            if (index >= 0) {
                basisStrList.add(sector.getFareBasisFullStr().substring(0, index));
            }
            index = -1;
            index2 = -1;
            index = sector.getFareBasisFullStr().lastIndexOf(47);
            if (index < 0) continue;
            index2 = sector.getFareBasisFullStr().lastIndexOf(32);
            if (index2 >= 0 && index2 > index) {
                index = index2;
            }
            basisStrList.add(sector.getFareBasisFullStr().substring(index + 1));
        }
        Object[] basisStrArray = basisStrList.toArray();
        Arrays.sort(basisStrArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                String str1 = (String)o1;
                String str2 = (String)o2;
                if (str1.length() > str2.length()) {
                    return -1;
                }
                if (str1.length() < str2.length()) {
                    return 1;
                }
                return 0;
            }
        });
        for (int i = 0; i < basisStrArray.length; ++i) {
            String basisStr = (String)basisStrArray[i];
            if (str[0].substring(pos).length() < basisStr.length()) {
                return false;
            }
            if (!basisStr.equals(str[0].substring(pos, pos + basisStr.length()))) continue;
            StringBuffer strbuf = new StringBuffer(str[0]);
            for (int k = 0; k < basisStr.length(); ++k) {
                strbuf.setCharAt(pos + k, ' ');
            }
            str[0] = strbuf.toString();
            return true;
        }
        return false;
    }

    boolean preProcess(String[] fareCal) {
        int fareCalPtr;
        if ((Character.isLowerCase(fareCal[0].charAt(0)) || Character.isUpperCase(fareCal[0].charAt(0))) && Character.isDigit(fareCal[0].charAt(1))) {
            fareCal[0] = fareCal[0].substring(1);
            return true;
        }
        if (!(!fareCal[0].substring(0, 2).equals("IT") || fareCal[0].substring(0, 3).equals("ITM") || fareCal[0].substring(0, 3).equals("ITH") || fareCal[0].substring(0, 3).equals("ITK") || fareCal[0].substring(0, 3).equals("ITN") || fareCal[0].substring(0, 3).equals("ITO"))) {
            return false;
        }
        if (fareCal[0].substring(0, 2).equals("FP") && (fareCalPtr = fareCal[0].indexOf("FC")) >= 0) {
            fareCal[0] = fareCal[0].substring(fareCalPtr + 2);
            return true;
        }
        return true;
    }

    char getLowestClass() {
        int lowest = 70;
        int j = 0;
        for (int i = 0; i < this.place_no; ++i) {
            char cls;
            if (j >= this.audit.getSectors().length) {
                return (char)lowest;
            }
            ProrateSector sector = this.audit.getSectors()[j];
            if ((this.fc[i].carrier.equals("XX") || this.fc[i].carrier.equals("//")) && !sector.getCarrier().equals("XX") && !sector.getCarrier().equals("//")) continue;
            if (lowest == 70) {
                cls = sector.getFareBasis().charAt(0);
                if (ProrateRuleObject.Y_classes.indexOf(cls) >= 0) {
                    lowest = 89;
                    break;
                }
                if (ProrateRuleObject.C_classes.indexOf(cls) >= 0) {
                    lowest = 67;
                }
            } else if (lowest == 67 && ProrateRuleObject.Y_classes.indexOf(cls = sector.getFareBasis().charAt(0)) >= 0) {
                lowest = 89;
                break;
            }
            ++j;
        }
        return (char)lowest;
    }

    boolean isUpperClass(int idx, char lowest) {
        char cls = this.audit.getSectors()[idx].getFareBasis().charAt(0);
        if (lowest == 'F') {
            return false;
        }
        if (lowest == 'C') {
            return ProrateRuleObject.F_classes.indexOf(cls) >= 0;
        }
        if (ProrateRuleObject.F_classes.indexOf(cls) >= 0) {
            return true;
        }
        return ProrateRuleObject.C_classes.indexOf(cls) >= 0;
    }

    String makeFcResultStr(int FC_RESULT) {
        StringBuffer resultStr = new StringBuffer();
        for (int i = 0; i < 26; ++i) {
            int bit = 1 << i;
            if ((FC_RESULT & bit) == 0) continue;
            if (resultStr.length() > 0) {
                resultStr.append(",");
            }
            String mesg = "";
            switch (i) {
                case 0: {
                    mesg = "AllSectorsAreByTicketingCarrier";
                    break;
                }
                case 1: {
                    mesg = "SectorCheckFailed";
                    break;
                }
                case 2: {
                    mesg = "PlusCheckFailed";
                    break;
                }
                case 3: {
                    mesg = "SecurityChargeAcounted";
                    break;
                }
                case 4: {
                    mesg = "ClassDifferentialAcounted";
                    break;
                }
                case 5: {
                    mesg = "ClassDifferentialNotProcessed";
                    break;
                }
                case 6: {
                    mesg = "NoCurrencyInTotal";
                    break;
                }
                case 7: {
                    mesg = "LessAccounted";
                    break;
                }
                case 8: {
                    mesg = "ThereIsSurfaceSector";
                    break;
                }
                case 9: {
                    mesg = "SurfaceSectorOnTheEnd";
                    break;
                }
                case 10: {
                    mesg = "ParseError";
                    break;
                }
                case 11: {
                    mesg = "ParseErrorInINCTOURWithout2Sectors";
                    break;
                }
                case 12: {
                    mesg = "ParseErrorInINCTOURWithSpace";
                    break;
                }
                case 13: {
                    mesg = "ZeroValueForMileageOrRoute";
                    break;
                }
                case 14: {
                    mesg = "ThereIsLowestCombi";
                    break;
                }
                case 15: {
                    mesg = "NoEND";
                    break;
                }
                case 16: {
                    mesg = "TotalSumCheckFailed";
                    break;
                }
                case 17: {
                    mesg = "ThereIsPlusNormal";
                    break;
                }
                case 18: {
                    mesg = "ThereIsPlusSector";
                    break;
                }
                case 19: {
                    mesg = "ThereIsPlusHalfRT";
                    break;
                }
                case 20: {
                    mesg = "ThereIsPlusYSect";
                    break;
                }
                case 21: {
                    mesg = "ThereIsPlusLowCombi";
                    break;
                }
                case 22: {
                    mesg = "ThereAreTooManyTaxes";
                    break;
                }
                case 23: {
                    mesg = "ThereIsFTax";
                    break;
                }
                case 24: {
                    mesg = "ThereIsSideTrip";
                    break;
                }
                case 25: {
                    mesg = "ROEDescriptionBeforeEND";
                }
            }
            resultStr.append(mesg);
        }
        return resultStr.toString();
    }

    void debugFareCalInfo(String fareCal, int fareCalPtr) {
        System.err.println("fareCal = [" + fareCal + "]");
        System.err.println("fareCalPtr = [" + fareCalPtr + "]");
        System.err.println("FC_RESULT = [" + this.makeFcResultStr(this.FC_RESULT) + "]");
        System.err.println("oldlex = " + this.oldlex[2] + "," + this.oldlex[1] + "," + this.oldlex[0] + " oldpos = " + this.oldpos[2] + "," + this.oldpos[1] + "," + this.oldpos[0] + " yyresult = [" + this.yylex.yytext() + "]");
        System.err.println("place_no = " + this.place_no);
        for (int i = 0; i < this.place_no; ++i) {
            System.err.print("" + (this.fc[i].stop_over != '\u0000' ? Character.toString(this.fc[i].stop_over) : " ") + " ");
            System.err.print("[" + this.fc[i].dep_code + "] - [" + this.fc[i].dest_code + "] [" + this.fc[i].carrier + "] ");
            System.err.print("" + this.fc[i].fare_compo_kbn + " " + this.fc[i].fare_compo_kind + " " + this.fc[i].compo_end + " ");
            System.err.print("" + (this.fc[i].security_index != 0 ? Integer.toString(this.fc[i].security_index) : " ") + " ");
            System.err.print("" + (this.fc[i].side_trip_index != 0 ? Integer.toString(this.fc[i].side_trip_index) : " ") + " ");
            if (this.fc[i].diff_index > 0) {
                System.err.print("D(" + this.fc[i].diff_index + ") ");
            } else {
                System.err.print("     ");
            }
            System.err.println("" + this.fc[i].fare_component + " " + this.fc[i].class_differ_plus + " " + this.fc[i].security_chrg + " " + this.fc[i].stop_over_chrg + " " + this.fc[i].side_trip_plus + " " + this.fc[i].exst_plus + " " + this.fc[i].via);
        }
        System.err.println("");
        System.err.println("free_flag = " + this.free_flag);
        System.err.print("mileage = " + this.mileage);
        for (int j = 0; j < this.mileage; ++j) {
            System.err.print("" + this.fc_id[j] + " ");
        }
        System.err.println("");
        System.err.println("");
        System.err.println("roe_rate = " + this.roe_rate);
        System.err.println("total = " + this.total_type + " " + this.total);
        System.err.println("stop_over_sum = " + this.stop_over_sum);
        System.err.println("stop_over_tmp = " + this.stop_over_tmp);
        System.err.println("add_stop_over_chrg = " + this.add_stop_over_chrg);
        System.err.println("less = " + this.less);
        System.err.print("tax_no = " + this.tax_no + " ");
        for (int k = 0; k < this.tax_no; ++k) {
            System.err.println("" + this.tx[k].tax + " " + this.tx[k].tax_kind + " ");
        }
        System.err.println("");
    }

    public ProrateAuditImpl getAuditImpl() {
        return this.auditImpl;
    }

    public void setAuditImpl(ProrateAuditImpl auditImpl) {
        this.auditImpl = auditImpl;
    }

    class _diff_table {
        String from = "";
        String to = "";
        double value = 0.0;
        int count = 0;

        _diff_table() {
        }
    }

    class _tax_value {
        double tax = 0.0;
        String tax_kind = "";

        _tax_value() {
        }
    }

    class _fare_cal {
        char stop_over;
        String dep_code = "";
        String dest_code = "";
        String carrier = "";
        int fare_compo_kbn;
        int fare_compo_kind;
        int compo_end;
        double fare_component;
        double class_differ_plus;
        double security_chrg;
        int security_index;
        double stop_over_chrg;
        double side_trip_plus;
        int side_trip_index;
        int diff_index;
        double exst_plus;
        String via = "";

        _fare_cal() {
        }
    }
}

