/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v2;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.core.Field;
import org.postgresql.core.Notification;
import org.postgresql.core.PGStream;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Query;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandler;
import org.postgresql.core.v2.FastpathParameterList;
import org.postgresql.core.v2.ProtocolConnectionImpl;
import org.postgresql.core.v2.SimpleParameterList;
import org.postgresql.core.v2.V2Query;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class QueryExecutorImpl
implements QueryExecutor {
    private final ProtocolConnectionImpl protoConnection;
    private final PGStream pgStream;

    public QueryExecutorImpl(ProtocolConnectionImpl protoConnection, PGStream pgStream) {
        this.protoConnection = protoConnection;
        this.pgStream = pgStream;
    }

    public Query createSimpleQuery(String sql) {
        return new V2Query(sql, false);
    }

    public Query createParameterizedQuery(String sql) {
        return new V2Query(sql, true);
    }

    public ParameterList createFastpathParameters(int count) {
        return new FastpathParameterList(count);
    }

    public synchronized byte[] fastpathCall(int fnid, ParameterList parameters, boolean suppressBegin) throws SQLException {
        if (this.protoConnection.getTransactionState() == 0 && !suppressBegin) {
            if (Driver.logDebug) {
                Driver.debug("Issuing BEGIN before fastpath call.");
            }
            ResultHandler handler = new ResultHandler(){
                private boolean sawBegin = false;
                private SQLException sqle = null;

                public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
                }

                public void handleCommandStatus(String status, int updateCount, long insertOID) {
                    if (!this.sawBegin) {
                        if (!status.equals("BEGIN")) {
                            this.handleError(new PSQLException(GT.tr("Expected command status BEGIN, got {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                        }
                        this.sawBegin = true;
                    } else {
                        this.handleError(new PSQLException(GT.tr("Unexpected command status: {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                    }
                }

                public void handleWarning(SQLWarning warning) {
                    this.handleError(warning);
                }

                public void handleError(SQLException error) {
                    if (this.sqle == null) {
                        this.sqle = error;
                    } else {
                        this.sqle.setNextException(error);
                    }
                }

                public void handleCompletion() throws SQLException {
                    if (this.sqle != null) {
                        throw this.sqle;
                    }
                }
            };
            try {
                V2Query query = (V2Query)this.createSimpleQuery("");
                SimpleParameterList params = (SimpleParameterList)query.createParameterList();
                this.sendQuery(query, params, "BEGIN");
                this.processResults(query, handler, 0);
            }
            catch (IOException ioe) {
                throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
            }
        }
        try {
            this.sendFastpathCall(fnid, (FastpathParameterList)parameters);
            return this.receiveFastpathResult();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    private void sendFastpathCall(int fnid, FastpathParameterList params) throws IOException {
        int count = params.getParameterCount();
        if (Driver.logDebug) {
            Driver.debug(" FE=> FastpathCall(fnid=" + fnid + ",paramCount=" + count + ")");
        }
        this.pgStream.SendChar(70);
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger4(fnid);
        this.pgStream.SendInteger4(count);
        int i = 1;
        while (i <= count) {
            params.writeV2FastpathValue(i, this.pgStream);
            ++i;
        }
        this.pgStream.flush();
    }

    /*
     * Exception decompiling
     */
    public synchronized void processNotifies() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] receiveFastpathResult() throws IOException, SQLException {
        SQLException error = null;
        boolean endQuery = false;
        byte[] result = null;
        block7: while (!endQuery) {
            int c = this.pgStream.ReceiveChar();
            switch (c) {
                case 65: {
                    this.receiveAsyncNotify();
                    break;
                }
                case 69: {
                    SQLException newError = this.receiveErrorMessage();
                    if (error == null) {
                        error = newError;
                        break;
                    }
                    error.setNextException(newError);
                    break;
                }
                case 78: {
                    this.protoConnection.addWarning(this.receiveNotification());
                    break;
                }
                case 86: {
                    c = this.pgStream.ReceiveChar();
                    if (c == 71) {
                        if (Driver.logDebug) {
                            Driver.debug(" <=BE FastpathResult");
                        }
                        int len = this.pgStream.ReceiveIntegerR(4);
                        result = this.pgStream.Receive(len);
                        c = this.pgStream.ReceiveChar();
                    } else if (Driver.logDebug) {
                        Driver.debug(" <=BE FastpathVoidResult");
                    }
                    if (c == 48) continue block7;
                    throw new PSQLException(GT.tr("Unknown Response Type {0}.", new Character((char)c)), PSQLState.CONNECTION_FAILURE);
                }
                case 90: {
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE ReadyForQuery");
                    }
                    endQuery = true;
                    break;
                }
                default: {
                    throw new PSQLException(GT.tr("Unknown Response Type {0}.", new Character((char)c)), PSQLState.CONNECTION_FAILURE);
                }
            }
        }
        if (error != null) {
            throw error;
        }
        return result;
    }

    public synchronized void execute(Query query, ParameterList parameters, ResultHandler handler, int maxRows, int fetchSize, int flags) throws SQLException {
        this.execute((V2Query)query, (SimpleParameterList)parameters, handler, maxRows, flags);
    }

    public synchronized void execute(Query[] queries, ParameterList[] parameters, ResultHandler handler, int maxRows, int fetchSize, int flags) throws SQLException {
        final ResultHandler delegateHandler = handler;
        handler = new ResultHandler(){

            public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
                delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
            }

            public void handleCommandStatus(String status, int updateCount, long insertOID) {
                delegateHandler.handleCommandStatus(status, updateCount, insertOID);
            }

            public void handleWarning(SQLWarning warning) {
                delegateHandler.handleWarning(warning);
            }

            public void handleError(SQLException error) {
                delegateHandler.handleError(error);
            }

            public void handleCompletion() throws SQLException {
            }
        };
        int i = 0;
        while (i < queries.length) {
            this.execute((V2Query)queries[i], (SimpleParameterList)parameters[i], handler, maxRows, flags);
            ++i;
        }
        delegateHandler.handleCompletion();
    }

    public void fetch(ResultCursor cursor, ResultHandler handler, int rows) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "fetch(ResultCursor,ResultHandler,int)");
    }

    private void execute(V2Query query, SimpleParameterList parameters, ResultHandler handler, int maxRows, int flags) throws SQLException {
        if ((flags & 0x20) != 0) {
            return;
        }
        if (parameters == null) {
            parameters = (SimpleParameterList)query.createParameterList();
        }
        parameters.checkAllParametersSet();
        String queryPrefix = null;
        if (this.protoConnection.getTransactionState() == 0 && (flags & 0x10) == 0) {
            queryPrefix = "BEGIN;";
            final ResultHandler delegateHandler = handler;
            handler = new ResultHandler(){
                private boolean sawBegin = false;

                public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
                    if (this.sawBegin) {
                        delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
                    }
                }

                public void handleCommandStatus(String status, int updateCount, long insertOID) {
                    if (!this.sawBegin) {
                        if (!status.equals("BEGIN")) {
                            this.handleError(new PSQLException(GT.tr("Expected command status BEGIN, got {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                        }
                        this.sawBegin = true;
                    } else {
                        delegateHandler.handleCommandStatus(status, updateCount, insertOID);
                    }
                }

                public void handleWarning(SQLWarning warning) {
                    delegateHandler.handleWarning(warning);
                }

                public void handleError(SQLException error) {
                    delegateHandler.handleError(error);
                }

                public void handleCompletion() throws SQLException {
                    delegateHandler.handleCompletion();
                }
            };
        }
        try {
            this.sendQuery(query, parameters, queryPrefix);
            this.processResults(query, handler, maxRows);
        }
        catch (IOException e) {
            this.protoConnection.close();
            handler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)e));
        }
        handler.handleCompletion();
    }

    protected void sendQuery(V2Query query, SimpleParameterList params, String queryPrefix) throws IOException {
        if (Driver.logDebug) {
            Driver.debug(" FE=> Query(\"" + (queryPrefix == null ? "" : queryPrefix) + query.toString(params) + "\")");
        }
        this.pgStream.SendChar(81);
        Writer encodingWriter = this.pgStream.getEncodingWriter();
        if (queryPrefix != null) {
            encodingWriter.write(queryPrefix);
        }
        String[] fragments = query.getFragments();
        int i = 0;
        while (i < fragments.length) {
            encodingWriter.write(fragments[i]);
            if (i < params.getParameterCount()) {
                params.writeV2Value(i + 1, encodingWriter);
            }
            ++i;
        }
        encodingWriter.write(0);
        this.pgStream.flush();
    }

    /*
     * Unable to fully structure code
     */
    protected void processResults(Query originalQuery, ResultHandler handler, int maxRows) throws IOException {
        fields = null;
        tuples = null;
        endQuery = false;
        block16: while (!endQuery) {
            c = this.pgStream.ReceiveChar();
            switch (c) {
                case 65: {
                    this.receiveAsyncNotify();
                    break;
                }
                case 66: {
                    if (fields == null) {
                        throw new IOException("Data transfer before field metadata");
                    }
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE BinaryRow");
                    }
                    tuple = null;
                    try {
                        tuple = this.pgStream.ReceiveTupleV2(fields.length, true);
                    }
                    catch (OutOfMemoryError oome) {
                        if (maxRows != 0 && tuples.size() >= maxRows) ** GOTO lbl22
                        handler.handleError(new PSQLException(GT.tr("Ran out of memory retrieving query results."), PSQLState.OUT_OF_MEMORY, (Throwable)oome));
                    }
lbl22:
                    // 3 sources

                    i = 0;
                    while (i < fields.length) {
                        fields[i].setFormat(1);
                        ++i;
                    }
                    if (maxRows != 0 && tuples.size() >= maxRows) continue block16;
                    tuples.addElement(tuple);
                    break;
                }
                case 67: {
                    status = this.pgStream.ReceiveString();
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE CommandStatus(" + status + ")");
                    }
                    if (fields != null) {
                        handler.handleResultRows(originalQuery, fields, tuples, null);
                        fields = null;
                        break;
                    }
                    this.interpretCommandStatus(status, handler);
                    break;
                }
                case 68: {
                    if (fields == null) {
                        throw new IOException("Data transfer before field metadata");
                    }
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE DataRow");
                    }
                    tuple = null;
                    try {
                        tuple = this.pgStream.ReceiveTupleV2(fields.length, false);
                    }
                    catch (OutOfMemoryError oome) {
                        if (maxRows != 0 && tuples.size() >= maxRows) ** GOTO lbl52
                        handler.handleError(new PSQLException(GT.tr("Ran out of memory retrieving query results."), PSQLState.OUT_OF_MEMORY, (Throwable)oome));
                    }
lbl52:
                    // 3 sources

                    if (maxRows != 0 && tuples.size() >= maxRows) continue block16;
                    tuples.addElement(tuple);
                    break;
                }
                case 69: {
                    handler.handleError(this.receiveErrorMessage());
                    break;
                }
                case 73: {
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE EmptyQuery");
                    }
                    if ((c = this.pgStream.ReceiveChar()) == 0) continue block16;
                    throw new IOException("Expected \\0 after EmptyQuery, got: " + c);
                }
                case 78: {
                    handler.handleWarning(this.receiveNotification());
                    break;
                }
                case 80: {
                    portalName = this.pgStream.ReceiveString();
                    if (!Driver.logDebug) continue block16;
                    Driver.debug(" <=BE PortalName(" + portalName + ")");
                    break;
                }
                case 84: {
                    fields = this.receiveFields();
                    tuples = new Vector<byte[][]>();
                    break;
                }
                case 90: {
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE ReadyForQuery");
                    }
                    endQuery = true;
                    break;
                }
                default: {
                    throw new IOException("Unexpected packet type: " + c);
                }
            }
        }
    }

    private Field[] receiveFields() throws IOException {
        int size = this.pgStream.ReceiveIntegerR(2);
        Field[] fields = new Field[size];
        if (Driver.logDebug) {
            Driver.debug(" <=BE RowDescription(" + fields.length + ")");
        }
        int i = 0;
        while (i < fields.length) {
            String columnLabel = this.pgStream.ReceiveString();
            int typeOid = this.pgStream.ReceiveIntegerR(4);
            int typeLength = this.pgStream.ReceiveIntegerR(2);
            int typeModifier = this.pgStream.ReceiveIntegerR(4);
            fields[i] = new Field(columnLabel, columnLabel, typeOid, typeLength, typeModifier, 0, 0);
            ++i;
        }
        return fields;
    }

    private void receiveAsyncNotify() throws IOException {
        int pid = this.pgStream.ReceiveIntegerR(4);
        String msg = this.pgStream.ReceiveString();
        if (Driver.logDebug) {
            Driver.debug(" <=BE AsyncNotify(pid=" + pid + ",msg=" + msg + ")");
        }
        this.protoConnection.addNotification(new Notification(msg, pid));
    }

    private SQLException receiveErrorMessage() throws IOException {
        String errorMsg = this.pgStream.ReceiveString().trim();
        if (Driver.logDebug) {
            Driver.debug(" <=BE ErrorResponse(" + errorMsg + ")");
        }
        return new PSQLException(errorMsg, PSQLState.UNKNOWN_STATE);
    }

    private SQLWarning receiveNotification() throws IOException {
        String warnMsg = this.pgStream.ReceiveString();
        int severityMark = warnMsg.indexOf(":");
        warnMsg = warnMsg.substring(severityMark + 1).trim();
        if (Driver.logDebug) {
            Driver.debug(" <=BE NoticeResponse(" + warnMsg + ")");
        }
        return new SQLWarning(warnMsg);
    }

    private void interpretCommandStatus(String status, ResultHandler handler) throws IOException {
        int update_count = 0;
        long insert_oid = 0L;
        if (status.equals("BEGIN")) {
            this.protoConnection.setTransactionState(1);
        } else if (status.equals("COMMIT") || status.equals("ROLLBACK")) {
            this.protoConnection.setTransactionState(0);
        } else if (status.startsWith("INSERT") || status.startsWith("UPDATE") || status.startsWith("DELETE") || status.startsWith("MOVE")) {
            try {
                update_count = Integer.parseInt(status.substring(1 + status.lastIndexOf(32)));
                if (status.startsWith("INSERT")) {
                    insert_oid = Long.parseLong(status.substring(1 + status.indexOf(32), status.lastIndexOf(32)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                handler.handleError(new PSQLException(GT.tr("Unable to interpret the update count in command completion tag: {0}.", status), PSQLState.CONNECTION_FAILURE));
                return;
            }
        }
        handler.handleCommandStatus(status, update_count, insert_oid);
    }
}

