/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v2;

import java.util.Vector;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Query;
import org.postgresql.core.v2.SimpleParameterList;

class V2Query
implements Query {
    private static final ParameterList NO_PARAMETERS = new SimpleParameterList(0);
    private final String[] fragments;

    V2Query(String query, boolean withParameters) {
        if (!withParameters) {
            this.fragments = new String[]{query};
            return;
        }
        Vector<String> v = new Vector<String>();
        int lastParmEnd = 0;
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        int i = 0;
        while (i < query.length()) {
            char c = query.charAt(i);
            switch (c) {
                case '\\': {
                    if (!inSingleQuotes) break;
                    ++i;
                    break;
                }
                case '\'': {
                    inSingleQuotes = !inDoubleQuotes && !inSingleQuotes;
                    break;
                }
                case '\"': {
                    inDoubleQuotes = !inSingleQuotes && !inDoubleQuotes;
                    break;
                }
                case '?': {
                    if (inSingleQuotes || inDoubleQuotes) break;
                    v.addElement(query.substring(lastParmEnd, i));
                    lastParmEnd = i + 1;
                    break;
                }
            }
            ++i;
        }
        v.addElement(query.substring(lastParmEnd, query.length()));
        this.fragments = new String[v.size()];
        i = 0;
        while (i < this.fragments.length) {
            this.fragments[i] = (String)v.elementAt(i);
            ++i;
        }
    }

    public ParameterList createParameterList() {
        if (this.fragments.length == 1) {
            return NO_PARAMETERS;
        }
        return new SimpleParameterList(this.fragments.length - 1);
    }

    public String toString(ParameterList parameters) {
        StringBuffer sbuf = new StringBuffer(this.fragments[0]);
        int i = 1;
        while (i < this.fragments.length) {
            if (parameters == null) {
                sbuf.append("?");
            } else {
                sbuf.append(parameters.toString(i));
            }
            sbuf.append(this.fragments[i]);
            ++i;
        }
        return sbuf.toString();
    }

    public void close() {
    }

    String[] getFragments() {
        return this.fragments;
    }
}

