/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGmoney
extends PGobject
implements Serializable,
Cloneable {
    public double val;

    public PGmoney(double value) {
        this();
        this.val = value;
    }

    public PGmoney(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    public PGmoney() {
        this.setType("money");
    }

    public void setValue(String s) throws SQLException {
        try {
            boolean negative = s.charAt(0) == '(';
            String s1 = PGtokenizer.removePara(s).substring(1);
            int pos = s1.indexOf(44);
            while (pos != -1) {
                s1 = String.valueOf(s1.substring(0, pos)) + s1.substring(pos + 1);
                pos = s1.indexOf(44);
            }
            this.val = Double.valueOf(s1);
            this.val = negative ? -this.val : this.val;
        }
        catch (NumberFormatException e) {
            throw new PSQLException(GT.tr("Conversion of money failed."), PSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE, (Throwable)e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGmoney) {
            PGmoney p = (PGmoney)obj;
            return this.val == p.val;
        }
        return false;
    }

    public Object clone() {
        return new PGmoney(this.val);
    }

    public String getValue() {
        if (this.val < 0.0) {
            return "-$" + -this.val;
        }
        return "$" + this.val;
    }
}

