/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateFunc;
import jp.sourceforge.gnp.prorate.ProrateRuleBool;
import jp.sourceforge.gnp.prorate.ProrateRuleEnd;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

class ProrateFuncExclusive
extends ProrateFunc {
    ProrateFuncExclusive(List in_args) {
        super(in_args);
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) {
        if (!this.checkArgnum(0, "Exclusive", runtime)) {
            return null;
        }
        if (!runtime.isSPA) {
            this.setEvaluatedObject(new ProrateRuleBool(true));
            return this.evaluatedObject;
        }
        String spaCarrier = runtime.sector.getCarrier();
        String tkCarrier = runtime.audit.getAirwayId();
        for (int i = 0; i < runtime.fcomp.getSectors().length; ++i) {
            ProrateSector sector = runtime.fcomp.getSectors()[i];
            if (sector.getCarrier().equals(spaCarrier) || sector.getCarrier().equals(tkCarrier)) continue;
            this.setEvaluatedObject(new ProrateRuleEnd());
            return this.evaluatedObject;
        }
        this.setEvaluatedObject(new ProrateRuleBool(true));
        return this.evaluatedObject;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateFuncExclusive pobj = new ProrateFuncExclusive(new Vector(this.args));
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print("Exclusive(");
        super.dump();
    }

    @Override
    public String operatorString() {
        return "Exclusive";
    }
}

