/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateFunc;
import jp.sourceforge.gnp.prorate.ProrateRuleBool;
import jp.sourceforge.gnp.prorate.ProrateRuleMultival;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuleString;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

class ProrateFuncGatewayCountry
extends ProrateFunc {
    ProrateFuncGatewayCountry(List in_args) {
        super(in_args);
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) throws Exception {
        if (!this.checkArgnum(1, "Gateway_country", runtime)) {
            return null;
        }
        this.args.set(0, ((ProrateRuleObject)this.args.get(0)).copy(runtime));
        ProrateRuleObject pobj = ((ProrateRuleObject)this.args.get(0)).eval(runtime);
        if (pobj == null) {
            this.setErrorObject();
            return null;
        }
        if (pobj.isMultival()) {
            List values = ((ProrateRuleMultival)pobj).getValues();
            for (int i = 0; i < values.size(); ++i) {
                ProrateRuleObject pobj2 = ((ProrateRuleObject)values.get(i)).copy(runtime);
                values.set(i, pobj2.copy(runtime));
                ProrateRuleObject subobj = ((ProrateRuleObject)values.get(i)).eval(runtime);
                if (subobj == null) {
                    this.setErrorObject();
                    return null;
                }
                if (!subobj.isString()) {
                    this.error(2, "Gateway_country:1", runtime);
                    return null;
                }
                if (!this.gatewayCountry(subobj, runtime)) continue;
                this.setEvaluatedObject(new ProrateRuleBool(true));
                return this.evaluatedObject;
            }
            this.setEvaluatedObject(new ProrateRuleBool(false));
            return this.evaluatedObject;
        }
        if (!pobj.isString()) {
            this.error(2, "Gateway_country:1", runtime);
            return null;
        }
        ProrateRuleBool ret = new ProrateRuleBool(this.gatewayCountry(pobj, runtime));
        this.setEvaluatedObject(ret);
        return ret;
    }

    boolean gatewayCountry(ProrateRuleObject pobj, ProrateRuntime runtime) {
        String objCountry = ((ProrateRuleString)pobj).getValue();
        for (int i = 0; i < runtime.fcomp.getSectors().length; ++i) {
            String toArea;
            ProrateSector sector = runtime.fcomp.getSectors()[i];
            String fromAreas = this.getAreaName(runtime, sector.getDepCode());
            String toAreas = this.getAreaName(runtime, sector.getDestCode());
            String fromArea = fromAreas.substring(0, 3);
            if (fromArea.equals(toArea = toAreas.substring(0, 3))) continue;
            String fromCountry = this.getCountryName(runtime, sector.getDepCode());
            String toCountry = this.getCountryName(runtime, sector.getDestCode());
            if (!fromCountry.equals(objCountry) && !toCountry.equals(objCountry)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateFuncGatewayCountry pobj = new ProrateFuncGatewayCountry(new Vector(this.args));
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print("Gateway_country(");
        super.dump();
    }

    @Override
    public String operatorString() {
        return "Gateway_country";
    }
}

