/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateFunc;
import jp.sourceforge.gnp.prorate.ProrateRuleMultival;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuleString;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

class ProrateFuncRoute
extends ProrateFunc {
    ProrateFuncRoute(List in_args) {
        super(in_args);
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) throws Exception {
        if (!this.checkArgnum(2, "Route", runtime)) {
            return null;
        }
        this.args.set(0, ((ProrateRuleObject)this.args.get(0)).copy(runtime));
        ProrateRuleObject car = ((ProrateRuleObject)this.args.get(0)).eval(runtime);
        if (car == null) {
            this.setErrorObject();
            return null;
        }
        this.args.set(1, ((ProrateRuleObject)this.args.get(1)).copy(runtime));
        ProrateRuleObject cdr = ((ProrateRuleObject)this.args.get(1)).eval(runtime);
        if (cdr == null) {
            this.setErrorObject();
            return null;
        }
        if (car.isMultival()) {
            car = ((ProrateRuleObject)((ProrateRuleMultival)car).getValues().get(0)).copy(runtime);
        }
        if (!car.isString()) {
            this.error(2, "Route:1", runtime);
            return null;
        }
        if (cdr.isMultival()) {
            cdr = ((ProrateRuleObject)((ProrateRuleMultival)cdr).getValues().get(0)).copy(runtime);
        }
        if (!cdr.isString()) {
            this.error(2, "Route:2", runtime);
            return null;
        }
        ProrateSector sector = null;
        String carPlace = ((ProrateRuleString)car).getValue();
        String cdrPlace = ((ProrateRuleString)cdr).getValue();
        for (int i = 0; i < runtime.fcomp.getSectors().length; ++i) {
            sector = runtime.fcomp.getSectors()[i];
            if (sector.getDepCode().equals(carPlace) && sector.getDestCode().equals(cdrPlace) || sector.getDepCode().equals(cdrPlace) && sector.getDestCode().equals(carPlace)) {
                if (sector.getViaRouting().equals("")) break;
                this.setEvaluatedObject(new ProrateRuleString(sector.getViaRouting()));
                return this.evaluatedObject;
            }
            sector = null;
        }
        String carArea = this.getAreaName(runtime, carPlace);
        String cdrArea = this.getAreaName(runtime, cdrPlace);
        int AREA_SZ = 3;
        if (carArea.substring(0, 3).equals("TC1") && cdrArea.substring(0, 3).equals("TC2") || carArea.substring(0, 3).equals("TC2") && cdrArea.substring(0, 3).equals("TC1")) {
            if (sector != null) {
                sector.setViaRouting("AT");
            }
            this.setEvaluatedObject(new ProrateRuleString("AT"));
            return this.evaluatedObject;
        }
        if (carArea.substring(0, 3).equals("TC1") && cdrArea.substring(0, 3).equals("TC3") || carArea.substring(0, 3).equals("TC3") && cdrArea.substring(0, 3).equals("TC1")) {
            if (sector != null) {
                sector.setViaRouting("PA");
            }
            this.setEvaluatedObject(new ProrateRuleString("PA"));
            return this.evaluatedObject;
        }
        if (sector != null) {
            sector.setViaRouting("ZZ");
        }
        this.setEvaluatedObject(new ProrateRuleString("ZZ"));
        return this.evaluatedObject;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateFuncRoute pobj = new ProrateFuncRoute(new Vector(this.args));
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print("Route(");
        super.dump();
    }

    @Override
    public String operatorString() {
        return "Route";
    }
}

