/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateDatabase;
import jp.sourceforge.gnp.prorate.ProrateFunc;
import jp.sourceforge.gnp.prorate.ProrateRuleAmount;
import jp.sourceforge.gnp.prorate.ProrateRuleBool;
import jp.sourceforge.gnp.prorate.ProrateRuleNumber;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;

class ProrateFuncSrpFix
extends ProrateFunc {
    ProrateFuncSrpFix(List in_args) {
        super(in_args);
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) {
        if (!this.checkArgnum(1, "Srp_fix", runtime)) {
            return null;
        }
        this.args.set(0, ((ProrateRuleObject)this.args.get(0)).copy(runtime));
        ProrateRuleObject valueObj = (ProrateRuleObject)this.args.get(0);
        if (valueObj == null) {
            this.setErrorObject();
            return null;
        }
        if (!valueObj.isNumber() && !valueObj.isAmount()) {
            this.error(2, "Srp_fix:1", runtime);
            return null;
        }
        double fixValue = 0.0;
        if (valueObj.isAmount()) {
            double day5Rate = 0.0;
            ProrateDatabase db = runtime.getAuditImpl().database;
            String currency = ((ProrateRuleAmount)valueObj).getCurrency();
            day5Rate = db.getMeanRate(currency, runtime.audit.getInvoiceMonth());
            if (day5Rate <= 0.0 && (day5Rate = db.get5dayRate(currency, runtime.audit.getInvoiceMonth())) < 0.0) {
                if (runtime.audit.getDay5Rate() <= 0.0) {
                    if (db.getResult() > 1) {
                        this.DBError(runtime, "get5dayRate", currency, runtime.audit.getInvoiceMonth());
                        return null;
                    }
                    int errorNo = 69;
                    StringBuffer errorMessage = new StringBuffer(currency);
                    errorMessage.append(":");
                    errorMessage.append(runtime.audit.getInvoiceMonth());
                    this.error(errorNo, errorMessage.toString(), runtime);
                    return null;
                }
                day5Rate = runtime.audit.getDay5Rate();
            }
            fixValue = ((ProrateRuleAmount)valueObj).getValue() / day5Rate;
        } else {
            fixValue = ((ProrateRuleNumber)valueObj).getValue();
        }
        double srpValue = 0.0;
        double totalProrateFactor = 0.0;
        for (int i = 0; i < runtime.fcomp.getSectors().length; ++i) {
            totalProrateFactor += runtime.fcomp.getSectors()[i].getProrateFactor();
        }
        srpValue = fixValue * runtime.sector.getProrateFactor() / totalProrateFactor;
        if (runtime.isSPA) {
            runtime.sector.setSpaNuc(runtime.sector.getSpaDiscountRate() * srpValue);
            runtime.sector.setProrationType(runtime.sector.getProrationType() & 0xF1000D00 | 0x1000000);
        } else {
            runtime.sector.setApdpNuc(runtime.sector.getApdpDiscountRate() * srpValue);
            runtime.sector.setProrationType((runtime.sector.getProrationType() & 0x1000000) != 0 ? runtime.sector.getProrationType() & 0x100 : 0x2000100);
        }
        this.setEvaluatedObject(new ProrateRuleBool(true));
        return this;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateFuncSrpFix pobj = new ProrateFuncSrpFix(new Vector(this.args));
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print("SrpFix(");
        super.dump();
    }

    @Override
    public String operatorString() {
        return "SrpFix";
    }
}

