/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateFunc;
import jp.sourceforge.gnp.prorate.ProrateRule;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.ProrateVarAuto;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseException;

class ProrateRuleExtern
extends ProrateFunc
implements ProrateRule {
    protected String name;
    protected List argVars;
    protected List rules;
    protected List autoVars;

    ProrateRuleExtern(String extfName, List args, List argVars) {
        super(args);
        this.name = extfName;
        this.args = args;
        this.argVars = argVars;
        this.rules = null;
        this.setAutoVars(new Vector());
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) throws Exception {
        try {
            if (!runtime.getAuditImpl().rulebase.selectEXTF(this.name)) {
                String str = this.name + " : undefined EXTF";
                this.error(8, str, runtime);
                return null;
            }
        }
        catch (ProrateRulebaseException e) {
            String str = "rulebase error in selecting EXTF " + this.name;
            this.error(8, str, runtime);
            return null;
        }
        try {
            this.rules = runtime.getAuditImpl().rulebase.read();
        }
        catch (ProrateRulebaseException e) {
            String str = "rulebase error in reading EXTF " + this.name;
            this.error(8, str, runtime);
            return null;
        }
        for (int i = 0; i < this.args.size(); ++i) {
            ProrateRuleObject var = (ProrateRuleObject)this.argVars.get(i);
            if (var == null) {
                this.error(3, this.name, runtime);
                return this;
            }
            this.args.set(i, ((ProrateRuleObject)this.args.get(i)).copy(runtime));
            ProrateRuleObject value = ((ProrateRuleObject)this.args.get(i)).eval(runtime);
            ((ProrateVarAuto)var).setValue(value);
            this.addAutoVar(var);
        }
        ProrateRule scope = runtime.rule;
        runtime.rule = this;
        ProrateRuleObject ret = null;
        for (int i = 0; i < this.rules.size(); ++i) {
            this.rules.set(i, ((ProrateRuleObject)this.rules.get(i)).copy(runtime));
            ret = ((ProrateRuleObject)this.rules.get(i)).eval(runtime);
            if (!runtime.apply) break;
        }
        runtime.rule = scope;
        if (!runtime.apply) {
            if (ret == null) {
                this.setErrorObject();
            } else {
                this.setEvaluatedObject(ret);
            }
        } else {
            this.setEvaluatedObject(ret);
        }
        return this.evaluatedObject;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateRuleExtern pobj = new ProrateRuleExtern(this.name, new Vector(this.args), new Vector(this.argVars));
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public List getAutoVars() {
        return this.autoVars;
    }

    @Override
    public void setAutoVars(List vector) {
        this.autoVars = vector;
    }

    @Override
    public ProrateRuleObject getAutoVar(short regist) {
        ProrateRuleObject pobj = null;
        short index = (short)(regist - 1536);
        if (this.autoVars.size() > index) {
            pobj = (ProrateRuleObject)this.autoVars.get(index);
        }
        if (pobj == null || ((ProrateVarAuto)pobj).getRegist() != regist) {
            for (int i = 0; i < this.autoVars.size() && ((ProrateVarAuto)(pobj = (ProrateRuleObject)this.autoVars.get(i))).getRegist() != regist; ++i) {
            }
        }
        if (pobj != null && ((ProrateVarAuto)pobj).getRegist() == regist) {
            return pobj;
        }
        return null;
    }

    @Override
    public void addAutoVar(ProrateRuleObject pobj) {
        this.autoVars.add(pobj);
    }

    @Override
    public void dump() {
        System.out.print("FUNCTION[" + this.name + "](");
        super.dump();
    }

    @Override
    public boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
        int i;
        if (!this.isEvaluated()) {
            return false;
        }
        StringBuffer traceStr = new StringBuffer();
        if (this.evaluatedObject != null && this.evaluatedObject != this) {
            traceStr.append(this.evaluatedObject.traceStr());
            traceStr.append("<-");
        }
        traceStr.append(this.traceStr() + "(");
        for (i = 0; i < this.args.size(); ++i) {
            if (i > 0) {
                traceStr.append(" ");
            }
            traceStr.append(((ProrateRuleObject)this.args.get(i)).traceStr());
            if (traceStr.charAt(traceStr.length() - 1) != '(') continue;
            traceStr.append(")");
        }
        traceStr.append(")");
        trace.trace(traceStr.toString(), sector.getSequenceNo(), level);
        if (!this.traceArgs(sector, trace, level + 1)) {
            return false;
        }
        for (i = 0; i < this.rules.size(); ++i) {
            if (trace.trace((ProrateRuleObject)this.rules.get(i), sector, level)) continue;
            return false;
        }
        return this.traceValue(sector, trace, level + 1);
    }

    @Override
    public String operatorString() {
        StringBuffer strbuf = new StringBuffer("FUNCTION[");
        strbuf.append(this.name);
        strbuf.append("](");
        return strbuf.toString();
    }
}

