/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

class ProrateRuleString
extends ProrateRuleObject {
    protected String value;
    protected String fareBasis;
    static final char WILD_CHAR = '*';

    ProrateRuleString(String str) {
        this.value = str;
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) {
        this.fareBasis = runtime.sector.getFareBasis();
        this.evaluatedObject = this;
        return this;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateRuleString pobj = new ProrateRuleString(this.value);
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print("\"" + this.value + "\"");
    }

    @Override
    boolean isString() {
        return true;
    }

    String getValue() {
        return this.value;
    }

    @Override
    boolean equal(ProrateRuleObject other) {
        if (other.isMultival() || other.isInterval()) {
            return other.equal(this);
        }
        if (other.isNumber()) {
            return other.equal(this);
        }
        if (!other.isString()) {
            return false;
        }
        String cdr = ((ProrateRuleString)other).getValue();
        if (this.isSpecialString(this.value)) {
            return this.specialStringEqual(this.value, cdr);
        }
        if (this.isSpecialString(cdr)) {
            return this.specialStringEqual(cdr, this.value);
        }
        if (this.isWildString(this.value)) {
            return this.match(this.value, cdr);
        }
        if (this.isWildString(cdr)) {
            return this.match(cdr, this.value);
        }
        return this.value.equals(cdr);
    }

    @Override
    boolean gtEq(ProrateRuleObject other) {
        return this.equal(other);
    }

    @Override
    boolean ltEq(ProrateRuleObject other) {
        return this.equal(other);
    }

    @Override
    boolean include(ProrateRuleObject other) {
        if (other.isMultival() || other.isInterval()) {
            return other.isIncluded(this);
        }
        if (!other.isString()) {
            return false;
        }
        String cdr = ((ProrateRuleString)other).getValue();
        if (this.isWildString(this.value)) {
            return this.match(this.value, cdr);
        }
        if (this.isWildString(cdr)) {
            StringBuffer expr = new StringBuffer();
            if (cdr.charAt(0) != '*') {
                expr.append("*");
            }
            expr.append(cdr);
            if (cdr.charAt(cdr.length() - 1) != '*') {
                expr.append("*");
            }
            return this.match(expr.toString(), this.value);
        }
        return this.value.indexOf(((ProrateRuleString)other).getValue()) >= 0;
    }

    boolean isSpecialString(String str) {
        return str.equals("Y-SP") || str.equals("C-SP") || str.equals("F-SP") || str.equals("F#") || str.equals("C#") || str.equals("Y#");
    }

    boolean specialStringEqual(String car, String cdr) {
        if (car.equals("Y-SP")) {
            return this.yspEqual(car, cdr);
        }
        if (car.equals("C-SP")) {
            return this.cspEqual(car, cdr);
        }
        if (car.equals("F-SP")) {
            return this.fspEqual(car, cdr);
        }
        if (car.equals("F#")) {
            return this.fEqual(car, cdr);
        }
        if (car.equals("C#")) {
            return this.cEqual(car, cdr);
        }
        if (car.equals("Y#")) {
            return this.yEqual(car, cdr);
        }
        return false;
    }

    boolean yspEqual(String car, String cdr) {
        int fareType = this.identifyFare(this.fareBasis);
        if (fareType == 1) {
            return false;
        }
        return this.yEqual(car, cdr);
    }

    boolean cspEqual(String car, String cdr) {
        int fareType = this.identifyFare(this.fareBasis);
        if (fareType == 1) {
            return false;
        }
        return this.cEqual(car, cdr);
    }

    boolean fspEqual(String car, String cdr) {
        int fareType = this.identifyFare(this.fareBasis);
        if (fareType == 1) {
            return false;
        }
        return this.fEqual(car, cdr);
    }

    boolean fEqual(String car, String cdr) {
        return F_classes.indexOf(cdr.charAt(0)) >= 0;
    }

    boolean cEqual(String car, String cdr) {
        return C_classes.indexOf(cdr.charAt(0)) >= 0;
    }

    boolean yEqual(String car, String cdr) {
        return Y_classes.indexOf(cdr.charAt(0)) >= 0;
    }

    boolean isWildString(String str) {
        return str.indexOf(42) >= 0;
    }

    boolean match(String expr, String str) {
        int strptr = -1;
        int nextexpr = -1;
        if (expr.charAt(0) == '*') {
            if (expr.length() == 1) {
                return true;
            }
            expr = expr.substring(1);
            strptr = str.indexOf(expr.charAt(0));
            while (strptr >= 0) {
                if (this.match(expr, str.substring(strptr))) {
                    return true;
                }
                str = str.substring(strptr + 1);
                strptr = str.indexOf(expr.charAt(0));
            }
        } else {
            nextexpr = expr.indexOf(42);
            if (nextexpr >= 0) {
                if (str.length() < nextexpr) {
                    return false;
                }
                if (!str.substring(0, nextexpr).equals(expr.substring(0, nextexpr))) {
                    return false;
                }
            } else {
                return str.equals(expr);
            }
            str = str.substring(nextexpr);
            if ((expr = expr.substring(nextexpr + 1)).length() == 0) {
                return true;
            }
            strptr = 0;
            while (strptr >= 0) {
                if (this.match(expr, str.substring(strptr))) {
                    return true;
                }
                str = str.substring(strptr + 1);
                strptr = str.indexOf(expr.charAt(0));
            }
        }
        return false;
    }

    @Override
    boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
        return false;
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }

    @Override
    String traceStr() {
        return this.toString();
    }
}

