/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateRuleBool;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;

class ProrateRuleTable
extends ProrateRuleObject {
    int rowIndex = -1;
    int colIndex = -1;
    protected ProrateRuleObject varrow = null;
    protected ProrateRuleObject varrowObj;
    protected ProrateRuleObject varcol;
    protected ProrateRuleObject varcolObj;
    protected List rows;
    protected List cols;
    protected List tbls;

    public ProrateRuleTable(ProrateRuleObject prows, ProrateRuleObject pcols, List rows, List cols, List tbls) {
        this.varrowObj = prows;
        this.varcol = null;
        this.varcolObj = pcols;
        this.rows = rows;
        this.cols = cols;
        this.tbls = tbls;
    }

    public ProrateRuleTable(ProrateRuleObject pcols, List cols, List tbls) {
        this.varrowObj = null;
        this.varcol = null;
        this.varcolObj = pcols;
        this.rows = null;
        this.cols = cols;
        this.tbls = tbls;
    }

    public ProrateRuleTable(ProrateRulebaseElement prows, ProrateRulebaseElement pcols, List rows, List cols, List tbls) {
        this.varrowObj = (ProrateRuleObject)prows;
        this.varcol = null;
        this.varcolObj = (ProrateRuleObject)pcols;
        this.rows = rows;
        this.cols = cols;
        this.tbls = tbls;
    }

    public ProrateRuleTable(ProrateRulebaseElement pcols, List cols, List tbls) {
        this.varrowObj = null;
        this.varcol = null;
        this.varcolObj = (ProrateRuleObject)pcols;
        this.rows = null;
        this.cols = cols;
        this.tbls = tbls;
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) throws Exception {
        int j;
        int i;
        ProrateRuleObject ret = null;
        this.setEvaluatedObject(new ProrateRuleBool(true));
        if (this.varrowObj != null && this.rows != null) {
            this.varrowObj = this.varrowObj.copy(runtime);
            this.varrow = this.varrowObj.eval(runtime);
            if (this.varrow == null) {
                this.setErrorObject();
                return null;
            }
            for (i = 0; i < this.rows.size(); ++i) {
                ProrateRuleObject pobj = (ProrateRuleObject)this.rows.get(i);
                this.rows.set(i, pobj.copy(runtime));
                ret = ((ProrateRuleObject)this.rows.get(i)).eval(runtime);
                if (ret == null) {
                    this.setErrorObject();
                    return null;
                }
                if (!ret.equal(this.varrow)) continue;
                this.rowIndex = i;
                break;
            }
            if (i >= this.rows.size()) {
                ret = new ProrateRuleBool(false);
                this.setEvaluatedObject(ret);
                this.rowIndex = -1;
                return ret;
            }
        } else {
            this.rowIndex = i = 0;
        }
        this.varcolObj = this.varcolObj.copy(runtime);
        this.varcol = this.varcolObj.eval(runtime);
        if (this.varcol == null) {
            this.setErrorObject();
            return null;
        }
        for (j = 0; j < this.cols.size(); ++j) {
            this.cols.set(j, ((ProrateRuleObject)this.cols.get(j)).copy(runtime));
            ret = ((ProrateRuleObject)this.cols.get(j)).eval(runtime);
            if (ret == null) {
                this.setErrorObject();
                return null;
            }
            if (!ret.equal(this.varcol)) continue;
            this.colIndex = j;
            break;
        }
        if (j >= this.cols.size()) {
            ret = new ProrateRuleBool(false);
            this.setEvaluatedObject(ret);
            this.colIndex = -1;
            return ret;
        }
        int tblIndex = i * this.cols.size() + j;
        ProrateRuleObject pobj = (ProrateRuleObject)this.tbls.get(tblIndex);
        this.tbls.set(tblIndex, pobj.copy(runtime));
        ret = ((ProrateRuleObject)this.tbls.get(tblIndex)).eval(runtime);
        return ret;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateRuleTable pobj = new ProrateRuleTable(this.varrowObj != null ? this.varrowObj.copy(runtime) : null, this.varcolObj.copy(runtime), this.rows != null ? new Vector(this.rows) : null, new Vector(this.cols), new Vector(this.tbls));
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        int i;
        System.out.println("");
        System.out.print("TABLE((");
        if (this.varrowObj != null) {
            this.varrowObj.dump();
            System.out.print(",");
        }
        this.varcolObj.dump();
        System.out.println(")");
        if (this.rows != null) {
            System.out.print("[");
            for (i = 0; i < this.rows.size(); ++i) {
                ((ProrateRuleObject)this.rows.get(i)).dump();
                System.out.print(" ");
            }
            System.out.print("]");
        }
        if (this.cols != null) {
            System.out.print("[");
            for (i = 0; i < this.cols.size(); ++i) {
                ((ProrateRuleObject)this.cols.get(i)).dump();
                System.out.print(" ");
            }
            System.out.print("]");
        }
        if (this.tbls != null) {
            System.out.print("[");
            for (i = 0; i < this.tbls.size(); ++i) {
                ((ProrateRuleObject)this.tbls.get(i)).dump();
                System.out.print(" ");
            }
            System.out.print("]");
        }
        System.out.println(")");
    }

    @Override
    boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
        ProrateRuleObject pobj;
        int i;
        if (!this.isEvaluated()) {
            return false;
        }
        StringBuffer traceStr = new StringBuffer("TABLE(");
        if (this.varrowObj != null) {
            traceStr.append(this.varrowObj.traceStr());
            if (traceStr.charAt(traceStr.length() - 1) == '(') {
                traceStr.append(")");
            }
            traceStr.append(" ");
        }
        traceStr.append(this.varcolObj.traceStr());
        if (traceStr.charAt(traceStr.length() - 1) == '(') {
            traceStr.append(")");
        }
        traceStr.append(")");
        trace.trace(traceStr.toString(), sector.getSequenceNo(), level);
        if (this.varrowObj != null) {
            trace.trace(this.varrowObj, sector, level + 1);
        }
        trace.trace(this.varcolObj, sector, level + 1);
        if (this.rows != null && this.rows.size() > 0) {
            traceStr = new StringBuffer("[");
            for (i = 0; i < this.rows.size(); ++i) {
                if (i > 0) {
                    traceStr.append(" ");
                }
                if (!(pobj = (ProrateRuleObject)this.rows.get(i)).isEvaluated()) continue;
                traceStr.append(pobj.traceStr());
                if (traceStr.charAt(traceStr.length() - 1) == '(') {
                    traceStr.append(")");
                }
                if (i != this.rowIndex) continue;
                traceStr.append(" ..");
                break;
            }
            traceStr.append("]");
            trace.trace(traceStr.toString(), sector.getSequenceNo(), level);
        }
        traceStr = new StringBuffer("[");
        for (i = 0; i < this.cols.size(); ++i) {
            if (i > 0) {
                traceStr.append(" ");
            }
            if (!(pobj = (ProrateRuleObject)this.cols.get(i)).isEvaluated()) continue;
            traceStr.append(pobj.traceStr());
            if (traceStr.charAt(traceStr.length() - 1) == '(') {
                traceStr.append(")");
            }
            if (this.colIndex != i) continue;
            traceStr.append(" ..");
            break;
        }
        traceStr.append("]");
        trace.trace(traceStr.toString(), sector.getSequenceNo(), level);
        if (this.colIndex >= 0) {
            traceStr = new StringBuffer("[at (");
            if (this.rowIndex >= 0) {
                traceStr.append(this.rowIndex);
                traceStr.append(",");
            }
            traceStr.append(this.colIndex);
            traceStr.append(") : ");
            ProrateRuleObject pobj2 = (ProrateRuleObject)this.tbls.get(this.rowIndex >= 0 ? this.rowIndex * this.cols.size() + this.colIndex : this.colIndex);
            traceStr.append(pobj2.traceStr());
            if (traceStr.charAt(traceStr.length() - 1) == '(') {
                traceStr.append(")");
            }
            traceStr.append("]");
            trace.trace(traceStr.toString(), sector.getSequenceNo(), level);
            for (int i2 = 0; i2 < this.tbls.size(); ++i2) {
                trace.trace((ProrateRuleObject)this.tbls.get(i2), sector, level + 1);
            }
        }
        return true;
    }
}

