/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

class ProrateRuleTest
extends ProrateRuleObject {
    protected List tests;
    protected List thens;
    protected List elses;

    ProrateRuleTest(List test, List then_s, List else_s) {
        this.tests = test;
        this.thens = then_s;
        this.elses = else_s;
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) throws Exception {
        ProrateRuleObject pobj;
        int i;
        ProrateRuleObject ret = null;
        boolean forUnification = false;
        runtime.status = true;
        runtime.hops = 2;
        for (i = 0; i < this.tests.size(); ++i) {
            if (!((ProrateRuleObject)this.tests.get(i)).unification()) continue;
            forUnification = true;
            break;
        }
        if (forUnification) {
            ret = this.unify(runtime);
        } else {
            for (i = 0; i < this.tests.size(); ++i) {
                pobj = (ProrateRuleObject)this.tests.get(i);
                this.tests.set(i, pobj.copy(runtime));
                ret = ((ProrateRuleObject)this.tests.get(i)).eval(runtime);
                if (!runtime.apply) {
                    if (ret == null) {
                        this.setErrorObject();
                    } else {
                        this.setEvaluatedObject(ret);
                    }
                    return ret;
                }
                if (!ret.isFalse()) continue;
                runtime.status = false;
            }
        }
        if (!runtime.apply) {
            if (ret == null) {
                this.setErrorObject();
            } else {
                this.setEvaluatedObject(ret);
            }
            return ret;
        }
        this.setEvaluatedObject(ret);
        if (ret.isTrue()) {
            for (i = 0; i < this.thens.size(); ++i) {
                pobj = (ProrateRuleObject)this.thens.get(i);
                this.thens.set(i, pobj.copy(runtime));
                ret = ((ProrateRuleObject)this.thens.get(i)).eval(runtime);
                if (runtime.apply) continue;
                return ret;
            }
        } else {
            for (i = 0; i < this.elses.size(); ++i) {
                pobj = (ProrateRuleObject)this.elses.get(i);
                this.elses.set(i, pobj.copy(runtime));
                ret = ((ProrateRuleObject)this.elses.get(i)).eval(runtime);
                if (runtime.apply) continue;
                return ret;
            }
        }
        runtime.hops = 2;
        return ret;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateRuleTest pobj = new ProrateRuleTest(new Vector(this.tests), new Vector(this.thens), new Vector(this.elses));
        pobj.isCopied = true;
        return pobj;
    }

    ProrateRuleObject unify(ProrateRuntime runtime) throws Exception {
        ProrateRuleObject ret = null;
        for (int i = 0; i < runtime.fcomp.getSectors().length; ++i) {
            runtime.unifiedSector = runtime.fcomp.getSectors()[i];
            runtime.status = true;
            runtime.hops = 2;
            for (int j = 0; j < this.tests.size(); ++j) {
                ProrateRuleObject pobj = (ProrateRuleObject)this.tests.get(j);
                this.tests.set(j, pobj.copy(runtime));
                ret = ((ProrateRuleObject)this.tests.get(j)).eval(runtime);
                if (!runtime.apply) {
                    if (ret == null) {
                        this.setErrorObject();
                    } else {
                        this.setEvaluatedObject(ret);
                    }
                    return ret;
                }
                if (!ret.isFalse()) continue;
                runtime.status = false;
            }
            if (!ret.isTrue()) continue;
            return ret;
        }
        return ret;
    }

    @Override
    public void dump() {
        int i;
        System.out.print("TEST[");
        for (i = 0; i < this.tests.size(); ++i) {
            ((ProrateRuleObject)this.tests.get(i)).dump();
        }
        System.out.println("]");
        if (this.thens.size() > 0) {
            System.out.print("THEN[");
            for (i = 0; i < this.thens.size(); ++i) {
                ((ProrateRuleObject)this.thens.get(i)).dump();
            }
            System.out.println("]");
        }
        if (this.elses.size() > 0) {
            System.out.print("ELSE[");
            for (i = 0; i < this.elses.size(); ++i) {
                ((ProrateRuleObject)this.elses.get(i)).dump();
            }
            System.out.println("]");
        }
    }

    @Override
    boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
        int j;
        int i;
        if (!this.isEvaluated()) {
            return false;
        }
        StringBuffer traceStr = new StringBuffer("TEST");
        traceStr.append(this.traceValueStr());
        traceStr.append("(");
        for (i = 0; i < this.tests.size(); ++i) {
            ProrateRuleObject pobj;
            if (i > 0) {
                traceStr.append(" ");
            }
            if (!(pobj = (ProrateRuleObject)this.tests.get(i)).isEvaluated()) continue;
            traceStr.append(pobj.traceStr());
            if (traceStr.charAt(traceStr.length() - 1) != '(') continue;
            traceStr.append(")");
        }
        traceStr.append(")");
        if (!trace.trace(traceStr.toString(), sector.getSequenceNo(), level)) {
            return false;
        }
        for (j = 0; j < this.tests.size(); ++j) {
            trace.trace((ProrateRuleObject)this.tests.get(j), sector, level + 1);
        }
        if (this.evaluatedObject.isTrue() && this.thens.size() > 0) {
            traceStr = new StringBuffer("THEN");
            traceStr.append("(");
            for (i = 0; i < this.thens.size(); ++i) {
                if (i > 0) {
                    traceStr.append(" ");
                }
                traceStr.append(((ProrateRuleObject)this.thens.get(i)).traceStr());
                if (traceStr.charAt(traceStr.length() - 1) != '(') continue;
                traceStr.append(")");
            }
            if (traceStr.toString().equals("THEN()")) {
                traceStr = new StringBuffer("THEN");
            } else {
                traceStr.append(")");
            }
            if (!trace.trace(traceStr.toString(), sector.getSequenceNo(), level)) {
                return false;
            }
            for (j = 0; j < this.thens.size(); ++j) {
                trace.trace((ProrateRuleObject)this.thens.get(j), sector, level + 1);
            }
        }
        if (this.evaluatedObject.isFalse() && this.elses.size() > 0) {
            traceStr = new StringBuffer("ELSE");
            traceStr.append("(");
            for (i = 0; i < this.elses.size(); ++i) {
                if (i > 0) {
                    traceStr.append(" ");
                }
                traceStr.append(((ProrateRuleObject)this.elses.get(i)).traceStr());
                if (traceStr.charAt(traceStr.length() - 1) != '(') continue;
                traceStr.append(")");
            }
            if (traceStr.toString().equals("ELSE()")) {
                traceStr = new StringBuffer("ELSE");
            } else {
                traceStr.append(")");
            }
            if (!trace.trace(traceStr.toString(), sector.getSequenceNo(), level)) {
                return false;
            }
            for (j = 0; j < this.elses.size(); ++j) {
                trace.trace((ProrateRuleObject)this.elses.get(j), sector, level + 1);
            }
        }
        return true;
    }
}

