/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import jp.sourceforge.gnp.prorate.ProrateAuditImpl;
import jp.sourceforge.gnp.prorate.ProrateRule;
import jp.sourceforge.gnp.prorate.ProrateRuleTop;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.export.Prorate;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateFareComponent;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

public class ProrateSectorImpl {
    static final String CH_MPRP_DEFAULT_DISCOUNT = "0.25";
    ProrateSector sector;

    boolean prorate(ProrateAuditImpl auditImpl, ProrateSector sector, ProrateAudit audit, ProrateFareComponent fcomp, int sectorIndex) throws Exception {
        this.sector = sector;
        ProrateRuntime runtime = new ProrateRuntime();
        runtime.setAuditImpl(auditImpl);
        if ((sector.getProrationType() & 0x800) == 0 && (sector.getProrationType() & 0x400) == 0 && !audit.isPlusFlg() && runtime.getAuditImpl().rulebase.selectAPDP(sector.getCarrier(), audit.getIssueDate())) {
            ProrateRuleTop apdpCode = new ProrateRuleTop(runtime.getAuditImpl().rulebase.read());
            ProrateRule apdpRule = apdpCode.copy(runtime);
            runtime.setAPDP(audit, fcomp, sector, apdpRule);
            sector.setApdpDiscountRate(1.0);
            sector.setFixedFareDiscount(1.0);
            this.initialize(false);
            runtime.eval();
            runtime.getAuditImpl().trace.trace(runtime, "APDP", sector.getCarrier(), "");
            runtime.getAuditImpl().trace.trace(apdpRule, sector, 1);
            runtime.getAuditImpl().rulebase.close();
            apdpRule = null;
            apdpCode = null;
            if (sector.getFixedFareDiscount() < fcomp.getFixedFareDiscount()) {
                fcomp.setFixedFareDiscount(sector.getFixedFareDiscount());
            }
        }
        if ((sector.getProrationType() & 0x200) == 0 && (!audit.isInward() || sector.getCarrier().equals(audit.getInwardId()) || sector.getOpCarrier().equals(audit.getInwardId())) && runtime.getAuditImpl().rulebase.selectSPA(sector.getCarrier(), audit.getAirwayId(), audit.getIssueDate())) {
            ProrateRuleTop spaCode = new ProrateRuleTop(runtime.getAuditImpl().rulebase.read());
            ProrateRule spaRule = spaCode.copy(runtime);
            runtime.setSPA(audit, fcomp, sector, spaRule);
            sector.setSpaDiscountRate(1.0);
            this.initialize(true);
            runtime.eval();
            runtime.getAuditImpl().trace.trace(runtime, "SPA", sector.getCarrier(), audit.getAirwayId());
            runtime.getAuditImpl().trace.trace(spaRule, sector, 1);
            runtime.getAuditImpl().rulebase.close();
            spaRule = null;
            spaCode = null;
        }
        runtime = null;
        return true;
    }

    boolean initialize(boolean isSPA) {
        ClassLoader loader = Prorate.class.getClassLoader();
        InputStream is = loader.getResourceAsStream("jp/sourceforge/gnp/prorate.properties");
        Properties properties = new Properties();
        try {
            properties.load(is);
        }
        catch (IOException e) {
            // empty catch block
        }
        String chMprpDiscountStr = properties.getProperty("GNP_CH_MPRP", CH_MPRP_DEFAULT_DISCOUNT);
        double chMprpDiscount = Double.parseDouble(chMprpDiscountStr);
        this.sector.setFixedFareDiscount(1.0);
        if (isSPA) {
            return true;
        }
        int idx = this.sector.getFareBasis().indexOf("CH");
        if (idx >= 0) {
            String rate = this.sector.getFareBasis().substring(idx + 2);
            if (rate.length() > 0) {
                char c = rate.charAt(0);
                if (c < '0' || c > '9') {
                    this.sector.setFixedFareDiscount(chMprpDiscount);
                } else {
                    double percent = Double.parseDouble(rate);
                    if (percent > 0.0 && percent < 100.0) {
                        this.sector.setFixedFareDiscount((100.0 - percent) / 100.0);
                    }
                }
            } else {
                this.sector.setFixedFareDiscount(0.5);
            }
        }
        return true;
    }
}

