/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prubae;

import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import jp.sourceforge.gnp.prubae.PrubaeController;
import jp.sourceforge.gnp.prubae.PrubaeControllerAndOr;
import jp.sourceforge.gnp.prubae.PrubaeModelAndOr;
import jp.sourceforge.gnp.prubae.PrubaeModelJudge;

public class PrubaeControllerJudge
extends PrubaeController {
    protected void addBasicButtons() {
        JButton insertButton = new JButton("insert And upon this");
        insertButton.setActionCommand("insert");
        insertButton.addActionListener(this);
        JPanel commandPanel = new JPanel();
        commandPanel.setLayout(new BoxLayout(commandPanel, 1));
        commandPanel.add(insertButton);
        this.panel.add(commandPanel);
    }

    protected void createButtons() {
        JButton orButton = new JButton("And/Or");
        orButton.setActionCommand("AndOr");
        orButton.addActionListener(this);
        JButton judgeButton = new JButton("Judge");
        judgeButton.setActionCommand("JudgeStatement");
        judgeButton.addActionListener(this);
        JPanel opPanel = new JPanel();
        opPanel.setLayout(new BoxLayout(opPanel, 1));
        opPanel.add(orButton);
        opPanel.add(judgeButton);
        this.panel.add(opPanel);
    }

    @Override
    public void createPanel() {
        super.createPanel();
        this.addBasicButtons();
        this.createButtons();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("delete")) {
            this.deleteAndUp();
        } else if (e.getActionCommand().equals("insert")) {
            PrubaeModelAndOr newModel = new PrubaeModelAndOr();
            newModel.swap(this.getModel());
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getTreeNode().getParent();
            newModel.getController().swapTreeNode(node, this.getTreeNode());
            newModel.setJudges(this.getModel(), new PrubaeModelJudge());
            ((PrubaeControllerAndOr)newModel.getController()).setTreeNodes();
            newModel.getView().display();
            newModel.getController().open();
        } else {
            String className = this.getClass().getName();
            int rindex = className.lastIndexOf(46) + 1;
            String oldClassName = className;
            oldClassName = oldClassName.substring(rindex + 16);
            if (e.getActionCommand().equals(oldClassName)) {
                System.err.println(oldClassName + " need not swap");
                return;
            }
            System.err.println(oldClassName + "(" + this.getClass().getName() + ") swap " + e.getActionCommand());
            className = className.substring(0, rindex) + "PrubaeModel" + e.getActionCommand();
            PrubaeModelJudge newModel = null;
            try {
                Class<?> c = Class.forName(className);
                newModel = (PrubaeModelJudge)c.newInstance();
            }
            catch (Exception exc) {
                System.err.println(exc.toString());
            }
            newModel.swap(this.getModel());
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getTreeNode().getParent();
            newModel.getController().swapTreeNode(node, this.getTreeNode());
            this.getModel().delete();
            if (e.getActionCommand().equals("AndOr")) {
                ((PrubaeModelAndOr)newModel).setJudges(new PrubaeModelJudge(), new PrubaeModelJudge());
                ((PrubaeControllerAndOr)newModel.getController()).setTreeNodes();
            }
            newModel.getController().open();
            newModel.getView().display();
        }
    }
}

