/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prubae;

import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.math.IntNum;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sourceforge.glj.lisp.Lisp;
import jp.sourceforge.gnp.prubae.PrubaeControllerJudge;
import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.prubae.PrubaeModelJudgeStatement;
import jp.sourceforge.gnp.prubae.PrubaeModelValueStatement;

public class PrubaeControllerJudgeStatement
extends PrubaeControllerJudge {
    private JTextField statementField;
    private JComboBox functionBox;

    @Override
    protected void createButtons() {
        super.createButtons();
        this.setStatementField(new JTextField("", 16));
        this.getStatementField().setEditable(false);
        JPanel judgePanel = new JPanel();
        judgePanel.setLayout(new BoxLayout(judgePanel, 0));
        JLabel judgeLabel = new JLabel("Judge : ");
        judgePanel.add(judgeLabel);
        judgePanel.add(this.getStatementField());
        this.getPanel().add(judgePanel);
        this.setFunctionBox(new JComboBox());
        this.getFunctionBox().setMaximumRowCount(4);
        this.getFunctionBox().setActionCommand("select function");
        this.getPanel().add(this.getFunctionBox());
    }

    @Override
    public void update() {
        ((PrubaeModelJudgeStatement)this.getModel()).updateStatement();
        super.update();
    }

    @Override
    public void createPanel() {
        super.createPanel();
        PrubaeModelJudgeStatement model = (PrubaeModelJudgeStatement)this.getModel();
        if (model.getValues() != null) {
            for (int i = 0; i < model.getValues().size(); ++i) {
                if (!(model.getValues().get(i) instanceof PrubaeModel)) continue;
                PrubaeModel child = (PrubaeModel)model.getValues().get(i);
                if (child.getController() == null) {
                    child.openUI();
                }
                child.getController().createPanel();
            }
        }
        LList list = this.getEditor().getJudgeList();
        this.getFunctionBox().addItem("");
        while (!Lisp.isNil(list)) {
            LList judgeList = (LList)Lisp.car(list);
            String itemStr = Lisp.car(Lisp.cdr(judgeList)).toString();
            this.getFunctionBox().addItem(itemStr);
            list = (LList)Lisp.cdr(list);
        }
        this.getFunctionBox().addActionListener(this);
    }

    @Override
    public void destroyPanel() {
        this.setStatementField(null);
        this.setFunctionBox(null);
        super.destroyPanel();
    }

    protected void select(String selected) {
        PrubaeModelJudgeStatement model = (PrubaeModelJudgeStatement)this.getModel();
        LList list = this.getEditor().getJudgeList();
        while (!Lisp.isNil(list)) {
            LList judgeList = (LList)Lisp.car(list);
            String itemStr = Lisp.car(Lisp.cdr(judgeList)).toString();
            if (selected.equals(itemStr)) {
                short regist = (short)((IntNum)Lisp.car(judgeList)).intValue();
                if (model.getRegist() == regist && model.getName().equals(selected)) break;
                if (model.getValues() != null) {
                    for (int i = 0; i < model.getValues().size(); ++i) {
                        if (!(model.getValues().get(i) instanceof PrubaeModel)) continue;
                        ((PrubaeModel)model.getValues().get(i)).closeUI();
                    }
                    model.getValues().clear();
                }
                model.setRegist(regist);
                this.arguments(judgeList);
                model.updateStatement();
                this.getStatementField().setText(model.getStatement());
                break;
            }
            list = (LList)Lisp.cdr(list);
        }
    }

    private void arguments(LList judgeList) {
        int i;
        PrubaeModelJudgeStatement model = (PrubaeModelJudgeStatement)this.getModel();
        Object isArgs = Lisp.car(Lisp.cdr(Lisp.cdr(judgeList)));
        System.err.println("judge controller Arguments");
        if (isArgs == null) {
            return;
        }
        if (!(isArgs instanceof IntNum)) {
            return;
        }
        int numArgs = ((IntNum)isArgs).intValue();
        if (numArgs <= 0) {
            return;
        }
        System.err.println("judge controller Arguments = " + numArgs);
        Object listArgs = Lisp.cdr(Lisp.cdr(Lisp.cdr(judgeList)));
        Object[] typeArgs = new Object[numArgs];
        for (i = 0; i < numArgs; ++i) {
            typeArgs[i] = Lisp.car(listArgs);
            listArgs = Lisp.cdr(listArgs);
        }
        if (model.getValues() == null) {
            model.setValues(new Vector());
        }
        if (numArgs == 1 && typeArgs[0] != null && typeArgs[0].equals("setamount")) {
            model.getValues().add("");
            model.getValues().add(new Double(0.0));
            return;
        }
        for (i = 0; i < numArgs && typeArgs[i] != null; ++i) {
            PrubaeModelValueStatement ret;
            String type = typeArgs[i] instanceof Pair ? (String)Lisp.car(typeArgs[i]) : (String)typeArgs[i];
            System.err.println("Arguments(" + i + ") = " + type);
            if (type.equals("setnumber")) {
                ret = new PrubaeModelValueStatement();
                ret.setRegist((short)513);
                ret.setComment("");
                ret.setStatement("0");
                ret.setValues(new Vector());
                ret.getValues().add(new Double(0.0));
                ret.setType(typeArgs[i]);
                ret.initialize(this.getEditor(), model, model.getValues());
                ((PrubaeModel)ret).openUI();
                model.getValues().add(ret);
                this.getPanel().add(ret.getController().getPanel());
                continue;
            }
            if (type.equals("setdate")) {
                ret = new PrubaeModelValueStatement();
                ret.setRegist((short)514);
                ret.setComment("");
                ret.setStatement("0/0");
                ret.setValues(new Vector());
                ret.getValues().add(new Short(0));
                ret.getValues().add(new Short(0));
                ret.setType(typeArgs[i]);
                ret.initialize(this.getEditor(), model, model.getValues());
                ((PrubaeModel)ret).openUI();
                model.getValues().add(ret);
                this.getPanel().add(ret.getController().getPanel());
                continue;
            }
            if (type.equals("setstring")) {
                ret = new PrubaeModelValueStatement();
                ret.setRegist((short)516);
                ret.setComment("");
                ret.setStatement("\"\"");
                ret.setValues(new Vector());
                ret.getValues().add("");
                ret.setType(typeArgs[i]);
                ret.initialize(this.getEditor(), model, model.getValues());
                ((PrubaeModel)ret).openUI();
                model.getValues().add(ret);
                this.getPanel().add(ret.getController().getPanel());
                continue;
            }
            if (type.equals("setamount")) {
                ret = new PrubaeModelValueStatement();
                ret.setRegist((short)520);
                ret.setComment("");
                ret.setValues(new Vector());
                ret.getValues().add("");
                ret.getValues().add(new Double(0.0));
                ret.setType(typeArgs[i]);
                ret.initialize(this.getEditor(), model, model.getValues());
                ((PrubaeModel)ret).openUI();
                model.getValues().add(ret);
                this.getPanel().add(ret.getController().getPanel());
                continue;
            }
            if (type.equals("setpath")) continue;
            ret = new PrubaeModelValueStatement();
            ret.setComment("");
            ret.setStatement("");
            ret.setType(typeArgs[i]);
            ret.initialize(this.getEditor(), model, model.getValues());
            ((PrubaeModel)ret).openUI();
            model.getValues().add(ret);
            this.getPanel().add(ret.getController().getPanel());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("select function")) {
            String selected = (String)((JComboBox)e.getSource()).getSelectedItem();
            this.select(selected);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public Object clone() {
        PrubaeControllerJudgeStatement clone = null;
        clone = (PrubaeControllerJudgeStatement)super.clone();
        if (this.getStatementField() != null) {
            clone.setStatementField(new JTextField());
        }
        if (this.getFunctionBox() != null) {
            clone.setFunctionBox(new JComboBox());
            clone.getFunctionBox().setSelectedItem(this.getFunctionBox().getSelectedItem());
        }
        return clone;
    }

    public void setStatementField(JTextField theStatementField) {
        this.statementField = theStatementField;
    }

    public JTextField getStatementField() {
        return this.statementField;
    }

    public void setFunctionBox(JComboBox theFunctionBox) {
        this.functionBox = theFunctionBox;
    }

    public JComboBox getFunctionBox() {
        return this.functionBox;
    }
}

