/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prubae;

import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.math.IntNum;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sourceforge.glj.lisp.Lisp;
import jp.sourceforge.gnp.prubae.PrubaeController;
import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.prubae.PrubaeModelDoStatement;
import jp.sourceforge.gnp.prubae.PrubaeModelJudgeStatement;
import jp.sourceforge.gnp.prubae.PrubaeModelValue;
import jp.sourceforge.gnp.prubae.PrubaeModelValueStatement;

public class PrubaeControllerValueStatement
extends PrubaeController {
    private JTextField statementField;
    private JComboBox functionBox;
    private JPanel numberPanel;
    private JTextField numberField;
    private JPanel datePanel;
    private JTextField monthField;
    private JTextField dayField;
    private JPanel stringPanel;
    private JTextField stringField;
    private JPanel amountPanel;
    private JTextField currencyField;
    private JTextField amountField;
    private JPanel argsCountPanel;
    private JLabel argsCountLabel;
    private JTextField argsCountField;
    private JButton argsCountButton;
    private int argsCount = 0;

    protected void createButtons() {
        this.setStatementField(new JTextField("", 16));
        this.getStatementField().setEditable(false);
        JPanel valuePanel = new JPanel();
        valuePanel.setLayout(new BoxLayout(valuePanel, 0));
        JLabel valueLabel = new JLabel("Value : ");
        valuePanel.add(valueLabel);
        valuePanel.add(this.getStatementField());
        this.getPanel().add(valuePanel);
        this.setFunctionBox(new JComboBox());
        this.getFunctionBox().setMaximumRowCount(4);
        this.getFunctionBox().setActionCommand("select function");
        this.getPanel().add(this.getFunctionBox());
        this.setNumberPanel(new JPanel());
        this.setNumberField(new JTextField("", 4));
        JLabel numberLabel = new JLabel("NUMBER");
        this.getNumberPanel().setLayout(new BoxLayout(this.getNumberPanel(), 0));
        this.getNumberPanel().add(numberLabel);
        this.getNumberPanel().add(this.getNumberField());
        this.getNumberPanel().setVisible(false);
        this.getPanel().add(this.getNumberPanel());
        this.setDatePanel(new JPanel());
        this.setMonthField(new JTextField("", 4));
        this.setDayField(new JTextField("", 4));
        JLabel dateLabel = new JLabel("DATE");
        JLabel date2Label = new JLabel("/");
        this.getDatePanel().setLayout(new BoxLayout(this.getDatePanel(), 0));
        this.getDatePanel().add(dateLabel);
        this.getDatePanel().add(this.getMonthField());
        this.getDatePanel().add(date2Label);
        this.getDatePanel().add(this.getDayField());
        this.getDatePanel().setVisible(false);
        this.getPanel().add(this.getDatePanel());
        this.setStringPanel(new JPanel());
        this.setStringField(new JTextField("", 4));
        JLabel stringLabel = new JLabel("STRING");
        this.getStringPanel().setLayout(new BoxLayout(this.getStringPanel(), 0));
        this.getStringPanel().add(stringLabel);
        this.getStringPanel().add(this.getStringField());
        this.getStringPanel().setVisible(false);
        this.getPanel().add(this.getStringPanel());
        this.setAmountPanel(new JPanel());
        this.setCurrencyField(new JTextField("", 4));
        this.setAmountField(new JTextField("", 4));
        JLabel amountLabel = new JLabel("AMOUNT");
        this.getAmountPanel().setLayout(new BoxLayout(this.getAmountPanel(), 0));
        this.getAmountPanel().add(amountLabel);
        this.getAmountPanel().add(this.getCurrencyField());
        this.getAmountPanel().add(this.getAmountField());
        this.getAmountPanel().setVisible(false);
        this.getPanel().add(this.getAmountPanel());
        this.setArgsCountPanel(new JPanel());
        this.setArgsCountLabel(new JLabel("COUNT"));
        this.setArgsCountField(new JTextField("", 4));
        this.setArgsCountButton(new JButton("INPUT"));
        this.getArgsCountButton().setActionCommand("set args");
        this.getArgsCountButton().addActionListener(this);
        this.getArgsCountPanel().setLayout(new BoxLayout(this.getArgsCountPanel(), 0));
        this.getArgsCountPanel().add(this.argsCountLabel);
        this.getArgsCountPanel().add(this.getArgsCountField());
        this.getArgsCountPanel().add(this.argsCountButton);
        this.getArgsCountPanel().setVisible(false);
        this.getPanel().add(this.getArgsCountPanel());
        this.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 20, 0, 0));
    }

    @Override
    public void initialize() {
    }

    @Override
    public void update() {
        PrubaeModelValueStatement model = (PrubaeModelValueStatement)this.getModel();
        if (this.getNumberPanel().isVisible() && this.getNumberField().isVisible()) {
            double value = 0.0;
            try {
                value = Double.parseDouble(this.getNumberField().getText());
            }
            catch (NumberFormatException e) {
                value = 0.0;
            }
            model.getValues().set(0, new Double(value));
        }
        if (this.getDatePanel().isVisible() && this.getMonthField().isVisible() && this.getDayField().isVisible()) {
            short month = 0;
            try {
                month = Short.parseShort(this.getMonthField().getText());
            }
            catch (NumberFormatException e) {
                month = 0;
            }
            short day = 0;
            try {
                day = Short.parseShort(this.getDayField().getText());
            }
            catch (NumberFormatException e) {
                day = 0;
            }
            model.getValues().set(0, new Short(month));
            model.getValues().set(1, new Short(day));
        }
        if (this.getStringPanel().isVisible() && this.getStringField().isVisible()) {
            String string = this.getStringField().getText();
            model.getValues().set(0, string);
        }
        if (this.getAmountPanel().isVisible() && this.getCurrencyField().isVisible() && this.getAmountField().isVisible()) {
            String currency = this.getCurrencyField().getText();
            double value = 0.0;
            try {
                value = Double.parseDouble(this.getAmountField().getText());
            }
            catch (NumberFormatException e) {
                value = 0.0;
            }
            model.getValues().set(0, currency);
            model.getValues().set(1, new Double(value));
        }
        model.updateStatement();
        super.update();
    }

    @Override
    public void createPanel() {
        super.createPanel();
        this.createButtons();
        PrubaeModelValueStatement model = (PrubaeModelValueStatement)this.getModel();
        if (model.getValues() != null) {
            for (int i = 0; i < model.getValues().size(); ++i) {
                if (!(model.getValues().get(i) instanceof PrubaeModel)) continue;
                PrubaeModel child = (PrubaeModel)model.getValues().get(i);
                if (child.getController() == null) {
                    child.openUI();
                }
                child.getController().createPanel();
            }
        }
        if (this.getFunctionBox().getItemCount() > 0) {
            return;
        }
        LList list = Lisp.append(Lisp.append(Lisp.append(this.getEditor().getValueList(), this.getEditor().getVarList()), this.getEditor().getConstList()), this.getEditor().getSetvarList());
        this.getFunctionBox().addItem("");
        Object requiredType = ((PrubaeModelValue)this.getModel()).getRequiredType();
        if (requiredType == null) {
            requiredType = ((PrubaeModelValue)this.getModel()).getType();
        }
        while (!Lisp.isNil(list)) {
            LList valueList = (LList)Lisp.car(list);
            String itemStr = Lisp.car(Lisp.cdr(valueList)).toString();
            Object type = Lisp.car(Lisp.cdr(Lisp.cdr(valueList)));
            if (this.matchType(requiredType, type)) {
                this.getFunctionBox().addItem(itemStr);
            }
            list = (LList)Lisp.cdr(list);
        }
        this.getFunctionBox().addActionListener(this);
        if (this.getPanel() != null && this.getFunctionBox() != null && !this.getPanel().isAncestorOf(this.getFunctionBox())) {
            this.getPanel().add(this.getFunctionBox());
        }
    }

    @Override
    public void destroyPanel() {
        this.setStatementField(null);
        this.setFunctionBox(null);
        this.setNumberPanel(null);
        this.setNumberField(null);
        this.setDatePanel(null);
        this.setMonthField(null);
        this.setDayField(null);
        this.setStringPanel(null);
        this.setStringField(null);
        this.setAmountPanel(null);
        this.setCurrencyField(null);
        this.setAmountField(null);
        this.setArgsCountPanel(null);
        this.setArgsCountLabel(null);
        this.setArgsCountField(null);
        this.setArgsCountButton(null);
        super.destroyPanel();
    }

    public void removePanel() {
        PrubaeController parentCtl;
        PrubaeModel parent = this.getModel().getParent();
        if (parent instanceof PrubaeModelValue && !(parent instanceof PrubaeModelValueStatement) && (parent.getParent() instanceof PrubaeModelValueStatement || parent.getParent() instanceof PrubaeModelDoStatement || parent.getParent() instanceof PrubaeModelJudgeStatement)) {
            parent = parent.getParent();
        }
        if ((parentCtl = parent.getController()) != null && parentCtl.getPanel() != null && parentCtl.getPanel().isAncestorOf(this.getPanel())) {
            parentCtl.getPanel().remove(this.getPanel());
        }
    }

    protected boolean matchType(Object requiredType, Object valueType) {
        if (requiredType instanceof Pair) {
            LList list = (LList)requiredType;
            while (!Lisp.isNil(list)) {
                String type = (String)Lisp.car(list);
                if (valueType instanceof String && ((String)valueType).startsWith("set") && this.matchTypeRequired(type, ((String)valueType).substring(3))) {
                    return true;
                }
                if (!this.matchTypeRequired(type, valueType)) {
                    return false;
                }
                list = (LList)Lisp.cdr(list);
            }
            return true;
        }
        if (valueType instanceof String && ((String)valueType).startsWith("set") && requiredType instanceof String && this.matchTypeRequired((String)requiredType, ((String)valueType).substring(3))) {
            return true;
        }
        if (requiredType instanceof String) {
            return this.matchTypeRequired((String)requiredType, valueType);
        }
        return true;
    }

    protected boolean matchTypeRequired(String requiredType, Object valueType) {
        if (requiredType.equals("any")) {
            return true;
        }
        if (valueType instanceof Pair) {
            LList list = (LList)valueType;
            while (!Lisp.isNil(list)) {
                String type = (String)Lisp.car(list);
                if (type.equals("any")) {
                    return true;
                }
                if (type.equals(requiredType)) {
                    return true;
                }
                list = (LList)Lisp.cdr(list);
            }
            return false;
        }
        if (requiredType instanceof String) {
            if (valueType.equals("any")) {
                return true;
            }
            return valueType.equals(requiredType);
        }
        return false;
    }

    protected void select(String selected) {
        PrubaeModelValueStatement model = (PrubaeModelValueStatement)this.getModel();
        model.updateStatement();
        LList list = Lisp.append(Lisp.append(this.getEditor().getValueList(), this.getEditor().getVarList()), this.getEditor().getConstList());
        while (!Lisp.isNil(list)) {
            LList valueList = (LList)Lisp.car(list);
            String itemStr = Lisp.car(Lisp.cdr(valueList)).toString();
            if (selected.equals(itemStr)) {
                short regist = (short)((IntNum)Lisp.car(valueList)).intValue();
                Object type = Lisp.car(Lisp.cdr(Lisp.cdr(valueList)));
                if (model.getRegist() == regist) break;
                if (model.getValues() != null) {
                    for (int i = 0; i < model.getValues().size(); ++i) {
                        if (!(model.getValues().get(i) instanceof PrubaeModel)) continue;
                        ((PrubaeModel)model.getValues().get(i)).closeUI();
                    }
                    model.getValues().clear();
                }
                this.setArgsCount(0);
                model.setRegist(regist);
                if (type.equals("any")) {
                    type = null;
                } else if (type instanceof String && ((String)type).length() > 3 && ((String)type).substring(0, 3).equals("set")) {
                    type = ((String)type).substring(3);
                }
                if (type != null) {
                    model.setType(type);
                }
                PrubaeModel parent = model.getParent();
                if (type != null && parent instanceof PrubaeModelValue && ((PrubaeModelValue)parent).getType() == null && ((PrubaeModelValue)parent).getValues().get(0) == model) {
                    ((PrubaeModelValue)parent).setType(type);
                }
                this.constset(type);
                this.getEditor().refresh();
                model.updateStatement();
                break;
            }
            list = (LList)Lisp.cdr(list);
        }
    }

    private void constset(Object type) {
        PrubaeModelValueStatement model = (PrubaeModelValueStatement)this.getModel();
        this.getNumberPanel().setVisible(false);
        this.getDatePanel().setVisible(false);
        this.getStringPanel().setVisible(false);
        this.getAmountPanel().setVisible(false);
        if (type == null || type instanceof LList) {
            return;
        }
        if (type.equals("setnumber")) {
            if (model.getValues() == null) {
                model.setValues(new Vector());
            }
            model.getValues().add(new Double(0.0));
            this.getNumberPanel().setVisible(true);
        } else if (type.equals("setdate")) {
            if (model.getValues() == null) {
                model.setValues(new Vector());
            }
            model.getValues().add(new Short(0));
            model.getValues().add(new Short(0));
            this.getDatePanel().setVisible(true);
        } else if (type.equals("setstring")) {
            if (model.getValues() == null) {
                model.setValues(new Vector());
            }
            model.getValues().add("");
            this.getStringPanel().setVisible(true);
        } else if (type.equals("setamount")) {
            if (model.getValues() == null) {
                model.setValues(new Vector());
            }
            model.getValues().add("");
            model.getValues().add(new Double(0.0));
            this.getAmountPanel().setVisible(true);
        } else if (type.equals("number")) {
            if (model.getValues() == null) {
                model.setValues(new Vector());
            }
            model.getValues().add(new Double(0.0));
            this.getNumberPanel().setVisible(true);
        } else if (type.equals("date")) {
            if (model.getValues() == null) {
                model.setValues(new Vector());
            }
            model.getValues().add(new Short(0));
            model.getValues().add(new Short(0));
            this.getDatePanel().setVisible(true);
        } else if (type.equals("string")) {
            if (model.getValues() == null) {
                model.setValues(new Vector());
            }
            model.getValues().add("");
            this.getStringPanel().setVisible(true);
        } else if (type.equals("amount")) {
            if (model.getValues() == null) {
                model.setValues(new Vector());
            }
            model.getValues().add("");
            model.getValues().add(new Double(0.0));
            this.getAmountPanel().setVisible(true);
        }
    }

    int arguments(LList valueList) {
        Object isArgs = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList))));
        int numArgs = 0;
        int oldArgsCount = this.getArgsCount();
        numArgs = isArgs == null ? 0 : (!(isArgs instanceof IntNum) ? 0 : ((IntNum)isArgs).intValue());
        if (numArgs < 0) {
            System.err.println("numArgs -1 :" + Lisp.car(Lisp.cdr(valueList)));
            this.getArgsCountPanel().setVisible(true);
            numArgs = this.getArgsCount();
        } else {
            this.setArgsCount(0);
            this.getArgsCountPanel().setVisible(false);
        }
        if (numArgs > oldArgsCount) {
            this.addArguments(valueList, oldArgsCount, numArgs);
        } else if (numArgs < oldArgsCount) {
            this.removeArguments(valueList, numArgs, oldArgsCount);
        }
        return numArgs;
    }

    private void addArguments(LList valueList, int minArgs, int numArgs) {
        int i;
        PrubaeModelValueStatement model = (PrubaeModelValueStatement)this.getModel();
        Object listArgs = Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList))));
        Object[] typeArgs = new Object[numArgs];
        for (i = minArgs; i < numArgs; ++i) {
            typeArgs[i] = Lisp.car(listArgs);
            listArgs = Lisp.cdr(listArgs);
        }
        if (model.getValues() == null) {
            model.setValues(new Vector());
        }
        for (i = minArgs; i < numArgs; ++i) {
            PrubaeModelValueStatement ret;
            String type = typeArgs[i] == null ? "any" : (typeArgs[i] instanceof Pair ? (String)Lisp.car(typeArgs[i]) : (String)typeArgs[i]);
            System.err.println("Arguments(" + i + ") = " + type);
            if (type.equals("setnumber")) {
                ret = new PrubaeModelValueStatement();
                ret.setRegist((short)513);
                ret.setComment("");
                ret.setStatement("0");
                ret.getValues().add(new Double(0.0));
                ret.setType(typeArgs[i]);
                ret.initialize(this.getEditor(), model, model.getValues());
                ((PrubaeModel)ret).openUI();
                model.getValues().add(ret);
                continue;
            }
            if (type.equals("setdate")) {
                ret = new PrubaeModelValueStatement();
                ret.setRegist((short)514);
                ret.setComment("");
                ret.setStatement("0/0");
                ret.getValues().add(new Short(0));
                ret.getValues().add(new Short(0));
                ret.setType(typeArgs[i]);
                ret.initialize(this.getEditor(), model, model.getValues());
                ((PrubaeModel)ret).openUI();
                model.getValues().add(ret);
                continue;
            }
            if (type.equals("setstring")) {
                ret = new PrubaeModelValueStatement();
                ret.setRegist((short)516);
                ret.setComment("");
                ret.setStatement("\"\"");
                ret.getValues().add("");
                ret.setType(typeArgs[i]);
                ret.initialize(this.getEditor(), model, model.getValues());
                ((PrubaeModel)ret).openUI();
                model.getValues().add(ret);
                continue;
            }
            if (type.equals("setamount")) {
                ret = new PrubaeModelValueStatement();
                ret.setRegist((short)520);
                ret.setComment("");
                ret.getValues().add("");
                ret.getValues().add(new Double(0.0));
                ret.setType(typeArgs[i]);
                ret.initialize(this.getEditor(), model, model.getValues());
                ((PrubaeModel)ret).openUI();
                model.getValues().add(ret);
                continue;
            }
            ret = new PrubaeModelValueStatement();
            ret.setComment("");
            ret.setStatement("");
            ret.setType(typeArgs[i]);
            ret.initialize(this.getEditor(), model, model.getValues());
            ret.initialize(this.getEditor(), model, model.getValues());
            ((PrubaeModel)ret).openUI();
            ((PrubaeControllerValueStatement)ret.getController()).constset(type);
            model.getValues().add(ret);
        }
    }

    private void updateArgsCount() {
        PrubaeModelValueStatement model = (PrubaeModelValueStatement)this.getModel();
        model.updateStatement();
        LList list = Lisp.append(Lisp.append(this.getEditor().getValueList(), this.getEditor().getVarList()), this.getEditor().getConstList());
        LList valueList = Lisp.assoc(new IntNum((int)model.getRegist()), list);
        if (valueList == null) {
            return;
        }
        Object isArgs = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList))));
        if (isArgs == null) {
            return;
        }
        if (!(isArgs instanceof IntNum)) {
            return;
        }
        int numArgs = ((IntNum)isArgs).intValue();
        if (numArgs >= 0) {
            return;
        }
        try {
            numArgs = Integer.parseInt(this.getArgsCountField().getText());
        }
        catch (NumberFormatException e) {
            return;
        }
        int oldArgsCount = this.getArgsCount();
        this.setArgsCount(numArgs);
        if (numArgs > oldArgsCount) {
            this.addArguments(valueList, oldArgsCount, numArgs);
            this.getEditor().refresh();
        } else if (numArgs < oldArgsCount) {
            this.removeArguments(valueList, numArgs, oldArgsCount);
            this.getEditor().refresh();
        }
    }

    private void removeArguments(LList valueList, int minArgs, int numArgs) {
        PrubaeModelValueStatement model = (PrubaeModelValueStatement)this.getModel();
        for (int i = numArgs - 1; i >= minArgs; --i) {
            PrubaeModelValue ret = (PrubaeModelValue)model.getValues().get(i);
            this.getPanel().remove(ret.getController().getPanel());
            ret.closeUI();
            model.getValues().remove(ret);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("select function")) {
            String selected = (String)((JComboBox)e.getSource()).getSelectedItem();
            this.select(selected);
        } else if (e.getActionCommand().equals("set args")) {
            this.updateArgsCount();
        }
    }

    @Override
    public Object clone() {
        PrubaeControllerValueStatement clone = null;
        clone = (PrubaeControllerValueStatement)super.clone();
        if (this.getStatementField() != null) {
            clone.setStatementField(new JTextField());
        }
        if (this.getFunctionBox() != null) {
            clone.setFunctionBox(new JComboBox());
            clone.getFunctionBox().setSelectedItem(this.getFunctionBox().getSelectedItem());
        }
        if (this.getNumberPanel() != null) {
            clone.setNumberPanel(new JPanel());
        }
        if (this.getNumberField() != null) {
            clone.setNumberField(new JTextField());
        }
        if (this.getDatePanel() != null) {
            clone.setDatePanel(new JPanel());
        }
        if (this.getMonthField() != null) {
            clone.setMonthField(new JTextField());
        }
        if (this.getDayField() != null) {
            clone.setDayField(new JTextField());
        }
        if (this.getStringPanel() != null) {
            clone.setStringPanel(new JPanel());
        }
        if (this.getStringField() != null) {
            clone.setStringField(new JTextField());
        }
        if (this.getAmountPanel() != null) {
            clone.setAmountPanel(new JPanel());
        }
        if (this.getCurrencyField() != null) {
            clone.setCurrencyField(new JTextField());
        }
        if (this.getAmountField() != null) {
            clone.setAmountField(new JTextField());
        }
        if (this.getArgsCountPanel() != null) {
            clone.setArgsCountPanel(new JPanel());
        }
        if (this.getArgsCountField() != null) {
            clone.setArgsCountField(new JTextField());
        }
        return clone;
    }

    public void setStatementField(JTextField theStatementField) {
        this.statementField = theStatementField;
    }

    public JTextField getStatementField() {
        return this.statementField;
    }

    public void setFunctionBox(JComboBox theFunctionBox) {
        this.functionBox = theFunctionBox;
    }

    public JComboBox getFunctionBox() {
        return this.functionBox;
    }

    public void setNumberPanel(JPanel theNumberPanel) {
        this.numberPanel = theNumberPanel;
    }

    public JPanel getNumberPanel() {
        return this.numberPanel;
    }

    public void setNumberField(JTextField theNumberField) {
        this.numberField = theNumberField;
    }

    public JTextField getNumberField() {
        return this.numberField;
    }

    public void setDatePanel(JPanel theDatePanel) {
        this.datePanel = theDatePanel;
    }

    public JPanel getDatePanel() {
        return this.datePanel;
    }

    public void setMonthField(JTextField theMonthField) {
        this.monthField = theMonthField;
    }

    public JTextField getMonthField() {
        return this.monthField;
    }

    public void setDayField(JTextField theDayField) {
        this.dayField = theDayField;
    }

    public JTextField getDayField() {
        return this.dayField;
    }

    public void setStringPanel(JPanel theStringPanel) {
        this.stringPanel = theStringPanel;
    }

    public JPanel getStringPanel() {
        return this.stringPanel;
    }

    public void setStringField(JTextField theStringField) {
        this.stringField = theStringField;
    }

    public JTextField getStringField() {
        return this.stringField;
    }

    public void setAmountPanel(JPanel theAmountPanel) {
        this.amountPanel = theAmountPanel;
    }

    public JPanel getAmountPanel() {
        return this.amountPanel;
    }

    public void setCurrencyField(JTextField theCurrencyField) {
        this.currencyField = theCurrencyField;
    }

    public JTextField getCurrencyField() {
        return this.currencyField;
    }

    public void setAmountField(JTextField theAmountField) {
        this.amountField = theAmountField;
    }

    public JTextField getAmountField() {
        return this.amountField;
    }

    public void setArgsCountPanel(JPanel theArgsCountPanel) {
        this.argsCountPanel = theArgsCountPanel;
    }

    public JPanel getArgsCountPanel() {
        return this.argsCountPanel;
    }

    public void setArgsCountLabel(JLabel theArgsCountLabel) {
        this.argsCountLabel = theArgsCountLabel;
    }

    public JLabel getArgsCountLabel() {
        return this.argsCountLabel;
    }

    public void setArgsCountField(JTextField theArgsCountField) {
        this.argsCountField = theArgsCountField;
    }

    public JTextField getArgsCountField() {
        return this.argsCountField;
    }

    public void setArgsCountButton(JButton theArgsCountButton) {
        this.argsCountButton = theArgsCountButton;
    }

    public JButton getArgsCountButton() {
        return this.argsCountButton;
    }

    public void setArgsCount(int theArgsCount) {
        this.argsCount = theArgsCount;
    }

    public int getArgsCount() {
        return this.argsCount;
    }
}

