/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.rulebase.xml;

import java.util.Date;

class RuleElement {
    String rule;
    String name;
    String type;
    String carrier;
    String tkCarrier;
    Date dateFrom;
    Date dateUntil;
    String filename;

    RuleElement() {
    }

    RuleElement(String rule, String name, String type, String carrier, String tkCarrier, Date dateFrom, Date dateUntil, String filename) {
        this.rule = rule;
        this.name = name;
        this.type = type;
        this.carrier = carrier;
        this.tkCarrier = tkCarrier;
        this.dateFrom = dateFrom;
        this.dateUntil = dateUntil;
        this.filename = filename;
    }

    boolean match(String rule, String name, String carrier, String tkCarrier, Date date) {
        if (!this.match(rule, name, carrier, tkCarrier)) {
            return false;
        }
        return date != null && !date.before(this.dateFrom) && !date.after(this.dateUntil);
    }

    boolean match(String rule, String name, String carrier, String tkCarrier) {
        if (!this.rule.equals(rule)) {
            return false;
        }
        if (name != null && !name.equals("") && !this.name.equals(name)) {
            return false;
        }
        if (carrier != null && !carrier.equals("") && !this.carrier.equals(carrier)) {
            return false;
        }
        return tkCarrier == null || tkCarrier.equals("") || this.tkCarrier.equals(tkCarrier);
    }

    int compareTo(RuleElement other) {
        if (!this.rule.equals(other.rule)) {
            return this.rule.compareTo(other.rule);
        }
        if (this.name != null && !this.name.equals("") && !this.name.equals(other.name)) {
            return this.name.compareTo(other.name);
        }
        if (this.carrier != null && !this.carrier.equals("") && !this.carrier.equals(other.carrier)) {
            return this.carrier.compareTo(other.carrier);
        }
        if (this.tkCarrier != null && !this.tkCarrier.equals("") && !this.tkCarrier.equals(other.tkCarrier)) {
            return this.tkCarrier.compareTo(other.tkCarrier);
        }
        return 0;
    }
}

