/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.Inlineable;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SetExp;
import gnu.kawa.reflect.Invoke;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.WrongArguments;

public class InlineCalls
extends ExpWalker {
    public static void inlineCalls(Expression expression, Compilation compilation) {
        InlineCalls inlineCalls = new InlineCalls();
        inlineCalls.setContext(compilation);
        inlineCalls.walk(expression);
    }

    Expression rewriteToInvocation(Symbol symbol, ApplyExp applyExp) {
        Invoke invoke;
        String string;
        Expression[] expressionArray = applyExp.args;
        String string2 = symbol.getNamespaceURI();
        if (string2 == null || !string2.startsWith("class:")) {
            return null;
        }
        String string3 = string2.substring(6);
        String string4 = symbol.getName();
        ClassType classType = ClassType.make("gnu.kawa.reflect.Invoke");
        boolean bl = string4.equals("new");
        if (bl) {
            string = "make";
            invoke = Invoke.make;
        } else {
            string = "invokeStatic";
            invoke = Invoke.invokeStatic;
        }
        Field field = classType.getDeclaredField(string);
        Declaration declaration = new Declaration((Object)"invoke", field);
        declaration.noteValue(new QuoteExp(invoke));
        declaration.setFlag(16384);
        Expression[] expressionArray2 = new Expression[expressionArray.length + (bl ? 1 : 2)];
        System.arraycopy(expressionArray, 0, expressionArray2, bl ? 1 : 2, expressionArray.length);
        expressionArray2[0] = new QuoteExp(string3);
        if (!bl) {
            expressionArray2[1] = new QuoteExp(string4);
        }
        expressionArray = expressionArray2;
        ApplyExp applyExp2 = new ApplyExp(new ReferenceExp(declaration), expressionArray);
        applyExp2.setLine(applyExp);
        return invoke.inline(applyExp2, this);
    }

    protected Expression walkApplyExp(ApplyExp applyExp) {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        super.walkApplyExp(applyExp);
        LambdaExp lambdaExp = null;
        int n = applyExp.getArgCount();
        if (applyExp.func instanceof LambdaExp) {
            lambdaExp = (LambdaExp)applyExp.func;
        }
        Expression expression = applyExp.func;
        Declaration declaration = null;
        if (expression instanceof ReferenceExp) {
            object5 = (ReferenceExp)expression;
            declaration = ((ReferenceExp)object5).binding;
            if (declaration != null && !declaration.getFlag(65536)) {
                if ((declaration = Declaration.followAliases(declaration)).isIndirectBinding()) {
                    return applyExp;
                }
                expression = declaration.getValue();
                if (expression instanceof LambdaExp) {
                    lambdaExp = (LambdaExp)expression;
                }
            } else if (((ReferenceExp)object5).getSymbol() instanceof Symbol) {
                object4 = (Symbol)((ReferenceExp)object5).getSymbol();
                object3 = this.rewriteToInvocation((Symbol)object4, applyExp);
                if (object3 != null) {
                    return object3;
                }
                object2 = ((Symbol)object4).getFunctionValue(null);
                if (object2 instanceof Procedure) {
                    expression = new QuoteExp(object2);
                }
                declaration = null;
            }
        }
        if (expression instanceof QuoteExp) {
            object5 = ((QuoteExp)expression).getValue();
            if (!(object5 instanceof Procedure)) {
                return this.noteError(declaration == null ? "called value is not a procedure" : "calling " + declaration.getName() + " which is not a procedure");
            }
            object4 = (Procedure)object5;
            object3 = WrongArguments.checkArgCount((Procedure)object4, n);
            if (object3 != null) {
                return this.noteError((String)object3);
            }
            if (object4 instanceof CanInline) {
                return ((CanInline)object4).inline(applyExp, this);
            }
            if (this.comp.inlineOk((Procedure)object4)) {
                if (object4 instanceof Inlineable) {
                    return new ApplyExp((Procedure)object4, applyExp.getArgs());
                }
                object2 = PrimProcedure.getMethodFor((Procedure)object4, declaration, applyExp.args, this.comp.getInterpreter());
                if (object2 != null) {
                    ApplyExp applyExp2;
                    if (((PrimProcedure)object2).getStaticFlag() || declaration == null) {
                        applyExp2 = new ApplyExp((Procedure)object2, applyExp.args);
                    } else {
                        Expression[] expressionArray = new Expression[1 + n];
                        System.arraycopy(applyExp.getArgs(), 0, expressionArray, 1, n);
                        expressionArray[0] = new ReferenceExp(declaration.base);
                        applyExp2 = new ApplyExp((Procedure)object2, expressionArray);
                    }
                    return applyExp2.setLine(applyExp);
                }
            }
        }
        if (lambdaExp != null) {
            int n2 = applyExp.args.length;
            object4 = WrongArguments.checkArgCount(lambdaExp.getName(), lambdaExp.min_args, lambdaExp.max_args, n2);
            if (object4 != null) {
                return this.noteError((String)object4);
            }
        }
        return applyExp;
    }

    protected Expression walkIfExp(IfExp ifExp) {
        ifExp.walkChildren(this);
        Expression expression = ifExp.test;
        if (expression instanceof QuoteExp) {
            Interpreter interpreter = this.comp.getInterpreter();
            if (interpreter.isTrue(((QuoteExp)expression).getValue())) {
                return ifExp.then_clause;
            }
            return ifExp.else_clause;
        }
        return ifExp;
    }

    protected Expression walkSetExp(SetExp setExp) {
        Expression expression;
        Declaration declaration = setExp.binding;
        boolean bl = false;
        if (declaration != null && (expression = declaration.getValue()) == setExp.new_value) {
            bl = true;
        }
        setExp.walkChildren(this);
        if (bl) {
            declaration.value = setExp.new_value;
            if (setExp.new_value instanceof LambdaExp) {
                ((LambdaExp)setExp.new_value).nameDecl = declaration;
            }
        }
        return setExp;
    }

    protected Expression walkClassExp(ClassExp classExp) {
        classExp.getCompiledClassType(this.comp);
        this.comp.addClass(classExp.type);
        if (classExp.isMakingClassPair()) {
            classExp.instanceType.setName(classExp.type.getName() + "$class");
            this.comp.addClass(classExp.instanceType);
        }
        return super.walkClassExp(classExp);
    }
}

