/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.EFrame;
import gnu.mapping.WrappedException;
import java.awt.Color;

public abstract class EToolkit {
    public static String defaultToolkit = "gnu.jemacs.swing.SwingToolkit";
    static EToolkit instance;
    static Class toolkitClass;

    public static EToolkit getInstance() {
        EToolkit inst = instance;
        if (inst != null) {
            return inst;
        }
        return EToolkit.getInstance(defaultToolkit);
    }

    public static synchronized EToolkit getInstance(String toolkitClassname) {
        if (instance == null) {
            try {
                if (toolkitClass == null) {
                    toolkitClass = Class.forName(toolkitClassname);
                }
                instance = (EToolkit)toolkitClass.newInstance();
            }
            catch (Exception ex) {
                throw new WrappedException(ex);
            }
        }
        return instance;
    }

    public abstract Buffer newBuffer(String var1);

    public abstract EFrame newFrame(Buffer var1);

    public abstract Object getFace(String var1, boolean var2);

    public void setUnderline(Object face, boolean underline) {
    }

    public void setBold(Object face, boolean bold) {
    }

    public void setForeground(Object face, Color foreground) {
    }

    public void setBackground(Object face, Color background) {
    }
}

