/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.expr.Interpreter;
import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.BufferWriter;
import gnu.jemacs.buffer.Marker;
import gnu.jemacs.buffer.ProcessMode;
import gnu.mapping.Environment;
import gnu.mapping.Future;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.TtyInPort;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Writer;
import kawa.repl;

public class ReplMode
extends ProcessMode {
    BufferWriter processWriter;
    InPort in;
    OutPort out;
    OutPort err;
    Future thread;

    public ReplMode(Buffer buffer, Interpreter interp, Environment environment) throws IOException {
        this.lineMode = true;
        this.buffer = buffer;
        this.processMark = new Marker(buffer.pointMarker);
        this.processWriter = new BufferWriter(this.processMark, true);
        this.out = new OutPort((Writer)this.processWriter, true, true);
        this.err = new OutPort((Writer)this.processWriter, true, true);
        PipedReader preader = new PipedReader();
        this.toInferior = new PipedWriter(preader);
        this.in = new TtyInPort(preader, "<stdin>", this.out);
        this.thread = new Future(new repl(interp), environment, this.in, this.out, this.err);
        this.thread.setPriority(Thread.currentThread().getPriority() + 1);
        this.thread.start();
    }

    public static void make(Buffer buffer, String language) throws IOException {
        ReplMode.make(buffer, Interpreter.getInstance(language));
    }

    public static void make(Buffer buffer, Interpreter interpreter) throws IOException {
        buffer.modes = new ReplMode(buffer, interpreter, Environment.getCurrent());
    }
}

