/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.sax;

import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.SeqPosition;
import gnu.mapping.Symbol;
import gnu.text.Char;
import gnu.xml.XName;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ContentConsumer
implements Consumer,
Attributes {
    ContentHandler out;
    int nesting = 0;
    String[] names = new String[15];
    int numAttributes;
    String[] attributes = new String[20];
    char[] chBuffer;
    StringBuffer strBuffer = new StringBuffer(200);
    int inStartTag;

    public ContentConsumer() {
    }

    public ContentConsumer(ContentHandler handler) {
        this.out = handler;
    }

    public void error(String method, SAXException ex) {
        throw new RuntimeException("caught " + ex + " in " + method);
    }

    public int getLength() {
        return this.numAttributes;
    }

    public String getQName(int i) {
        return i >= this.numAttributes ? null : this.attributes[4 * i];
    }

    public String getURI(int i) {
        return i >= this.numAttributes ? null : this.attributes[4 * i + 1];
    }

    public String getLocalName(int i) {
        return i >= this.numAttributes ? null : this.attributes[4 * i + 2];
    }

    public String getValue(int i) {
        return i >= this.numAttributes ? null : this.attributes[4 * i + 3];
    }

    public String getType(int i) {
        return i >= this.numAttributes ? null : "CDATA";
    }

    public int getIndex(String uri, String localPart) {
        int i = this.numAttributes;
        while (--i >= 0) {
            if (!uri.equals(this.attributes[4 * i + 1]) || !localPart.equals(this.attributes[4 * i + 2])) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(String qName) {
        int i = this.numAttributes;
        while (--i >= 0) {
            if (!qName.equals(this.attributes[4 * i])) continue;
            return i;
        }
        return -1;
    }

    public String getType(String uri, String localPart) {
        int i = this.getIndex(uri, localPart);
        return i < 0 ? null : "CDATA";
    }

    public String getType(String qName) {
        int i = this.getIndex(qName);
        return i < 0 ? null : "CDATA";
    }

    public String getValue(String uri, String localPart) {
        int i = this.getIndex(uri, localPart);
        return i < 0 ? null : this.attributes[4 * i + 3];
    }

    public String getValue(String qName) {
        int i = this.getIndex(qName);
        return i < 0 ? null : this.attributes[4 * i + 3];
    }

    void endStartTag() {
        if (this.inStartTag != 1) {
            return;
        }
        int i = 3 * (this.nesting - 1);
        try {
            this.out.startElement(this.names[i], this.names[i + 1], this.names[i + 2], this);
        }
        catch (SAXException ex) {
            this.error("startElement", ex);
        }
        i = 4 * this.numAttributes;
        while (--i >= 0) {
            this.attributes[i] = null;
        }
        this.numAttributes = 0;
        this.inStartTag = 0;
    }

    public void beginGroup(String typeName, Object type) {
        String localName;
        String namespaceURI;
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.flushStrBuffer();
        int i = 3 * this.nesting;
        if (i >= this.names.length) {
            String[] tmp = new String[2 * i];
            System.arraycopy(this.names, 0, tmp, 0, i);
            this.names = tmp;
        }
        if (type instanceof Symbol) {
            Symbol sym = (Symbol)type;
            namespaceURI = sym.getNamespaceURI();
            localName = sym.getLocalName();
        } else if (type instanceof XName) {
            XName sym = (XName)type;
            namespaceURI = sym.getNamespaceURI();
            localName = sym.getLocalName();
        } else {
            namespaceURI = "";
            localName = type.toString();
        }
        this.names[i] = namespaceURI;
        this.names[i + 1] = localName;
        this.names[i + 2] = typeName;
        this.numAttributes = 0;
        this.inStartTag = 1;
        ++this.nesting;
    }

    public void beginAttribute(String attrName, Object attrType) {
        int i = 4 * this.numAttributes;
        if (i >= this.attributes.length) {
            String[] tmp = new String[2 * i];
            System.arraycopy(this.attributes, 0, tmp, 0, i);
            this.attributes = tmp;
        }
        String namespaceURI = ((Symbol)attrType).getNamespaceURI();
        String localName = ((Symbol)attrType).getLocalName();
        this.attributes[i] = attrName;
        this.attributes[i + 1] = namespaceURI;
        this.attributes[i + 2] = localName;
        ++this.numAttributes;
        this.inStartTag = 2;
    }

    public void endAttribute() {
        this.attributes[4 * this.numAttributes - 1] = this.strBuffer.toString();
        this.strBuffer.setLength(0);
        this.inStartTag = 1;
    }

    public void beginDocument() {
        try {
            this.out.startDocument();
        }
        catch (SAXException ex) {
            this.error("beginDocument", ex);
        }
    }

    public void endDocument() {
        try {
            this.out.endDocument();
        }
        catch (SAXException ex) {
            this.error("endDocument", ex);
        }
    }

    public void endGroup(String typeName) {
        this.endStartTag();
        this.flushStrBuffer();
        --this.nesting;
        int i = 3 * this.nesting;
        try {
            this.out.endElement(this.names[i], this.names[i + 1], this.names[i + 2]);
        }
        catch (SAXException ex) {
            this.error("endElement", ex);
        }
        this.names[i] = null;
        this.names[i + 1] = null;
        this.names[i + 2] = null;
    }

    void flushStrBuffer() {
        if (this.strBuffer.length() > 0) {
            if (this.chBuffer == null) {
                this.chBuffer = new char[200];
            }
            try {
                int len;
                int slen = this.strBuffer.length();
                int start = 0;
                while ((len = slen - start) > 0) {
                    if (len > this.chBuffer.length) {
                        len = this.chBuffer.length;
                    }
                    this.strBuffer.getChars(start, start + len, this.chBuffer, start);
                    this.out.characters(this.chBuffer, 0, len);
                    start += len;
                }
                this.strBuffer.setLength(0);
            }
            catch (SAXException ex) {
                this.error("characters", ex);
            }
        }
    }

    public void write(char[] buf, int off, int len) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        if (this.inStartTag == 2) {
            this.strBuffer.append(buf, off, len);
        } else {
            this.flushStrBuffer();
            try {
                this.out.characters(buf, off, len);
            }
            catch (SAXException ex) {
                this.error("characters", ex);
            }
        }
    }

    public void writeChar(int v) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append((char)v);
    }

    public void writeChars(String v) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(v);
    }

    public void writeObject(Object v) {
        if (v instanceof Consumable) {
            ((Consumable)v).consume(this);
        } else if (v instanceof SeqPosition) {
            SeqPosition pos = (SeqPosition)v;
            pos.sequence.consumeNext(pos.ipos, this);
        } else if (v instanceof Char) {
            this.writeChar(((Char)v).intValue());
        } else {
            this.writeChars(v == null ? "(null)" : v.toString());
        }
    }

    public void writeBoolean(boolean v) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(v);
    }

    public void writeLong(long v) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(v);
    }

    public void writeInt(int v) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(v);
    }

    public void writeFloat(float v) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(v);
    }

    public void writeDouble(double v) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(v);
    }

    public void finalize() {
        this.flushStrBuffer();
    }

    public boolean ignoring() {
        return false;
    }

    public void setContentHandler(ContentHandler handler) {
        this.out = handler;
    }

    public ContentHandler getContentHandler() {
        return this.out;
    }
}

