#------------------------------------------------------------------------------
#    59Tracker, weblog software for personal publisher.
#    Copyright (C) 2004-2009 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

package Lib::Calendar;

use strict;
use warnings;

use Time::Local;

# コンストラクタ
sub new {
    my $self = {};

    use Lib::App::Conf;
    my $conf = Lib::App::Conf->new();

    $self->{data_dir} = $conf->get_data_dir(); # データディレクトリ

    bless($self);
    return $self;
}

# カレンダーの取得(HTML)
sub get_calendar {
    my $self = shift;
    my ($year, $month) = @_;
    my @daylist = ();
    my $datadir = $self->{data_dir};

    # アーカイブデータをもとに投稿日の一覧を取得
    my $archivefile = "$datadir/$year$month" . "ar.data";
    if (-f $archivefile) { # ファイルが存在する場合
        my $olddate = '';
        open my $archivefh, '<', $archivefile;
        while (my $data = <$archivefh>) {
            chomp($data);   # 改行を取り除く
            if ($data ne '') {
                my ($topicid, $lastdate) = split(/\,/, $data);
                my $curdate = substr($lastdate, 0, 10);
                if ($curdate ne $olddate) {
                    my $day = substr($curdate, 8, 2);
                    push @daylist, $day;
                    $olddate = $curdate;
                }
            }
        }
        close $archivefh;
    }

    my @MONTHS = (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
    # 閏年の調整
    if ($year % 4 == 0) {
        $MONTHS[1] = 29;
        if (($year % 400 != 0) && ($year % 100 == 0)) {
            $MONTHS[1]  = 28;
        }
    }

    my $prevyear = $year;
    my $prevmon = $month - 1;
    if ($prevmon < 1) {
        $prevmon = 12;
        $prevyear--;
    }
    $prevmon = sprintf("%2.2d", $prevmon);

    my $nextyear = $year;
    my $nextmon = $month + 1;
    if ($nextmon > 12) {
        $nextmon = 1;
        $nextyear++;
    }
    $nextmon = sprintf("%2.2d", $nextmon);

    # 前月のアーカイブデータファイルの存在チェック
    $archivefile = "$datadir/$prevyear$prevmon" . "ar.data";
    my $prevnavi = '';
    if (-f $archivefile) {
        $prevnavi = "<a href=\"./?date=$prevyear$prevmon\">&lt;&lt;</a>";
    }
    # 次月のアーカイブデータファイルの存在チェック
    $archivefile = "$datadir/$nextyear$nextmon" . "ar.data";
    my $nextnavi = '';
    if (-f $archivefile) {
        $nextnavi = "<a href=\"./?date=$nextyear$nextmon\">&gt;&gt;</a>";
    }

    my $caltable = <<"END_TABLE";
<table border="0" width="160" cellpadding="3" cellspacing="0">
<tr>
    <td align="center">$prevnavi</td>
    <td colspan="5" align="center"><b><a href=\"./?date=$year$month\">$year年$month月</a></b></td>
    <td align="center">$nextnavi</td>
</tr>
<tr>
    <td align="center"><font color="red">日</font></td>
    <td align="center">月</td>
    <td align="center">火</td>
    <td align="center">水</td>
    <td align="center">木</td>
    <td align="center">金</td>
    <td align="center"><font color="blue">土</font></td>
</tr>
END_TABLE

    my ($startwday) = (localtime(timelocal(0, 0, 0, 1, $month - 1, $year - 1900)))[6]; # その月の1日の曜日
    my $weekofday = 0;
    my $firstweek = 1;
    my $enddate = $MONTHS[$month - 1];

    $caltable .= "<tr>";
    for my $date (1..$enddate) {

        # 土曜日が終わったら折り返し
        if ($weekofday == 7) {
            $caltable .= "</tr><tr>";
            $weekofday = 0;
        }

        # 第一週の調整
        if ($startwday > 0 && $firstweek == 1) {
            for (; $weekofday < $startwday; $weekofday++) {
                $caltable .= "<td> </td>";
            }
            $firstweek = 0;
        }

        my $notfound = 1;
        foreach my $day (@daylist) {
            if ($day == $date) {
                $notfound = 0;
            }
        }
        if (!$notfound) {
            my $dd = $date;
            if ($dd < 10) {
                $dd = "0$dd";
            }
            $caltable .= "<td align=\"right\"><a href=\"./?date=$year$month$dd\">$date</a></td>";
        }
        else {
            $caltable .= "<td align=\"right\">$date</td>";
        }

        # 最後の週の調整
        if ($date == $enddate) {
            for (; $weekofday < 7; $weekofday++) {
                $caltable .= "<td> </td>";
            }
        }

        $weekofday++;
    }
    $caltable .= "</tr></table>";

    return $caltable;
}

1;
# End of Lib::Calendar.pm
