#------------------------------------------------------------------------------
#    59Tracker, weblog software for personal publisher.
#    Copyright (C) 2004-2009 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

package Lib::Error;

use strict;
use warnings;

use Lib::Logger;

my $logger = Lib::Logger->new();

# メッセージ表
my %messgaetbl = (
    '00001e' => "システムエラーが発生しました",
    '00002e' => "パラメーターが不正です",
    '00003e' => "セッションが無効です",
    '00004e' => "処理を実行する権限がありません",
    '10000e' => "コメントが未入力です",
    '10001e' => "投稿が拒否されました",
    '10002e' => "メールアドレスに誤りがあります",
    '10003e' => "URLに誤りがあります",
    '99999e' => "未定義のエラーが発生しました",
);

# コンストラクタ
sub new {
  my $self = {};
  bless($self);
  return $self;
}

# エラーメッセージを表示してプログラムを終了する
sub print_error {
    my $self = shift;
    my $code = shift; # メッセージコード

    my $message = $messgaetbl{$code}; 

    $logger->write($message);

    my $html = $self->_gen_html('Internal Server Error', $message);

    print "Status: 500 Internal Server Error\n";
    print "Content-Type: text/html\n\n";
    print $html;

    exit;
}

# エラーページの生成
sub _gen_html() {
    my $self = shift;
    my ($title, $message) = @_;

    my $html = <<"END_HTML";
<html>
<head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <title>$title</title>
</head>
<body bgcolor="#FFFFFF">
    <h1>$title</h1>
    <p><font size="+1"><strong>$message</strong></font></p>
</body>
</html>
END_HTML

}

1;
# End of Error.pm
