#!/usr/bin/perl
#------------------------------------------------------------------------------
#    59Tracker, weblog software for personal publisher.
#    Copyright (C) 2004-2009 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

use strict;
use warnings;

use Lib::Logger;
use Lib::Error;
use Lib::App::Conf;

my $logger = Lib::Logger->new();
my $error = Lib::Error->new();
my $conf = Lib::App::Conf->new();

sub act() {
    my ($act, $cgi) = @_;
    my ($operation, $object) = split(/_/, $act);

    if ($act eq 'view_bookmark') {
        _view_bookmark($cgi);
    }
    elsif ($act eq 'input_bookmark') {
        _input_bookmark($cgi);
    }
    else {
        $error->print_error('00002e');
    }
}

# ブックマークの表示
sub _view_bookmark() {
    my ($cgi) = @_;
    my $id = $cgi->param('id');

    $logger->write("_view_bookmark");   # for debug

    my $url = "./";
    if ($id ne '') {
        my $datadir = $conf->get_data_dir();
        my $datafile = "$datadir/convert.data";

        my $hit = 0;
        if (-f $datafile) {
            open my $infh, '<', $datafile;
            while (my $datarec = <$infh>) {
                chomp $datarec;
                my ($bookmarkid, $topicid) = split(/\,/, $datarec);
                if ($bookmarkid eq $id) {
                    $id = $topicid;
                    $hit = 1;
                    last;
                }
            }
            close $infh;
        }
        if ($hit) {
            $url = "./?act=view_topic&id=$id";
            print "Status: 301 Moved Permanently\n";
        }
        else {
            $url = "./";
        }
    }
    else {
        print "Status: 404 Not Found\n";
    }
    print "Location: $url", "\n\n";
}

# ブックマーク情報の入力
sub _input_bookmark() {
    my ($cgi) = @_;
    my $url = $cgi->param('url');

    $logger->write("_input_bookmark");   # for debug

    # input_topicにリダイレクト
    print "Location: ./?act=input_topic&url=$url", "\n\n";
}

1;
