#!/usr/bin/perl
use strict;
use warnings;

# 旧バージョンのディレクトリ
my $data_dir = 'data';
my $system_dir = 'system';

# トピックデータの変換
my $counterfile = "$system_dir/topiccounter.txt";
open my $counterfh, '<', $counterfile;
my $counter = <$counterfh>;
chomp $counter;
close $counterfh;

for my $i (0..$counter) {
    my $id = $i;
    my @dataarray = ();

    my $datafile = "$data_dir/$id" . "tp.data";
    if (-f $datafile) {
        open my $infh, '<', $datafile;
        while (my $datarec = <$infh>) {
            chomp $datarec;
            my $rec = '';
            my ($rectype,$topicid,$lastdate,$status,$editor,$title,$outline,$text,$psnum,$commentnum,$trackbacknum,$linknum,$filenum,$ad1,$ad2,$ad3,$point,$keyword,,$ipaddr) = ();
            $rectype = substr($datarec, 0, 1);
            if ($rectype == 0) {
                ($rectype,$topicid,$lastdate,$status,$editor,$title,$outline,$text,$psnum,$commentnum,$trackbacknum,$linknum,$filenum,$ad1,$ad2,$ad3,$point,$keyword,$ipaddr) = split(/\,/, $datarec);
                if ($outline ne '') {
                    $text ="<strong>$outline</strong><br />" . $text;
                }
                $rec = "$rectype,$topicid,$lastdate,$status,$editor,$title,$text,$psnum,$commentnum,$trackbacknum,$linknum,$filenum,$ad1,$ad2,$ad3,$point,$keyword,,$ipaddr";
            }
            else {
                $rec = $datarec;
            }
            push @dataarray, $rec;
        }
        close $infh;

        open my $outfh, '>', $datafile;
        foreach my $data (@dataarray) {
            print {$outfh} "$data\n";
        }
        close $outfh;
    }
}

my $bmcounterfile = "$system_dir/bmcounter.txt";
open my $bmcounterfh, '<', $bmcounterfile;
my $bmcounter = <$bmcounterfh>;
chomp $bmcounter;
close $bmcounterfh;

# 変換ファイルを開く
my $convertfile = "$data_dir/convert.data";
open my $convertfh, '>', $convertfile;

for (my $i = 1; $i <= $bmcounter; $i++) {

    my $bookmarkid = $i;
    $counter++;
    my $topicid = $counter;

    my @dataarray = ();

    my $datafile = "$data_dir/bookmark/$bookmarkid" . "bm.data";
    if (-f $datafile) {
        open my $infh, '<', $datafile;
        while (my $datarec = <$infh>) {
            chomp $datarec;
            my $rec = '';
            my ($rectype,$bookmarkid,$title,$url,$summary,$registrant,$datetime,$keyword,$point) = ();

            $rectype = substr($datarec, 0, 1);
            if ($rectype == 0) {
                ($rectype,$bookmarkid,$title,$url,$summary,$registrant,$datetime,$keyword,$point) = split(/\,/, $datarec);
                my @users = split(/\,/, $registrant);
                my $editor = $users[0];
                my $pattern = "s?https?://[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+";
                $summary =~ s/($pattern)/<a href="$1" target="_blank">$1<\/a>/g;
                $rec = "$rectype,$topicid,$datetime,1,$editor,$title,$summary,0,0,0,0,0,,,,$point,$keyword,$url,";
            }
            elsif ($rectype == 2) { # コメント
                $rec = '5,' . substr($datarec, 2);
            }
            push @dataarray, $rec;
        }
        close $infh;

        my $outfile = "$data_dir/$topicid" . "tp.data";
        open my $outfh, '>', $outfile;
        foreach my $data (@dataarray) {
            print {$outfh} "$data\n";
        }
        close $outfh;

        print {$convertfh} "$bookmarkid,$topicid\n";
    }
}
close $convertfh;

# カウンターファイルを更新
open $counterfh, '>', $counterfile;
print {$counterfh} "$counter\n";
close $counterfh;

# 全ユーザーのユーザーIDリストを取得
my @userarray = ();
opendir my $dirh, "$system_dir/user/";
while (defined(my $dir = readdir $dirh)) {
    next if ($dir =~ /\A[.]+\z/);
    push @userarray, $dir;
}
closedir $dirh;

@userarray = sort @userarray;

foreach my $userid (@userarray) {

    my @dataarray = ();

    my $datafile = "$system_dir/user/$userid/" . "profile.txt";
    if (-f $datafile) {

        open my $infh, '<', $datafile;
        my $datarec = <$infh>;
        chomp $datarec;
        close $infh;

        my ($userid,$password,$mailaddr,$hpurl,$username,$auth,$status,$ad1,$ad2,$ad3,$parts,$feedurl,$amazonid,$nouse) = split(/\,/, $datarec);
        if ($auth == 2) {
            $auth = 1;
        }
        my $data = "$userid,$password,$mailaddr,$hpurl,$username,$auth,$status,$ad1,$ad2,$ad3,$parts,$feedurl,$amazonid,$nouse";

        open my $outfh, '>', $datafile;
        print {$outfh} "$data\n";
        close $outfh;
    }
}

