/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry;

import java.util.ArrayList;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.Location;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryMessages;

public class TapestryUtils {
    private static final char QUOTE = '\'';
    private static final char BACKSLASH = '\\';
    private static final String EMPTY_QUOTES = "''";
    public static final String PAGE_RENDER_SUPPORT_ATTRIBUTE = "org.apache.tapestry.PageRenderSupport";
    public static final String FORM_ATTRIBUTE = "org.apache.tapestry.Form";

    public static void storeUniqueAttribute(IRequestCycle cycle, String key, Object object) {
        Defense.notNull((Object)cycle, (String)"cycle");
        Defense.notNull((Object)key, (String)"key");
        Defense.notNull((Object)object, (String)"object");
        Object existing = cycle.getAttribute(key);
        if (existing != null) {
            throw new IllegalStateException(TapestryMessages.nonUniqueAttribute(object, key, existing));
        }
        cycle.setAttribute(key, object);
    }

    public static void storePageRenderSupport(IRequestCycle cycle, PageRenderSupport support) {
        TapestryUtils.storeUniqueAttribute(cycle, PAGE_RENDER_SUPPORT_ATTRIBUTE, support);
    }

    public static void storeForm(IRequestCycle cycle, IForm form) {
        TapestryUtils.storeUniqueAttribute(cycle, FORM_ATTRIBUTE, form);
    }

    public static PageRenderSupport getPageRenderSupport(IRequestCycle cycle, IComponent component) {
        Defense.notNull((Object)component, (String)"component");
        PageRenderSupport result = TapestryUtils.getOptionalPageRenderSupport(cycle);
        if (result == null) {
            throw new ApplicationRuntimeException(TapestryMessages.noPageRenderSupport(component), component.getLocation(), null);
        }
        return result;
    }

    public static IForm getForm(IRequestCycle cycle, IComponent component) {
        Defense.notNull((Object)cycle, (String)"cycle");
        Defense.notNull((Object)component, (String)"component");
        IForm result = (IForm)cycle.getAttribute(FORM_ATTRIBUTE);
        if (result == null) {
            throw new ApplicationRuntimeException(TapestryMessages.noForm(component), component.getLocation(), null);
        }
        return result;
    }

    public static void removePageRenderSupport(IRequestCycle cycle) {
        cycle.removeAttribute(PAGE_RENDER_SUPPORT_ATTRIBUTE);
    }

    public static void removeForm(IRequestCycle cycle) {
        cycle.removeAttribute(FORM_ATTRIBUTE);
    }

    public static PageRenderSupport getOptionalPageRenderSupport(IRequestCycle cycle) {
        return (PageRenderSupport)cycle.getAttribute(PAGE_RENDER_SUPPORT_ATTRIBUTE);
    }

    public static String[] split(String input) {
        return TapestryUtils.split(input, ',');
    }

    public static String[] split(String input, char delimiter) {
        if (HiveMind.isBlank((String)input)) {
            return new String[0];
        }
        ArrayList<String> strings = new ArrayList<String>();
        char[] buffer = input.toCharArray();
        int start = 0;
        int length = 0;
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] != delimiter) {
                ++length;
                continue;
            }
            String token = new String(buffer, start, length);
            strings.add(token);
            start = i + 1;
            length = 0;
        }
        if (start == 0 && length == buffer.length) {
            return new String[]{input};
        }
        String token = new String(buffer, start, length);
        strings.add(token);
        return strings.toArray(new String[strings.size()]);
    }

    public static String enquote(String input) {
        if (input == null) {
            return EMPTY_QUOTES;
        }
        char[] chars = input.toCharArray();
        StringBuffer buffer = new StringBuffer(chars.length + 5);
        buffer.append('\'');
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch == '\'' || ch == '\\') {
                buffer.append('\\');
            }
            buffer.append(ch);
        }
        buffer.append('\'');
        return buffer.toString();
    }

    public static String convertTapestryIdToNMToken(String baseId) {
        String result = baseId.replace('$', '_');
        while (result.startsWith("_")) {
            result = result.substring(1);
        }
        return result;
    }

    public static String buildClientElementReference(String clientId) {
        Defense.notNull((Object)clientId, (String)"clientId");
        return "document.getElementById('" + clientId + "')";
    }

    public static IComponent getComponent(IComponent container, String componentId, Class expectedType, Location location) {
        Defense.notNull((Object)container, (String)"container");
        Defense.notNull((Object)componentId, (String)"componentId");
        Defense.notNull((Object)expectedType, (String)"expectedType");
        IComponent component = null;
        try {
            component = container.getComponent(componentId);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ex.getMessage(), location, (Throwable)ex);
        }
        if (!expectedType.isAssignableFrom(component.getClass())) {
            throw new ApplicationRuntimeException(TapestryMessages.componentWrongType(component, expectedType), location, null);
        }
        return component;
    }
}

