/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.binding;

import org.apache.hivemind.Location;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.BindingException;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.RedirectException;
import org.apache.tapestry.binding.AbstractBinding;
import org.apache.tapestry.binding.BindingMessages;
import org.apache.tapestry.coerce.ValueConverter;

public class ListenerMethodBinding
extends AbstractBinding
implements IActionListener {
    private final IComponent _component;
    private final String _methodName;
    private IActionListener _listener;

    public ListenerMethodBinding(String description, ValueConverter valueConverter, Location location, IComponent component, String methodName) {
        super(description, valueConverter, location);
        Defense.notNull((Object)component, (String)"component");
        Defense.notNull((Object)methodName, (String)"methodName");
        this._component = component;
        this._methodName = methodName;
    }

    public Object getComponent() {
        return this._component;
    }

    public Object getObject() {
        return this;
    }

    public void actionTriggered(IComponent component, IRequestCycle cycle) {
        try {
            if (this._listener == null) {
                this._listener = this._component.getListeners().getListener(this._methodName);
            }
            this._listener.actionTriggered(component, cycle);
        }
        catch (PageRedirectException ex) {
            throw ex;
        }
        catch (RedirectException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new BindingException(BindingMessages.listenerMethodFailure(this._component, this._methodName, ex), this._component, this.getLocation(), this, ex);
        }
    }

    protected void extendDescription(StringBuffer buffer) {
        buffer.append(", component=");
        buffer.append(this._component.getExtendedId());
        buffer.append(", methodName=");
        buffer.append(this._methodName);
    }
}

