/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import java.awt.Point;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.Submit;

public abstract class ImageSubmit
extends Submit {
    protected void setName(IForm form) {
        String nameOverride = this.getNameOverride();
        this.setName(nameOverride == null ? form.getElementId(this) : form.getElementId(this, nameOverride));
    }

    protected boolean isClicked(IRequestCycle cycle, String name) {
        String parameterName = name + ".x";
        return cycle.getParameter(parameterName) != null;
    }

    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        boolean disabled = this.isDisabled();
        IAsset disabledImage = this.getDisabledImage();
        IAsset finalImage = disabled && disabledImage != null ? disabledImage : this.getImage();
        String imageURL = finalImage.buildURL();
        writer.beginEmpty("input");
        writer.attribute("type", "image");
        writer.attribute("name", this.getName());
        if (disabled) {
            writer.attribute("disabled", "disabled");
        }
        writer.attribute("border", 0);
        writer.attribute("src", imageURL);
        this.renderIdAttribute(writer, cycle);
        this.renderInformalParameters(writer, cycle);
        writer.closeTag();
    }

    void handleClick(IRequestCycle cycle, IForm form) {
        if (this.isParameterBound("point")) {
            int x = Integer.parseInt(cycle.getParameter(this.getName() + ".x"));
            int y = Integer.parseInt(cycle.getParameter(this.getName() + ".y"));
            this.setPoint(new Point(x, y));
        }
        super.handleClick(cycle, form);
    }

    public abstract IAsset getDisabledImage();

    public abstract IAsset getImage();

    public abstract String getNameOverride();

    public abstract void setPoint(Point var1);

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        if (this.getImage() == null) {
            throw Tapestry.createRequiredParameterException(this, "image");
        }
    }
}

