/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.parse;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.ErrorHandler;
import org.apache.hivemind.Occurances;
import org.apache.hivemind.Resource;
import org.apache.hivemind.impl.AttributeImpl;
import org.apache.hivemind.impl.ElementImpl;
import org.apache.hivemind.internal.Visibility;
import org.apache.hivemind.parse.AbstractParser;
import org.apache.hivemind.parse.AbstractServiceDescriptor;
import org.apache.hivemind.parse.AbstractServiceInvocationDescriptor;
import org.apache.hivemind.parse.AnnotationHolder;
import org.apache.hivemind.parse.AttributeMappingDescriptor;
import org.apache.hivemind.parse.ConfigurationPointDescriptor;
import org.apache.hivemind.parse.ContributionDescriptor;
import org.apache.hivemind.parse.ConversionDescriptor;
import org.apache.hivemind.parse.CreateInstanceDescriptor;
import org.apache.hivemind.parse.DependencyDescriptor;
import org.apache.hivemind.parse.ElementParseInfo;
import org.apache.hivemind.parse.ImplementationDescriptor;
import org.apache.hivemind.parse.InterceptorDescriptor;
import org.apache.hivemind.parse.InvokeFactoryDescriptor;
import org.apache.hivemind.parse.ModuleDescriptor;
import org.apache.hivemind.parse.ParseMessages;
import org.apache.hivemind.parse.ServicePointDescriptor;
import org.apache.hivemind.parse.SubModuleDescriptor;
import org.apache.hivemind.schema.ElementModel;
import org.apache.hivemind.schema.Rule;
import org.apache.hivemind.schema.impl.AttributeModelImpl;
import org.apache.hivemind.schema.impl.ElementModelImpl;
import org.apache.hivemind.schema.impl.SchemaImpl;
import org.apache.hivemind.schema.rules.CreateObjectRule;
import org.apache.hivemind.schema.rules.InvokeParentRule;
import org.apache.hivemind.schema.rules.PushAttributeRule;
import org.apache.hivemind.schema.rules.PushContentRule;
import org.apache.hivemind.schema.rules.ReadAttributeRule;
import org.apache.hivemind.schema.rules.ReadContentRule;
import org.apache.hivemind.schema.rules.SetModuleRule;
import org.apache.hivemind.schema.rules.SetParentRule;
import org.apache.hivemind.schema.rules.SetPropertyRule;
import org.apache.hivemind.util.IdUtils;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public final class DescriptorParser
extends AbstractParser {
    private static final String DEFAULT_SERVICE_MODEL = "singleton";
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$hivemind$parse$DescriptorParser == null ? (class$org$apache$hivemind$parse$DescriptorParser = DescriptorParser.class$("org.apache.hivemind.parse.DescriptorParser")) : class$org$apache$hivemind$parse$DescriptorParser));
    private static final int STATE_START = 0;
    private static final int STATE_MODULE = 1;
    private static final int STATE_CONFIGURATION_POINT = 3;
    private static final int STATE_CONTRIBUTION = 4;
    private static final int STATE_SERVICE_POINT = 5;
    private static final int STATE_CREATE_INSTANCE = 6;
    private static final int STATE_IMPLEMENTATION = 8;
    private static final int STATE_SCHEMA = 9;
    private static final int STATE_ELEMENT = 10;
    private static final int STATE_RULES = 11;
    private static final int STATE_COLLECT_SERVICE_PARAMETERS = 12;
    private static final int STATE_CONVERSION = 13;
    private static final int STATE_LWDOM = 100;
    private static final int STATE_NO_CONTENT = 300;
    private static final String SIMPLE_ID = "[a-zA-Z0-9_]+";
    public static final String ID_PATTERN = "^[a-zA-Z0-9_]+$";
    public static final String MODULE_ID_PATTERN = "^[a-zA-Z0-9_]+(\\.[a-zA-Z0-9_]+)*$";
    public static final String VERSION_PATTERN = "[0-9]+(\\.[0-9]+){2}$";
    private Map _attributes = new HashMap();
    private Map _elementParseInfo = new HashMap();
    private ModuleDescriptor _moduleDescriptor;
    private ErrorHandler _errorHandler;
    private ClassResolver _resolver;
    private Perl5Compiler _compiler;
    private Perl5Matcher _matcher;
    private Map _compiledPatterns;
    private final Map _ruleMap = new HashMap();
    private final Map OCCURS_MAP = new HashMap();
    private final Map VISIBILITY_MAP;
    static /* synthetic */ Class class$org$apache$hivemind$parse$DescriptorParser;

    public DescriptorParser(ErrorHandler errorHandler) {
        this.OCCURS_MAP.put("0..1", Occurances.OPTIONAL);
        this.OCCURS_MAP.put("1", Occurances.REQUIRED);
        this.OCCURS_MAP.put("1..n", Occurances.ONE_PLUS);
        this.OCCURS_MAP.put("0..n", Occurances.UNBOUNDED);
        this.OCCURS_MAP.put("none", Occurances.NONE);
        this.VISIBILITY_MAP = new HashMap();
        this.VISIBILITY_MAP.put("public", Visibility.PUBLIC);
        this.VISIBILITY_MAP.put("private", Visibility.PRIVATE);
        this._errorHandler = errorHandler;
        this.initializeFromPropertiesFile();
    }

    public void begin(String elementName, Map attributes) {
        this._attributes = attributes;
        switch (this.getState()) {
            case 0: {
                this.beginStart(elementName);
                break;
            }
            case 1: {
                this.beginModule(elementName);
                break;
            }
            case 3: {
                this.beginConfigurationPoint(elementName);
                break;
            }
            case 4: {
                this.beginContribution(elementName);
                break;
            }
            case 100: {
                this.beginLWDom(elementName);
                break;
            }
            case 5: {
                this.beginServicePoint(elementName);
                break;
            }
            case 8: {
                this.beginImplementation(elementName);
                break;
            }
            case 9: {
                this.beginSchema(elementName);
                break;
            }
            case 10: {
                this.beginElement(elementName);
                break;
            }
            case 11: {
                this.beginRules(elementName);
                break;
            }
            case 12: {
                this.beginCollectServiceParameters(elementName);
                break;
            }
            case 13: {
                this.beginConversion(elementName);
                break;
            }
            default: {
                this.unexpectedElement(elementName);
            }
        }
    }

    private void beginCollectServiceParameters(String elementName) {
        ElementImpl element = this.buildLWDomElement(elementName);
        AbstractServiceInvocationDescriptor sid = (AbstractServiceInvocationDescriptor)this.peekObject();
        sid.addParameter(element);
        this.push(elementName, element, 100, false);
    }

    private void beginConfigurationPoint(String elementName) {
        if (elementName.equals("schema")) {
            this.enterEmbeddedConfigurationPointSchema(elementName);
            return;
        }
        this.unexpectedElement(elementName);
    }

    private void beginContribution(String elementName) {
        ElementImpl element = this.buildLWDomElement(elementName);
        ContributionDescriptor ed = (ContributionDescriptor)this.peekObject();
        ed.addElement(element);
        this.push(elementName, element, 100, false);
    }

    private void beginConversion(String elementName) {
        if (elementName.equals("map")) {
            ConversionDescriptor cd = (ConversionDescriptor)this.peekObject();
            AttributeMappingDescriptor amd = new AttributeMappingDescriptor();
            this.push(elementName, amd, 300);
            this.checkAttributes();
            amd.setAttributeName(this.getAttribute("attribute"));
            amd.setPropertyName(this.getAttribute("property"));
            cd.addAttributeMapping(amd);
            return;
        }
        this.unexpectedElement(elementName);
    }

    private void beginElement(String elementName) {
        if (elementName.equals("attribute")) {
            this.enterAttribute(elementName);
            return;
        }
        if (elementName.equals("conversion")) {
            this.enterConversion(elementName);
            return;
        }
        if (elementName.equals("rules")) {
            this.enterRules(elementName);
            return;
        }
        if (elementName.equals("element")) {
            ElementModelImpl elementModel = (ElementModelImpl)this.peekObject();
            elementModel.addElementModel(this.enterElement(elementName));
            return;
        }
        this.unexpectedElement(elementName);
    }

    private void beginImplementation(String elementName) {
        if (elementName.equals("create-instance")) {
            this.enterCreateInstance(elementName);
            return;
        }
        if (elementName.equals("invoke-factory")) {
            this.enterInvokeFactory(elementName);
            return;
        }
        if (elementName.equals("interceptor")) {
            this.enterInterceptor(elementName);
            return;
        }
        this.unexpectedElement(elementName);
    }

    private void beginLWDom(String elementName) {
        ElementImpl element = this.buildLWDomElement(elementName);
        ElementImpl parent = (ElementImpl)this.peekObject();
        parent.addElement(element);
        this.push(elementName, element, 100, false);
    }

    private void beginModule(String elementName) {
        if (elementName.equals("configuration-point")) {
            this.enterConfigurationPoint(elementName);
            return;
        }
        if (elementName.equals("contribution")) {
            this.enterContribution(elementName);
            return;
        }
        if (elementName.equals("service-point")) {
            this.enterServicePoint(elementName);
            return;
        }
        if (elementName.equals("implementation")) {
            this.enterImplementation(elementName);
            return;
        }
        if (elementName.equals("schema")) {
            this.enterSchema(elementName);
            return;
        }
        if (elementName.equals("sub-module")) {
            this.enterSubModule(elementName);
            return;
        }
        if (elementName.equals("dependency")) {
            this.enterDependency(elementName);
            return;
        }
        this.unexpectedElement(elementName);
    }

    private void beginRules(String elementName) {
        if (elementName.equals("create-object")) {
            this.enterCreateObject(elementName);
            return;
        }
        if (elementName.equals("invoke-parent")) {
            this.enterInvokeParent(elementName);
            return;
        }
        if (elementName.equals("read-attribute")) {
            this.enterReadAttribute(elementName);
            return;
        }
        if (elementName.equals("read-content")) {
            this.enterReadContent(elementName);
            return;
        }
        if (elementName.equals("set-module")) {
            this.enterSetModule(elementName);
            return;
        }
        if (elementName.equals("set-property")) {
            this.enterSetProperty(elementName);
            return;
        }
        if (elementName.equals("push-attribute")) {
            this.enterPushAttribute(elementName);
            return;
        }
        if (elementName.equals("push-content")) {
            this.enterPushContent(elementName);
            return;
        }
        if (elementName.equals("set-parent")) {
            this.enterSetParent(elementName);
            return;
        }
        if (elementName.equals("custom")) {
            this.enterCustom(elementName);
            return;
        }
        this.unexpectedElement(elementName);
    }

    private void beginSchema(String elementName) {
        if (elementName.equals("element")) {
            SchemaImpl schema = (SchemaImpl)this.peekObject();
            schema.addElementModel(this.enterElement(elementName));
            return;
        }
        this.unexpectedElement(elementName);
    }

    private void beginServicePoint(String elementName) {
        if (elementName.equals("parameters-schema")) {
            this.enterParametersSchema(elementName);
            return;
        }
        this.beginImplementation(elementName);
    }

    private void beginStart(String elementName) {
        if (!elementName.equals("module")) {
            throw new ApplicationRuntimeException(ParseMessages.notModule(elementName, this.getLocation()), this.getLocation(), null);
        }
        ModuleDescriptor md = new ModuleDescriptor(this._resolver, this._errorHandler);
        this.push(elementName, md, 1);
        this.checkAttributes();
        md.setModuleId(this.getValidatedAttribute("id", MODULE_ID_PATTERN, "module-id-format"));
        md.setVersion(this.getValidatedAttribute("version", VERSION_PATTERN, "version-format"));
        String packageName = this.getAttribute("package");
        if (packageName == null) {
            packageName = md.getModuleId();
        }
        md.setPackageName(packageName);
        this._moduleDescriptor = md;
    }

    protected void push(String elementName, Object object, int state) {
        if (object instanceof AnnotationHolder) {
            super.push(elementName, object, state, false);
        } else {
            super.push(elementName, object, state, true);
        }
    }

    private ElementImpl buildLWDomElement(String elementName) {
        ElementImpl result = new ElementImpl();
        result.setElementName(elementName);
        Iterator i = this._attributes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            AttributeImpl a = new AttributeImpl(name, value);
            result.addAttribute(a);
        }
        return result;
    }

    private void checkAttributes() {
        this.checkAttributes(this.peekElementName());
    }

    private void checkAttributes(String elementName) {
        String name;
        Iterator i = this._attributes.keySet().iterator();
        ElementParseInfo epi = (ElementParseInfo)this._elementParseInfo.get(elementName);
        if (epi == null) {
            epi = new ElementParseInfo();
            this._elementParseInfo.put(elementName, epi);
        }
        while (i.hasNext()) {
            name = (String)i.next();
            if (epi.isKnown(name)) continue;
            this._errorHandler.error(LOG, ParseMessages.unknownAttribute(name, this.getElementPath()), this.getLocation(), null);
        }
        i = epi.getRequiredNames();
        while (i.hasNext()) {
            name = (String)i.next();
            if (this._attributes.containsKey(name)) continue;
            throw new ApplicationRuntimeException(ParseMessages.requiredAttribute(name, this.getElementPath(), this.getLocation()));
        }
    }

    public void end(String elementName) {
        switch (this.getState()) {
            case 100: {
                this.endLWDom();
                break;
            }
            case 13: {
                this.endConversion();
                break;
            }
            case 9: {
                this.endSchema();
                break;
            }
            default: {
                String content = this.peekContent();
                if (content == null || !(this.peekObject() instanceof AnnotationHolder)) break;
                ((AnnotationHolder)this.peekObject()).setAnnotation(content);
            }
        }
        this.pop();
    }

    private void endSchema() {
        SchemaImpl schema = (SchemaImpl)this.peekObject();
        schema.setAnnotation(this.peekContent());
        try {
            schema.validateKeyAttributes();
        }
        catch (ApplicationRuntimeException e) {
            this._errorHandler.error(LOG, ParseMessages.invalidElementKeyAttribute(schema.getId(), e), e.getLocation(), e);
        }
    }

    private void endConversion() {
        ConversionDescriptor cd = (ConversionDescriptor)this.peekObject();
        cd.addRulesForModel();
    }

    private void endLWDom() {
        ElementImpl element = (ElementImpl)this.peekObject();
        element.setContent(this.peekContent());
    }

    private void enterAttribute(String elementName) {
        ElementModelImpl elementModel = (ElementModelImpl)this.peekObject();
        AttributeModelImpl attributeModel = new AttributeModelImpl();
        this.push(elementName, attributeModel, 300);
        this.checkAttributes();
        attributeModel.setName(this.getAttribute("name"));
        attributeModel.setRequired(this.getBooleanAttribute("required", false));
        attributeModel.setUnique(this.getBooleanAttribute("unique", false));
        attributeModel.setTranslator(this.getAttribute("translator", "smart"));
        elementModel.addAttributeModel(attributeModel);
    }

    private void enterConfigurationPoint(String elementName) {
        Visibility visibility;
        ModuleDescriptor md = (ModuleDescriptor)this.peekObject();
        ConfigurationPointDescriptor cpd = new ConfigurationPointDescriptor();
        this.push(elementName, cpd, 3);
        this.checkAttributes();
        cpd.setId(this.getValidatedAttribute("id", ID_PATTERN, "id-format"));
        Occurances count = (Occurances)this.getEnumAttribute("occurs", this.OCCURS_MAP);
        if (count != null) {
            cpd.setCount(count);
        }
        if ((visibility = (Visibility)this.getEnumAttribute("visibility", this.VISIBILITY_MAP)) != null) {
            cpd.setVisibility(visibility);
        }
        cpd.setContributionsSchemaId(this.getAttribute("schema-id"));
        md.addConfigurationPoint(cpd);
    }

    private void enterContribution(String elementName) {
        ModuleDescriptor md = (ModuleDescriptor)this.peekObject();
        ContributionDescriptor cd = new ContributionDescriptor();
        this.push(elementName, cd, 4);
        this.checkAttributes();
        cd.setConfigurationId(this.getAttribute("configuration-id"));
        cd.setConditionalExpression(this.getAttribute("if"));
        md.addContribution(cd);
    }

    private void enterConversion(String elementName) {
        ElementModelImpl elementModel = (ElementModelImpl)this.peekObject();
        ConversionDescriptor cd = new ConversionDescriptor(this._errorHandler, elementModel);
        this.push(elementName, cd, 13);
        this.checkAttributes();
        cd.setClassName(this.getAttribute("class"));
        String methodName = this.getAttribute("parent-method");
        if (methodName != null) {
            cd.setParentMethodName(methodName);
        }
        elementModel.addRule(cd);
    }

    private void enterCreateInstance(String elementName) {
        AbstractServiceDescriptor sd = (AbstractServiceDescriptor)this.peekObject();
        CreateInstanceDescriptor cid = new CreateInstanceDescriptor();
        this.push(elementName, cid, 6);
        this.checkAttributes();
        cid.setInstanceClassName(this.getAttribute("class"));
        String model = this.getAttribute("model", DEFAULT_SERVICE_MODEL);
        cid.setServiceModel(model);
        sd.setInstanceBuilder(cid);
    }

    private void enterCreateObject(String elementName) {
        ElementModelImpl elementModel = (ElementModelImpl)this.peekObject();
        CreateObjectRule rule = new CreateObjectRule();
        this.push(elementName, rule, 300);
        this.checkAttributes();
        rule.setClassName(this.getAttribute("class"));
        elementModel.addRule(rule);
    }

    private void enterCustom(String elementName) {
        ElementModelImpl elementModel = (ElementModelImpl)this.peekObject();
        this.push(elementName, null, 300);
        this.checkAttributes();
        String ruleClassName = this.getAttribute("class");
        Rule rule = this.getCustomRule(ruleClassName);
        elementModel.addRule(rule);
    }

    private ElementModel enterElement(String elementName) {
        ElementModelImpl result = new ElementModelImpl();
        this.push(elementName, result, 10);
        this.checkAttributes();
        result.setElementName(this.getAttribute("name"));
        result.setKeyAttribute(this.getAttribute("key-attribute"));
        result.setContentTranslator(this.getAttribute("content-translator"));
        return result;
    }

    private void enterEmbeddedConfigurationPointSchema(String elementName) {
        ConfigurationPointDescriptor cpd = (ConfigurationPointDescriptor)this.peekObject();
        SchemaImpl schema = new SchemaImpl();
        this.push(elementName, schema, 9);
        if (cpd.getContributionsSchemaId() != null) {
            cpd.setContributionsSchemaId(null);
            cpd.setContributionsSchema(schema);
            this._errorHandler.error(LOG, ParseMessages.multipleContributionsSchemas(cpd.getId(), schema.getLocation()), schema.getLocation(), null);
        } else {
            cpd.setContributionsSchema(schema);
        }
        this.checkAttributes("schema{embedded}");
    }

    private void enterParametersSchema(String elementName) {
        ServicePointDescriptor spd = (ServicePointDescriptor)this.peekObject();
        SchemaImpl schema = new SchemaImpl();
        this.push(elementName, schema, 9);
        this.checkAttributes();
        if (spd.getParametersSchemaId() != null) {
            spd.setParametersSchemaId(null);
            spd.setParametersSchema(schema);
            this._errorHandler.error(LOG, ParseMessages.multipleParametersSchemas(spd.getId(), schema.getLocation()), schema.getLocation(), null);
        } else {
            spd.setParametersSchema(schema);
        }
    }

    private void enterImplementation(String elementName) {
        ModuleDescriptor md = (ModuleDescriptor)this.peekObject();
        ImplementationDescriptor id = new ImplementationDescriptor();
        this.push(elementName, id, 8);
        this.checkAttributes();
        id.setServiceId(this.getAttribute("service-id"));
        id.setConditionalExpression(this.getAttribute("if"));
        md.addImplementation(id);
    }

    private void enterInterceptor(String elementName) {
        AbstractServiceDescriptor sd = (AbstractServiceDescriptor)this.peekObject();
        InterceptorDescriptor id = new InterceptorDescriptor();
        this.push(elementName, id, 12);
        this.checkAttributes();
        id.setFactoryServiceId(this.getAttribute("service-id"));
        id.setBefore(this.getAttribute("before"));
        id.setAfter(this.getAttribute("after"));
        id.setName(this.getAttribute("name"));
        sd.addInterceptor(id);
    }

    private void enterInvokeFactory(String elementName) {
        AbstractServiceDescriptor sd = (AbstractServiceDescriptor)this.peekObject();
        InvokeFactoryDescriptor ifd = new InvokeFactoryDescriptor();
        this.push(elementName, ifd, 12);
        this.checkAttributes();
        ifd.setFactoryServiceId(this.getAttribute("service-id", "hivemind.BuilderFactory"));
        String model = this.getAttribute("model", DEFAULT_SERVICE_MODEL);
        ifd.setServiceModel(model);
        sd.setInstanceBuilder(ifd);
    }

    private void enterInvokeParent(String elementName) {
        ElementModelImpl elementModel = (ElementModelImpl)this.peekObject();
        InvokeParentRule rule = new InvokeParentRule();
        this.push(elementName, rule, 300);
        this.checkAttributes();
        rule.setMethodName(this.getAttribute("method"));
        if (this._attributes.containsKey("depth")) {
            rule.setDepth(this.getIntAttribute("depth"));
        }
        elementModel.addRule(rule);
    }

    private void enterReadAttribute(String elementName) {
        ElementModelImpl elementModel = (ElementModelImpl)this.peekObject();
        ReadAttributeRule rule = new ReadAttributeRule();
        this.push(elementName, rule, 300);
        this.checkAttributes();
        rule.setPropertyName(this.getAttribute("property"));
        rule.setAttributeName(this.getAttribute("attribute"));
        rule.setSkipIfNull(this.getBooleanAttribute("skip-if-null", true));
        rule.setTranslator(this.getAttribute("translator"));
        elementModel.addRule(rule);
    }

    private void enterReadContent(String elementName) {
        ElementModelImpl elementModel = (ElementModelImpl)this.peekObject();
        ReadContentRule rule = new ReadContentRule();
        this.push(elementName, rule, 300);
        this.checkAttributes();
        rule.setPropertyName(this.getAttribute("property"));
        elementModel.addRule(rule);
    }

    private void enterRules(String elementName) {
        ElementModelImpl elementModel = (ElementModelImpl)this.peekObject();
        this.push(elementName, elementModel, 11);
    }

    private void enterSchema(String elementName) {
        SchemaImpl schema = new SchemaImpl();
        this.push(elementName, schema, 9);
        this.checkAttributes();
        String id = this.getValidatedAttribute("id", ID_PATTERN, "id-format");
        schema.setId(id);
        Visibility visibility = (Visibility)this.getEnumAttribute("visibility", this.VISIBILITY_MAP);
        if (visibility != null) {
            schema.setVisibility(visibility);
        }
        this._moduleDescriptor.addSchema(schema);
    }

    private void enterServicePoint(String elementName) {
        Visibility visibility;
        ModuleDescriptor md = (ModuleDescriptor)this.peekObject();
        ServicePointDescriptor spd = new ServicePointDescriptor();
        this.push(elementName, spd, 5);
        this.checkAttributes();
        String id = this.getValidatedAttribute("id", ID_PATTERN, "id-format");
        String interfaceAttribute = this.getAttribute("interface", id);
        String interfaceName = IdUtils.qualify(this._moduleDescriptor.getPackageName(), interfaceAttribute);
        spd.setId(id);
        spd.setInterfaceClassName(interfaceName);
        spd.setParametersSchemaId(this.getAttribute("parameters-schema-id"));
        Occurances count = (Occurances)this.getEnumAttribute("parameters-occurs", this.OCCURS_MAP);
        if (count != null) {
            spd.setParametersCount(count);
        }
        if ((visibility = (Visibility)this.getEnumAttribute("visibility", this.VISIBILITY_MAP)) != null) {
            spd.setVisibility(visibility);
        }
        md.addServicePoint(spd);
    }

    private void enterSetModule(String elementName) {
        ElementModelImpl elementModel = (ElementModelImpl)this.peekObject();
        SetModuleRule rule = new SetModuleRule();
        this.push(elementName, rule, 300);
        this.checkAttributes();
        rule.setPropertyName(this.getAttribute("property"));
        elementModel.addRule(rule);
    }

    private void enterSetParent(String elementName) {
        ElementModelImpl elementModel = (ElementModelImpl)this.peekObject();
        SetParentRule rule = new SetParentRule();
        this.push(elementName, rule, 300);
        this.checkAttributes();
        rule.setPropertyName(this.getAttribute("property"));
        elementModel.addRule(rule);
    }

    private void enterSetProperty(String elementName) {
        ElementModelImpl elementModel = (ElementModelImpl)this.peekObject();
        SetPropertyRule rule = new SetPropertyRule();
        this.push(elementName, rule, 300);
        this.checkAttributes();
        rule.setPropertyName(this.getAttribute("property"));
        rule.setValue(this.getAttribute("value"));
        elementModel.addRule(rule);
    }

    private void enterPushAttribute(String elementName) {
        ElementModelImpl elementModel = (ElementModelImpl)this.peekObject();
        PushAttributeRule rule = new PushAttributeRule();
        this.push(elementName, rule, 300);
        this.checkAttributes();
        rule.setAttributeName(this.getAttribute("attribute"));
        elementModel.addRule(rule);
    }

    private void enterPushContent(String elementName) {
        ElementModelImpl elementModel = (ElementModelImpl)this.peekObject();
        PushContentRule rule = new PushContentRule();
        this.push(elementName, rule, 300);
        this.checkAttributes();
        elementModel.addRule(rule);
    }

    private void enterSubModule(String elementName) {
        ModuleDescriptor md = (ModuleDescriptor)this.peekObject();
        SubModuleDescriptor smd = new SubModuleDescriptor();
        this.push(elementName, smd, 300);
        this.checkAttributes();
        Resource descriptor = this.getResource().getRelativeResource(this.getAttribute("descriptor"));
        smd.setDescriptor(descriptor);
        md.addSubModule(smd);
    }

    private void enterDependency(String elementName) {
        ModuleDescriptor md = (ModuleDescriptor)this.peekObject();
        DependencyDescriptor dd = new DependencyDescriptor();
        this.push(elementName, dd, 300);
        this.checkAttributes();
        dd.setModuleId(this.getAttribute("module-id"));
        dd.setVersion(this.getAttribute("version"));
        md.addDependency(dd);
    }

    private String getAttribute(String name) {
        return (String)this._attributes.get(name);
    }

    private String getAttribute(String name, String defaultValue) {
        String result = (String)this._attributes.get(name);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    private String getValidatedAttribute(String name, String pattern, String formatKey) {
        String result = this.getAttribute(name);
        if (!this.validateFormat(result, pattern)) {
            this._errorHandler.error(LOG, ParseMessages.invalidAttributeFormat(name, result, this.getElementPath(), formatKey), this.getLocation(), null);
        }
        return result;
    }

    private boolean validateFormat(String input, String pattern) {
        Pattern compiled;
        if (this._compiler == null) {
            this._compiler = new Perl5Compiler();
            this._matcher = new Perl5Matcher();
            this._compiledPatterns = new HashMap();
        }
        if ((compiled = (Pattern)this._compiledPatterns.get(pattern)) == null) {
            try {
                compiled = this._compiler.compile(pattern);
            }
            catch (MalformedPatternException ex) {
                throw new ApplicationRuntimeException(ex);
            }
            this._compiledPatterns.put(pattern, compiled);
        }
        return this._matcher.matches(input, compiled);
    }

    private boolean getBooleanAttribute(String name, boolean defaultValue) {
        String value = this.getAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        this._errorHandler.error(LOG, ParseMessages.booleanAttribute(value, name, this.getElementPath()), this.getLocation(), null);
        return defaultValue;
    }

    private Rule getCustomRule(String ruleClassName) {
        Rule result = (Rule)this._ruleMap.get(ruleClassName);
        if (result == null) {
            result = this.instantiateRule(ruleClassName);
            this._ruleMap.put(ruleClassName, result);
        }
        return result;
    }

    private Object getEnumAttribute(String name, Map translations) {
        String value = this.getAttribute(name);
        if (value == null) {
            return null;
        }
        Object result = translations.get(value);
        if (result == null) {
            this._errorHandler.error(LOG, ParseMessages.invalidAttributeValue(value, name, this.getElementPath()), this.getLocation(), null);
        }
        return result;
    }

    private int getIntAttribute(String name) {
        String value = this.getAttribute(name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            this._errorHandler.error(LOG, ParseMessages.invalidNumericValue(value, name, this.getElementPath()), this.getLocation(), ex);
            return 0;
        }
    }

    private void initializeFromProperties(Properties p) {
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = p.getProperty(key);
            this.initializeFromProperty(key, value);
        }
    }

    private void initializeFromPropertiesFile() {
        Properties p = new Properties();
        try {
            InputStream propertiesIn = this.getClass().getResourceAsStream("DescriptorParser.properties");
            BufferedInputStream bufferedIn = new BufferedInputStream(propertiesIn);
            p.load(bufferedIn);
            ((InputStream)bufferedIn).close();
        }
        catch (IOException ex) {
            this._errorHandler.error(LOG, ParseMessages.unableToInitialize(ex), null, ex);
        }
        this.initializeFromProperties(p);
    }

    private void initializeFromProperty(String key, String value) {
        if (key.startsWith("required.")) {
            this.initializeRequired(key, value);
            return;
        }
    }

    private void initializeRequired(String key, String value) {
        boolean required = value.equals("true");
        int lastdotx = key.lastIndexOf(46);
        String elementName = key.substring(9, lastdotx);
        String attributeName = key.substring(lastdotx + 1);
        ElementParseInfo epi = (ElementParseInfo)this._elementParseInfo.get(elementName);
        if (epi == null) {
            epi = new ElementParseInfo();
            this._elementParseInfo.put(elementName, epi);
        }
        epi.addAttribute(attributeName, required);
    }

    private Rule instantiateRule(String ruleClassName) {
        try {
            Class ruleClass = this._resolver.findClass(ruleClassName);
            return (Rule)ruleClass.newInstance();
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ParseMessages.badRuleClass(ruleClassName, this.getLocation(), ex), this.getLocation(), ex);
        }
    }

    public void initialize(Resource resource, ClassResolver resolver) {
        this.initializeParser(resource, 0);
        this._resolver = resolver;
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this._moduleDescriptor;
    }

    public void reset() {
        super.resetParser();
        this._moduleDescriptor = null;
        this._attributes.clear();
        this._resolver = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

