/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.form;

import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.contrib.form.CheckBoxMultiplePropertySelectionRenderer;
import org.apache.tapestry.contrib.form.IMultiplePropertySelectionRenderer;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.form.ValidatableField;
import org.apache.tapestry.form.ValidatableFieldSupport;
import org.apache.tapestry.valid.ValidatorException;

public abstract class MultiplePropertySelection
extends AbstractFormComponent
implements ValidatableField {
    public static final IMultiplePropertySelectionRenderer DEFAULT_CHECKBOX_RENDERER = new CheckBoxMultiplePropertySelectionRenderer();

    public abstract List getSelectedList();

    public abstract void setSelectedList(List var1);

    protected void finishLoad() {
        this.setRenderer(DEFAULT_CHECKBOX_RENDERER);
    }

    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        List selectedList = this.getSelectedList();
        if (selectedList == null) {
            throw Tapestry.createRequiredParameterException((IComponent)this, (String)"selectedList");
        }
        IPropertySelectionModel model = this.getModel();
        if (model == null) {
            throw Tapestry.createRequiredParameterException((IComponent)this, (String)"model");
        }
        IMultiplePropertySelectionRenderer renderer = this.getRenderer();
        renderer.beginRender(this, writer, cycle);
        int count = model.getOptionCount();
        for (int i = 0; i < count; ++i) {
            Object option = model.getOption(i);
            boolean optionSelected = selectedList.contains(option);
            renderer.renderOption(this, writer, cycle, model, option, i, optionSelected);
        }
        renderer.endRender(this, writer, cycle);
    }

    protected void rewindFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        String[] optionValues = cycle.getParameters(this.getName());
        IPropertySelectionModel model = this.getModel();
        ArrayList<Object> selectedList = new ArrayList<Object>(this.getModel().getOptionCount());
        if (optionValues != null) {
            for (int i = 0; i < optionValues.length; ++i) {
                Object selectedValue = model.translateValue(optionValues[i]);
                selectedList.add(selectedValue);
            }
        }
        try {
            this.getValidatableFieldSupport().validate((ValidatableField)this, writer, cycle, selectedList);
            this.setSelectedList(selectedList);
        }
        catch (ValidatorException e) {
            this.getForm().getDelegate().record(e);
        }
    }

    public abstract IPropertySelectionModel getModel();

    public abstract IMultiplePropertySelectionRenderer getRenderer();

    public abstract void setRenderer(IMultiplePropertySelectionRenderer var1);

    public abstract ValidatableFieldSupport getValidatableFieldSupport();

    public boolean isRequired() {
        return this.getValidatableFieldSupport().isRequired((ValidatableField)this);
    }

    public abstract /* synthetic */ Object getValidators();

    public abstract /* synthetic */ String getClientId();

    public abstract /* synthetic */ boolean isDisabled();

    public abstract /* synthetic */ String getDisplayName();
}

