/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.components;

import java.text.Format;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.components.ComponentMessages;

public abstract class Insert
extends AbstractComponent {
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding()) {
            return;
        }
        Object value = this.getValue();
        if (value == null) {
            return;
        }
        String insert = null;
        Format format = this.getFormat();
        if (format == null) {
            insert = value.toString();
        } else {
            try {
                insert = format.format(value);
            }
            catch (Exception ex) {
                throw new ApplicationRuntimeException(ComponentMessages.unableToFormat(this, value, ex), (Object)this, this.getBinding("format").getLocation(), (Throwable)ex);
            }
        }
        String styleClass = this.getStyleClass();
        if (styleClass != null) {
            writer.begin("span");
            writer.attribute("class", styleClass);
            this.renderInformalParameters(writer, cycle);
        }
        writer.print(insert, this.getRaw());
        if (styleClass != null) {
            writer.end();
        }
    }

    public abstract Object getValue();

    public abstract Format getFormat();

    public abstract String getStyleClass();

    public abstract boolean getRaw();
}

