/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import java.util.Iterator;
import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.enhance.EnhanceMessages;
import org.apache.tapestry.enhance.EnhanceUtils;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IParameterSpecification;

public class ParameterPropertyWorker
implements EnhancementWorker {
    private ErrorLog _errorLog;
    static /* synthetic */ Class class$org$apache$tapestry$IComponent;
    static /* synthetic */ Class class$org$apache$tapestry$IBinding;
    static /* synthetic */ Class class$org$apache$hivemind$ApplicationRuntimeException;

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec) {
        Iterator i = spec.getParameterNames().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            IParameterSpecification ps = spec.getParameter(name);
            try {
                this.performEnhancement(op, name, ps);
            }
            catch (RuntimeException ex) {
                this._errorLog.error(EnhanceMessages.errorAddingProperty(ps.getPropertyName(), op.getBaseClass(), ex), ps.getLocation(), (Throwable)ex);
            }
        }
    }

    private void performEnhancement(EnhancementOperation op, String parameterName, IParameterSpecification ps) {
        if (!parameterName.equals(ps.getParameterName())) {
            return;
        }
        String propertyName = ps.getPropertyName();
        String specifiedType = ps.getType();
        boolean cache = ps.getCache();
        this.addParameter(op, parameterName, propertyName, specifiedType, cache, ps.getLocation());
    }

    public void addParameter(EnhancementOperation op, String parameterName, String propertyName, String specifiedType, boolean cache, Location location) {
        Defense.notNull((Object)op, (String)"op");
        Defense.notNull((Object)parameterName, (String)"parameterName");
        Defense.notNull((Object)propertyName, (String)"propertyName");
        Class propertyType = EnhanceUtils.extractPropertyType(op, propertyName, specifiedType);
        op.claimProperty(propertyName);
        String fieldName = "_$" + propertyName;
        String defaultFieldName = fieldName + "$Default";
        String cachedFieldName = fieldName + "$Cached";
        op.addField(fieldName, propertyType);
        op.addField(defaultFieldName, propertyType);
        op.addField(cachedFieldName, Boolean.TYPE);
        this.buildAccessor(op, parameterName, propertyName, propertyType, fieldName, defaultFieldName, cachedFieldName, cache, location);
        this.buildMutator(op, parameterName, propertyName, propertyType, fieldName, defaultFieldName, cachedFieldName, location);
        this.extendCleanupAfterRender(op, parameterName, propertyName, propertyType, fieldName, defaultFieldName, cachedFieldName);
    }

    private void extendCleanupAfterRender(EnhancementOperation op, String parameterName, String propertyName, Class propertyType, String fieldName, String defaultFieldName, String cachedFieldName) {
        BodyBuilder cleanupBody = new BodyBuilder();
        String bindingName = propertyName + "Binding";
        this.addBindingReference(cleanupBody, bindingName, parameterName);
        cleanupBody.addln("if ({0} && ! {1}.isInvariant())", (Object)cachedFieldName, (Object)bindingName);
        cleanupBody.begin();
        cleanupBody.addln("{0} = false;", (Object)cachedFieldName);
        cleanupBody.addln("{0} = {1};", (Object)fieldName, (Object)defaultFieldName);
        cleanupBody.end();
        op.extendMethodImplementation(class$org$apache$tapestry$IComponent == null ? (class$org$apache$tapestry$IComponent = ParameterPropertyWorker.class$("org.apache.tapestry.IComponent")) : class$org$apache$tapestry$IComponent, EnhanceUtils.CLEANUP_AFTER_RENDER_SIGNATURE, cleanupBody.toString());
    }

    private void addBindingReference(BodyBuilder builder, String localVariableName, String parameterName) {
        builder.addln("{0} {1} = getBinding(\"{2}\");", (Object)(class$org$apache$tapestry$IBinding == null ? (class$org$apache$tapestry$IBinding = ParameterPropertyWorker.class$("org.apache.tapestry.IBinding")) : class$org$apache$tapestry$IBinding).getName(), (Object)localVariableName, (Object)parameterName);
    }

    private void buildMutator(EnhancementOperation op, String parameterName, String propertyName, Class propertyType, String fieldName, String defaultFieldName, String cachedFieldName, Location location) {
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("if (! isInActiveState())");
        builder.begin();
        builder.addln("{0} = $1;", (Object)defaultFieldName);
        builder.addln("return;");
        builder.end();
        this.addBindingReference(builder, "binding", parameterName);
        builder.addln("if (binding == null)");
        builder.addln("  throw new {0}(\"Parameter ''{1}'' is not bound and can not be updated.\");", (Object)(class$org$apache$hivemind$ApplicationRuntimeException == null ? (class$org$apache$hivemind$ApplicationRuntimeException = ParameterPropertyWorker.class$("org.apache.hivemind.ApplicationRuntimeException")) : class$org$apache$hivemind$ApplicationRuntimeException).getName(), (Object)parameterName);
        builder.addln("binding.setObject(($w) $1);");
        builder.addln("if (isRendering())");
        builder.begin();
        builder.addln("{0} = $1;", (Object)fieldName);
        builder.addln("{0} = true;", (Object)cachedFieldName);
        builder.end();
        builder.end();
        String mutatorMethodName = EnhanceUtils.createMutatorMethodName(propertyName);
        op.addMethod(1, new MethodSignature(Void.TYPE, mutatorMethodName, new Class[]{propertyType}, null), builder.toString(), location);
    }

    void buildAccessor(EnhancementOperation op, String parameterName, String propertyName, Class propertyType, String fieldName, String defaultFieldName, String cachedFieldName, boolean cache, Location location) {
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("if ({0}) return {1};", (Object)cachedFieldName, (Object)fieldName);
        this.addBindingReference(builder, "binding", parameterName);
        builder.addln("if (binding == null) return {0};", (Object)defaultFieldName);
        String javaTypeName = ClassFabUtils.getJavaClassName((Class)propertyType);
        builder.addln("{0} result = {1};", (Object)javaTypeName, (Object)EnhanceUtils.createUnwrapExpression(op, "binding", propertyType));
        String expression = cache ? "isRendering() || binding.isInvariant()" : "binding.isInvariant()";
        builder.addln("if ({0})", (Object)expression);
        builder.begin();
        builder.addln("{0} = result;", (Object)fieldName);
        builder.addln("{0} = true;", (Object)cachedFieldName);
        builder.end();
        builder.addln("return result;");
        builder.end();
        String accessorMethodName = op.getAccessorMethodName(propertyName);
        op.addMethod(1, new MethodSignature(propertyType, accessorMethodName, null, null), builder.toString(), location);
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

