/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.Locatable;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.asset.AssetFactory;
import org.apache.tapestry.util.IdAllocator;

public class PageRenderSupportImpl
implements Locatable,
PageRenderSupport {
    private final AssetFactory _assetFactory;
    private final Location _location;
    private StringBuffer _initializationScript;
    private StringBuffer _bodyScript;
    private StringBuffer _imageInitializations;
    private Map _imageMap;
    private List _externalScripts;
    private final IdAllocator _idAllocator;
    private final String _preloadName;

    public PageRenderSupportImpl(AssetFactory assetFactory, String namespace, Location location) {
        Defense.notNull((Object)assetFactory, (String)"assetService");
        this._assetFactory = assetFactory;
        this._location = location;
        this._idAllocator = new IdAllocator(namespace);
        this._preloadName = (namespace.equals("") ? "tapestry" : namespace) + "_preload";
    }

    public Location getLocation() {
        return this._location;
    }

    public String getPreloadedImageReference(String URL2) {
        String reference;
        if (this._imageMap == null) {
            this._imageMap = new HashMap();
        }
        if ((reference = (String)this._imageMap.get(URL2)) == null) {
            int count = this._imageMap.size();
            String varName = this._preloadName + "[" + count + "]";
            reference = varName + ".src";
            if (this._imageInitializations == null) {
                this._imageInitializations = new StringBuffer();
            }
            this._imageInitializations.append("  ");
            this._imageInitializations.append(varName);
            this._imageInitializations.append(" = new Image();\n");
            this._imageInitializations.append("  ");
            this._imageInitializations.append(reference);
            this._imageInitializations.append(" = \"");
            this._imageInitializations.append(URL2);
            this._imageInitializations.append("\";\n");
            this._imageMap.put(URL2, reference);
        }
        return reference;
    }

    public void addBodyScript(String script) {
        if (this._bodyScript == null) {
            this._bodyScript = new StringBuffer(script.length());
        }
        this._bodyScript.append(script);
    }

    public void addInitializationScript(String script) {
        if (this._initializationScript == null) {
            this._initializationScript = new StringBuffer(script.length() + 1);
        }
        this._initializationScript.append(script);
        this._initializationScript.append('\n');
    }

    public void addExternalScript(Resource scriptLocation) {
        if (this._externalScripts == null) {
            this._externalScripts = new ArrayList();
        }
        if (this._externalScripts.contains(scriptLocation)) {
            return;
        }
        this._externalScripts.add(scriptLocation);
    }

    public String getUniqueString(String baseValue) {
        return this._idAllocator.allocateId(baseValue);
    }

    private void writeExternalScripts(IMarkupWriter writer, IRequestCycle cycle) {
        int count = Tapestry.size(this._externalScripts);
        for (int i = 0; i < count; ++i) {
            Resource scriptLocation = (Resource)this._externalScripts.get(i);
            IAsset asset = this._assetFactory.createAsset(scriptLocation, null);
            String url = asset.buildURL();
            writer.begin("script");
            writer.attribute("type", "text/javascript");
            writer.attribute("src", url);
            writer.end();
            writer.println();
        }
    }

    public void writeBodyScript(IMarkupWriter writer, IRequestCycle cycle) {
        if (!Tapestry.isEmpty(this._externalScripts)) {
            this.writeExternalScripts(writer, cycle);
        }
        if (!this.any(this._bodyScript) && !this.any(this._imageInitializations)) {
            return;
        }
        writer.begin("script");
        writer.attribute("type", "text/javascript");
        writer.printRaw("<!--");
        if (this.any(this._imageInitializations)) {
            writer.printRaw("\n\nvar " + this._preloadName + " = new Array();\n");
            writer.printRaw("if (document.images)\n");
            writer.printRaw("{\n");
            writer.printRaw(this._imageInitializations.toString());
            writer.printRaw("}\n");
        }
        if (this.any(this._bodyScript)) {
            writer.printRaw("\n\n");
            writer.printRaw(this._bodyScript.toString());
        }
        writer.printRaw("\n\n// -->");
        writer.end();
    }

    public void writeInitializationScript(IMarkupWriter writer) {
        if (!this.any(this._initializationScript)) {
            return;
        }
        writer.begin("script");
        writer.attribute("language", "JavaScript");
        writer.attribute("type", "text/javascript");
        writer.printRaw("<!--\n");
        writer.printRaw(this._initializationScript.toString());
        writer.printRaw("\n// -->");
        writer.end();
    }

    private boolean any(StringBuffer buffer) {
        return buffer != null && buffer.length() > 0;
    }
}

