/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.binding;

import org.apache.hivemind.Location;
import org.apache.tapestry.BindingException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.binding.AbstractBinding;
import org.apache.tapestry.coerce.ValueConverter;
import org.apache.tapestry.services.ExpressionCache;
import org.apache.tapestry.services.ExpressionEvaluator;

public class ExpressionBinding
extends AbstractBinding {
    private final IComponent _root;
    private String _expression;
    private boolean _invariant = false;
    private Object _parsedExpression;
    private boolean _initialized;
    private ExpressionEvaluator _evaluator;
    private ExpressionCache _cache;

    public ExpressionBinding(String description, Location location, ValueConverter valueConverter, IComponent root, String expression, ExpressionEvaluator evaluator, ExpressionCache cache) {
        super(description, valueConverter, location);
        this._root = root;
        this._expression = expression;
        this._evaluator = evaluator;
        this._cache = cache;
    }

    public Object getObject() {
        this.initialize();
        return this.resolveExpression();
    }

    private Object resolveExpression() {
        try {
            return this._evaluator.readCompiled(this._root, this._parsedExpression);
        }
        catch (Throwable t) {
            throw new BindingException(t.getMessage(), this, t);
        }
    }

    public boolean isInvariant() {
        this.initialize();
        return this._invariant;
    }

    private void initialize() {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        try {
            this._parsedExpression = this._cache.getCompiledExpression(this._expression);
            this._invariant = this._evaluator.isConstant(this._expression);
        }
        catch (Exception ex) {
            throw new BindingException(ex.getMessage(), this, ex);
        }
    }

    public void setObject(Object value) {
        this.initialize();
        if (this._invariant) {
            throw this.createReadOnlyBindingException(this);
        }
        try {
            this._evaluator.writeCompiled(this._root, this._parsedExpression, value);
        }
        catch (Throwable ex) {
            throw new BindingException(ex.getMessage(), this, ex);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ExpressionBinding[");
        buffer.append(this._root.getExtendedId());
        if (this._expression != null) {
            buffer.append(' ');
            buffer.append(this._expression);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public Object getComponent() {
        return this._root;
    }
}

