/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.components;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.services.DataSqueezer;

public abstract class IfBean
extends AbstractFormComponent {
    public static final String IF_VALUE_ATTRIBUTE = "org.mb.tapestry.base.IfValue";
    private boolean _rendering = false;
    private boolean _conditionValue;

    public abstract IBinding getConditionValueBinding();

    public abstract boolean getCondition();

    public abstract boolean getVolatile();

    public abstract String getElement();

    public abstract IActionListener getListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        boolean cycleRewinding = cycle.isRewinding();
        IForm form = (IForm)cycle.getAttribute("org.apache.tapestry.Form");
        if (cycleRewinding && form != null && !form.isRewinding()) {
            return;
        }
        this._conditionValue = this.evaluateCondition(cycle, form, cycleRewinding);
        this._rendering = true;
        try {
            IActionListener listener = this.getListener();
            if (listener != null) {
                listener.actionTriggered(this, cycle);
            }
            if (this._conditionValue) {
                boolean render;
                String element = this.getElement();
                boolean bl = render = !cycleRewinding && HiveMind.isNonBlank((String)element);
                if (render) {
                    writer.begin(element);
                    this.renderInformalParameters(writer, cycle);
                }
                this.renderBody(writer, cycle);
                if (render) {
                    writer.end(element);
                }
            }
        }
        finally {
            this._rendering = false;
        }
        cycle.setAttribute(IF_VALUE_ATTRIBUTE, new Boolean(this._conditionValue));
    }

    protected boolean evaluateCondition(IRequestCycle cycle, IForm form, boolean cycleRewinding) {
        boolean condition;
        if (form == null || this.getVolatile()) {
            condition = this.getCondition();
        } else {
            String name = form.getElementId(this);
            if (!cycleRewinding) {
                condition = this.getCondition();
                this.writeValue(form, name, condition);
            } else {
                condition = this.readValue(cycle, name);
            }
        }
        IBinding conditionValueBinding = this.getConditionValueBinding();
        if (conditionValueBinding != null) {
            conditionValueBinding.setObject(new Boolean(condition));
        }
        return condition;
    }

    private void writeValue(IForm form, String name, boolean value) {
        String externalValue;
        Boolean booleanValue = new Boolean(value);
        try {
            externalValue = this.getDataSqueezer().squeeze(booleanValue);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(Tapestry.format("If.unable-to-convert-value", booleanValue), (Object)this, null, (Throwable)ex);
        }
        form.addHiddenValue(name, externalValue);
    }

    private boolean readValue(IRequestCycle cycle, String name) {
        String submittedValue = cycle.getParameter(name);
        try {
            Object valueObject = this.getDataSqueezer().unsqueeze(submittedValue);
            if (!(valueObject instanceof Boolean)) {
                throw new ApplicationRuntimeException(Tapestry.format("If.invalid-condition-type", submittedValue));
            }
            return (Boolean)valueObject;
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(Tapestry.format("If.unable-to-convert-string", submittedValue), (Object)this, null, (Throwable)ex);
        }
    }

    public abstract DataSqueezer getDataSqueezer();

    public boolean isDisabled() {
        return false;
    }

    public boolean getConditionValue() {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException(this, "conditionValue");
        }
        return this._conditionValue;
    }

    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
    }

    protected void rewindFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
    }

    protected boolean getCanTakeFocus() {
        return false;
    }
}

