/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.describe;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import org.apache.hivemind.Location;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.describe.RenderStrategy;

public class LocationRenderStrategy
implements RenderStrategy {
    private static final int RANGE = 5;

    public void renderObject(Object object, IMarkupWriter writer, IRequestCycle cycle) {
        Location l = (Location)object;
        writer.print(l.toString());
        int lineNumber = l.getLineNumber();
        if (lineNumber < 1) {
            return;
        }
        URL url = l.getResource().getResourceURL();
        if (url == null) {
            return;
        }
        this.writeResourceContent(writer, url, lineNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeResourceContent(IMarkupWriter writer, URL url, int lineNumber) {
        LineNumberReader reader = null;
        try {
            int currentLine;
            String line;
            reader = new LineNumberReader(new BufferedReader(new InputStreamReader(url.openStream())));
            writer.beginEmpty("br");
            writer.begin("table");
            writer.attribute("class", "location-content");
            while ((line = reader.readLine()) != null && (currentLine = reader.getLineNumber()) <= lineNumber + 5) {
                if (currentLine < lineNumber - 5) continue;
                writer.begin("tr");
                if (currentLine == lineNumber) {
                    writer.attribute("class", "target-line");
                }
                writer.begin("td");
                writer.attribute("class", "line-number");
                writer.print(currentLine);
                writer.end();
                writer.begin("td");
                writer.print(line);
                writer.end("tr");
                writer.println();
            }
            reader.close();
            reader = null;
            writer.end("table");
            this.close(reader);
            return;
        }
        catch (Exception ex) {
            return;
        }
        finally {
            writer.end("table");
            this.close(reader);
        }
    }

    private void close(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

