/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.util.HashMap;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.Resource;
import org.apache.tapestry.IScript;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.coerce.ValueConverter;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.event.ReportStatusEvent;
import org.apache.tapestry.event.ReportStatusListener;
import org.apache.tapestry.event.ResetEventListener;
import org.apache.tapestry.script.ScriptParser;
import org.apache.tapestry.services.ExpressionEvaluator;
import org.apache.tapestry.util.xml.DocumentParseException;

public class DefaultScriptSource
implements IScriptSource,
ResetEventListener,
ReportStatusListener {
    private String _serviceId;
    private ClassResolver _classResolver;
    private ExpressionEvaluator _expressionEvaluator;
    private ValueConverter _valueConverter;
    private Map _cache = new HashMap();

    public synchronized void resetEventDidOccur() {
        this._cache.clear();
    }

    public synchronized void reportStatus(ReportStatusEvent event) {
        event.title(this._serviceId);
        event.property("parsed script count", this._cache.size());
        event.collection("parsed scripts", this._cache.keySet());
    }

    public synchronized IScript getScript(Resource resource) {
        IScript result = (IScript)this._cache.get(resource);
        if (result != null) {
            return result;
        }
        result = this.parse(resource);
        this._cache.put(resource, result);
        return result;
    }

    private IScript parse(Resource resource) {
        ScriptParser parser = new ScriptParser(this._classResolver, this._expressionEvaluator, this._valueConverter);
        try {
            return parser.parse(resource);
        }
        catch (DocumentParseException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("DefaultScriptSource.unable-to-parse-script", resource), (Throwable)((Object)ex));
        }
    }

    public void setClassResolver(ClassResolver classResolver) {
        this._classResolver = classResolver;
    }

    public void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
        this._expressionEvaluator = expressionEvaluator;
    }

    public void setValueConverter(ValueConverter valueConverter) {
        this._valueConverter = valueConverter;
    }

    public void setServiceId(String serviceId) {
        this._serviceId = serviceId;
    }
}

