/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import java.util.HashMap;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.enhance.EnhanceMessages;
import org.apache.tapestry.enhance.EnhancementOperation;

public class EnhanceUtils {
    public static final MethodSignature FINISH_LOAD_SIGNATURE = new MethodSignature(Void.TYPE, "finishLoad", new Class[]{class$org$apache$tapestry$IRequestCycle == null ? (class$org$apache$tapestry$IRequestCycle = EnhanceUtils.class$("org.apache.tapestry.IRequestCycle")) : class$org$apache$tapestry$IRequestCycle, class$org$apache$tapestry$engine$IPageLoader == null ? (class$org$apache$tapestry$engine$IPageLoader = EnhanceUtils.class$("org.apache.tapestry.engine.IPageLoader")) : class$org$apache$tapestry$engine$IPageLoader, class$org$apache$tapestry$spec$IComponentSpecification == null ? (class$org$apache$tapestry$spec$IComponentSpecification = EnhanceUtils.class$("org.apache.tapestry.spec.IComponentSpecification")) : class$org$apache$tapestry$spec$IComponentSpecification}, null);
    public static final MethodSignature PAGE_DETACHED_SIGNATURE = new MethodSignature(Void.TYPE, "pageDetached", new Class[]{class$org$apache$tapestry$event$PageEvent == null ? (class$org$apache$tapestry$event$PageEvent = EnhanceUtils.class$("org.apache.tapestry.event.PageEvent")) : class$org$apache$tapestry$event$PageEvent}, null);
    public static final MethodSignature CLEANUP_AFTER_RENDER_SIGNATURE = new MethodSignature(Void.TYPE, "cleanupAfterRender", new Class[]{class$org$apache$tapestry$IRequestCycle == null ? (class$org$apache$tapestry$IRequestCycle = EnhanceUtils.class$("org.apache.tapestry.IRequestCycle")) : class$org$apache$tapestry$IRequestCycle}, null);
    private static Map _unwrappers = new HashMap();
    static /* synthetic */ Class class$org$apache$tapestry$IRequestCycle;
    static /* synthetic */ Class class$org$apache$tapestry$engine$IPageLoader;
    static /* synthetic */ Class class$org$apache$tapestry$spec$IComponentSpecification;
    static /* synthetic */ Class class$org$apache$tapestry$event$PageEvent;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$org$apache$tapestry$enhance$EnhanceUtils;

    public static String createMutatorMethodName(String propertyName) {
        return "set" + EnhanceUtils.upcase(propertyName);
    }

    public static String createAccessorMethodName(String propertyName) {
        return "get" + EnhanceUtils.upcase(propertyName);
    }

    private static String upcase(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static void createSimpleAccessor(EnhancementOperation op, String fieldName, String propertyName, Class propertyType, Location location) {
        String methodName = op.getAccessorMethodName(propertyName);
        op.addMethod(1, new MethodSignature(propertyType, methodName, null, null), "return " + fieldName + ";", location);
    }

    public static void createSimpleMutator(EnhancementOperation op, String fieldName, String propertyName, Class propertyType, Location location) {
        String methodName = EnhanceUtils.createMutatorMethodName(propertyName);
        op.addMethod(1, new MethodSignature(Void.TYPE, methodName, new Class[]{propertyType}, null), fieldName + " = $1;", location);
    }

    public static Class extractPropertyType(EnhancementOperation op, String propertyName, String definedTypeName) {
        Defense.notNull((Object)op, (String)"op");
        Defense.notNull((Object)propertyName, (String)"propertyName");
        if (definedTypeName != null) {
            Class propertyType = op.convertTypeName(definedTypeName);
            op.validateProperty(propertyName, propertyType);
            return propertyType;
        }
        Class propertyType = op.getPropertyType(propertyName);
        Class clazz = propertyType == null ? (class$java$lang$Object == null ? (class$java$lang$Object = EnhanceUtils.class$("java.lang.Object")) : class$java$lang$Object) : propertyType;
        return clazz;
    }

    public static boolean toBoolean(IBinding binding) {
        Boolean wrapped = (Boolean)binding.getObject(class$java$lang$Boolean == null ? (class$java$lang$Boolean = EnhanceUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        return wrapped == null ? false : wrapped;
    }

    public static byte toByte(IBinding binding) {
        Byte wrapped = (Byte)binding.getObject(class$java$lang$Byte == null ? (class$java$lang$Byte = EnhanceUtils.class$("java.lang.Byte")) : class$java$lang$Byte);
        return wrapped == null ? (byte)0 : wrapped;
    }

    public static char toChar(IBinding binding) {
        Character wrapped = (Character)binding.getObject(class$java$lang$Character == null ? (class$java$lang$Character = EnhanceUtils.class$("java.lang.Character")) : class$java$lang$Character);
        return wrapped == null ? (char)'\u0000' : wrapped.charValue();
    }

    public static short toShort(IBinding binding) {
        Short wrapped = (Short)binding.getObject(class$java$lang$Short == null ? (class$java$lang$Short = EnhanceUtils.class$("java.lang.Short")) : class$java$lang$Short);
        return wrapped == null ? (short)0 : wrapped;
    }

    public static int toInt(IBinding binding) {
        Integer wrapped = (Integer)binding.getObject(class$java$lang$Integer == null ? (class$java$lang$Integer = EnhanceUtils.class$("java.lang.Integer")) : class$java$lang$Integer);
        return wrapped == null ? 0 : wrapped;
    }

    public static long toLong(IBinding binding) {
        Long wrapped = (Long)binding.getObject(class$java$lang$Long == null ? (class$java$lang$Long = EnhanceUtils.class$("java.lang.Long")) : class$java$lang$Long);
        return wrapped == null ? 0L : wrapped;
    }

    public static float toFloat(IBinding binding) {
        Float wrapped = (Float)binding.getObject(class$java$lang$Float == null ? (class$java$lang$Float = EnhanceUtils.class$("java.lang.Float")) : class$java$lang$Float);
        return wrapped == null ? 0.0f : wrapped.floatValue();
    }

    public static double toDouble(IBinding binding) {
        Double wrapped = (Double)binding.getObject(class$java$lang$Double == null ? (class$java$lang$Double = EnhanceUtils.class$("java.lang.Double")) : class$java$lang$Double);
        return wrapped == null ? 0.0 : wrapped;
    }

    public static String getUnwrapperMethodName(Class type) {
        Defense.notNull((Object)type, (String)"type");
        return (String)_unwrappers.get(type);
    }

    public static String createUnwrapExpression(EnhancementOperation op, String bindingName, Class valueType) {
        Defense.notNull((Object)op, (String)"op");
        Defense.notNull((Object)bindingName, (String)"bindingName");
        Defense.notNull((Object)valueType, (String)"valueType");
        StringBuffer buffer = new StringBuffer();
        String unwrapper = EnhanceUtils.getUnwrapperMethodName(valueType);
        if (unwrapper == null) {
            String propertyTypeRef = op.getClassReference(valueType);
            buffer.append("(");
            buffer.append(ClassFabUtils.getJavaClassName((Class)valueType));
            buffer.append(") ");
            buffer.append(bindingName);
            buffer.append(".getObject(");
            buffer.append(propertyTypeRef);
            buffer.append(")");
        } else {
            buffer.append((class$org$apache$tapestry$enhance$EnhanceUtils == null ? (class$org$apache$tapestry$enhance$EnhanceUtils = EnhanceUtils.class$("org.apache.tapestry.enhance.EnhanceUtils")) : class$org$apache$tapestry$enhance$EnhanceUtils).getName());
            buffer.append(".");
            buffer.append(unwrapper);
            buffer.append("(");
            buffer.append(bindingName);
            buffer.append(")");
        }
        return buffer.toString();
    }

    public static Class verifyPropertyType(EnhancementOperation op, String propertyName, Class requiredType) {
        Defense.notNull((Object)op, (String)"op");
        Defense.notNull((Object)propertyName, (String)"propertyName");
        Defense.notNull((Object)requiredType, (String)"requiredType");
        Class propertyType = op.getPropertyType(propertyName);
        if (propertyType == null) {
            return class$java$lang$Object == null ? (class$java$lang$Object = EnhanceUtils.class$("java.lang.Object")) : class$java$lang$Object;
        }
        if (!propertyType.isAssignableFrom(requiredType)) {
            throw new ApplicationRuntimeException(EnhanceMessages.wrongTypeForProperty(propertyName, propertyType, requiredType));
        }
        return propertyType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _unwrappers.put(Boolean.TYPE, "toBoolean");
        _unwrappers.put(Byte.TYPE, "toByte");
        _unwrappers.put(Character.TYPE, "toChar");
        _unwrappers.put(Short.TYPE, "toShort");
        _unwrappers.put(Integer.TYPE, "toInt");
        _unwrappers.put(Long.TYPE, "toLong");
        _unwrappers.put(Float.TYPE, "toFloat");
        _unwrappers.put(Double.TYPE, "toDouble");
    }
}

